// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the format and location of the input data for the dataset.
 */
public class DatasetInputDataConfig private constructor(builder: Builder) {
    /**
     * A list of augmented manifest files that provide training data for your custom model. An augmented manifest file is a labeled dataset that is produced by Amazon SageMaker Ground Truth.
     */
    public val augmentedManifests: List<DatasetAugmentedManifestsListItem>? = builder.augmentedManifests
    /**
     * `COMPREHEND_CSV`: The data format is a two-column CSV file, where the first column contains labels and the second column contains documents.
     *
     * `AUGMENTED_MANIFEST`: The data format
     */
    public val dataFormat: aws.sdk.kotlin.services.comprehend.model.DatasetDataFormat? = builder.dataFormat
    /**
     * The input properties for training a document classifier model.
     *
     * For more information on how the input file is formatted, see [Preparing training data](https://docs.aws.amazon.com/comprehend/latest/dg/prep-classifier-data.html) in the Comprehend Developer Guide.
     */
    public val documentClassifierInputDataConfig: aws.sdk.kotlin.services.comprehend.model.DatasetDocumentClassifierInputDataConfig? = builder.documentClassifierInputDataConfig
    /**
     * The input properties for training an entity recognizer model.
     */
    public val entityRecognizerInputDataConfig: aws.sdk.kotlin.services.comprehend.model.DatasetEntityRecognizerInputDataConfig? = builder.entityRecognizerInputDataConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.DatasetInputDataConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DatasetInputDataConfig(")
        append("augmentedManifests=$augmentedManifests,")
        append("dataFormat=$dataFormat,")
        append("documentClassifierInputDataConfig=$documentClassifierInputDataConfig,")
        append("entityRecognizerInputDataConfig=$entityRecognizerInputDataConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = augmentedManifests?.hashCode() ?: 0
        result = 31 * result + (dataFormat?.hashCode() ?: 0)
        result = 31 * result + (documentClassifierInputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (entityRecognizerInputDataConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DatasetInputDataConfig

        if (augmentedManifests != other.augmentedManifests) return false
        if (dataFormat != other.dataFormat) return false
        if (documentClassifierInputDataConfig != other.documentClassifierInputDataConfig) return false
        if (entityRecognizerInputDataConfig != other.entityRecognizerInputDataConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.DatasetInputDataConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of augmented manifest files that provide training data for your custom model. An augmented manifest file is a labeled dataset that is produced by Amazon SageMaker Ground Truth.
         */
        public var augmentedManifests: List<DatasetAugmentedManifestsListItem>? = null
        /**
         * `COMPREHEND_CSV`: The data format is a two-column CSV file, where the first column contains labels and the second column contains documents.
         *
         * `AUGMENTED_MANIFEST`: The data format
         */
        public var dataFormat: aws.sdk.kotlin.services.comprehend.model.DatasetDataFormat? = null
        /**
         * The input properties for training a document classifier model.
         *
         * For more information on how the input file is formatted, see [Preparing training data](https://docs.aws.amazon.com/comprehend/latest/dg/prep-classifier-data.html) in the Comprehend Developer Guide.
         */
        public var documentClassifierInputDataConfig: aws.sdk.kotlin.services.comprehend.model.DatasetDocumentClassifierInputDataConfig? = null
        /**
         * The input properties for training an entity recognizer model.
         */
        public var entityRecognizerInputDataConfig: aws.sdk.kotlin.services.comprehend.model.DatasetEntityRecognizerInputDataConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.DatasetInputDataConfig) : this() {
            this.augmentedManifests = x.augmentedManifests
            this.dataFormat = x.dataFormat
            this.documentClassifierInputDataConfig = x.documentClassifierInputDataConfig
            this.entityRecognizerInputDataConfig = x.entityRecognizerInputDataConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.DatasetInputDataConfig = DatasetInputDataConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.DatasetDocumentClassifierInputDataConfig] inside the given [block]
         */
        public fun documentClassifierInputDataConfig(block: aws.sdk.kotlin.services.comprehend.model.DatasetDocumentClassifierInputDataConfig.Builder.() -> kotlin.Unit) {
            this.documentClassifierInputDataConfig = aws.sdk.kotlin.services.comprehend.model.DatasetDocumentClassifierInputDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.DatasetEntityRecognizerInputDataConfig] inside the given [block]
         */
        public fun entityRecognizerInputDataConfig(block: aws.sdk.kotlin.services.comprehend.model.DatasetEntityRecognizerInputDataConfig.Builder.() -> kotlin.Unit) {
            this.entityRecognizerInputDataConfig = aws.sdk.kotlin.services.comprehend.model.DatasetEntityRecognizerInputDataConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
