// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about one mention of an entity. The mention information includes the location of the mention in the text and the sentiment of the mention.
 *
 * For more information about targeted sentiment, see [Targeted sentiment](https://docs.aws.amazon.com/comprehend/latest/dg/how-targeted-sentiment.html) in the *Amazon Comprehend Developer Guide*.
 */
public class TargetedSentimentMention private constructor(builder: Builder) {
    /**
     * The offset into the document text where the mention begins.
     */
    public val beginOffset: kotlin.Int? = builder.beginOffset
    /**
     * The offset into the document text where the mention ends.
     */
    public val endOffset: kotlin.Int? = builder.endOffset
    /**
     * The confidence that all the entities mentioned in the group relate to the same entity.
     */
    public val groupScore: kotlin.Float? = builder.groupScore
    /**
     * Contains the sentiment and sentiment score for the mention.
     */
    public val mentionSentiment: aws.sdk.kotlin.services.comprehend.model.MentionSentiment? = builder.mentionSentiment
    /**
     * Model confidence that the entity is relevant. Value range is zero to one, where one is highest confidence.
     */
    public val score: kotlin.Float? = builder.score
    /**
     * The text in the document that identifies the entity.
     */
    public val text: kotlin.String? = builder.text
    /**
     * The type of the entity. Amazon Comprehend supports a variety of [entity types](https://docs.aws.amazon.com/comprehend/latest/dg/how-targeted-sentiment.html#how-targeted-sentiment-entities).
     */
    public val type: aws.sdk.kotlin.services.comprehend.model.TargetedSentimentEntityType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.TargetedSentimentMention = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TargetedSentimentMention(")
        append("beginOffset=$beginOffset,")
        append("endOffset=$endOffset,")
        append("groupScore=$groupScore,")
        append("mentionSentiment=$mentionSentiment,")
        append("score=$score,")
        append("text=$text,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = beginOffset ?: 0
        result = 31 * result + (endOffset ?: 0)
        result = 31 * result + (groupScore?.hashCode() ?: 0)
        result = 31 * result + (mentionSentiment?.hashCode() ?: 0)
        result = 31 * result + (score?.hashCode() ?: 0)
        result = 31 * result + (text?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TargetedSentimentMention

        if (beginOffset != other.beginOffset) return false
        if (endOffset != other.endOffset) return false
        if (groupScore != other.groupScore) return false
        if (mentionSentiment != other.mentionSentiment) return false
        if (score != other.score) return false
        if (text != other.text) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.TargetedSentimentMention = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The offset into the document text where the mention begins.
         */
        public var beginOffset: kotlin.Int? = null
        /**
         * The offset into the document text where the mention ends.
         */
        public var endOffset: kotlin.Int? = null
        /**
         * The confidence that all the entities mentioned in the group relate to the same entity.
         */
        public var groupScore: kotlin.Float? = null
        /**
         * Contains the sentiment and sentiment score for the mention.
         */
        public var mentionSentiment: aws.sdk.kotlin.services.comprehend.model.MentionSentiment? = null
        /**
         * Model confidence that the entity is relevant. Value range is zero to one, where one is highest confidence.
         */
        public var score: kotlin.Float? = null
        /**
         * The text in the document that identifies the entity.
         */
        public var text: kotlin.String? = null
        /**
         * The type of the entity. Amazon Comprehend supports a variety of [entity types](https://docs.aws.amazon.com/comprehend/latest/dg/how-targeted-sentiment.html#how-targeted-sentiment-entities).
         */
        public var type: aws.sdk.kotlin.services.comprehend.model.TargetedSentimentEntityType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.TargetedSentimentMention) : this() {
            this.beginOffset = x.beginOffset
            this.endOffset = x.endOffset
            this.groupScore = x.groupScore
            this.mentionSentiment = x.mentionSentiment
            this.score = x.score
            this.text = x.text
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.TargetedSentimentMention = TargetedSentimentMention(this)

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.MentionSentiment] inside the given [block]
         */
        public fun mentionSentiment(block: aws.sdk.kotlin.services.comprehend.model.MentionSentiment.Builder.() -> kotlin.Unit) {
            this.mentionSentiment = aws.sdk.kotlin.services.comprehend.model.MentionSentiment.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
