// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the result metrics for the test data associated with an documentation classifier.
 */
public class ClassifierEvaluationMetrics private constructor(builder: Builder) {
    /**
     * The fraction of the labels that were correct recognized. It is computed by dividing the number of labels in the test documents that were correctly recognized by the total number of labels in the test documents.
     */
    public val accuracy: kotlin.Double? = builder.accuracy
    /**
     * A measure of how accurate the classifier results are for the test data. It is derived from the `Precision` and `Recall` values. The `F1Score` is the harmonic average of the two scores. The highest score is 1, and the worst score is 0.
     */
    public val f1Score: kotlin.Double? = builder.f1Score
    /**
     * Indicates the fraction of labels that are incorrectly predicted. Also seen as the fraction of wrong labels compared to the total number of labels. Scores closer to zero are better.
     */
    public val hammingLoss: kotlin.Double? = builder.hammingLoss
    /**
     * A measure of how accurate the classifier results are for the test data. It is a combination of the `Micro Precision` and `Micro Recall` values. The `Micro F1Score` is the harmonic mean of the two scores. The highest score is 1, and the worst score is 0.
     */
    public val microF1Score: kotlin.Double? = builder.microF1Score
    /**
     * A measure of the usefulness of the recognizer results in the test data. High precision means that the recognizer returned substantially more relevant results than irrelevant ones. Unlike the Precision metric which comes from averaging the precision of all available labels, this is based on the overall score of all precision scores added together.
     */
    public val microPrecision: kotlin.Double? = builder.microPrecision
    /**
     * A measure of how complete the classifier results are for the test data. High recall means that the classifier returned most of the relevant results. Specifically, this indicates how many of the correct categories in the text that the model can predict. It is a percentage of correct categories in the text that can found. Instead of averaging the recall scores of all labels (as with Recall), micro Recall is based on the overall score of all recall scores added together.
     */
    public val microRecall: kotlin.Double? = builder.microRecall
    /**
     * A measure of the usefulness of the classifier results in the test data. High precision means that the classifier returned substantially more relevant results than irrelevant ones.
     */
    public val precision: kotlin.Double? = builder.precision
    /**
     * A measure of how complete the classifier results are for the test data. High recall means that the classifier returned most of the relevant results.
     */
    public val recall: kotlin.Double? = builder.recall

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.ClassifierEvaluationMetrics = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClassifierEvaluationMetrics(")
        append("accuracy=$accuracy,")
        append("f1Score=$f1Score,")
        append("hammingLoss=$hammingLoss,")
        append("microF1Score=$microF1Score,")
        append("microPrecision=$microPrecision,")
        append("microRecall=$microRecall,")
        append("precision=$precision,")
        append("recall=$recall")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accuracy?.hashCode() ?: 0
        result = 31 * result + (f1Score?.hashCode() ?: 0)
        result = 31 * result + (hammingLoss?.hashCode() ?: 0)
        result = 31 * result + (microF1Score?.hashCode() ?: 0)
        result = 31 * result + (microPrecision?.hashCode() ?: 0)
        result = 31 * result + (microRecall?.hashCode() ?: 0)
        result = 31 * result + (precision?.hashCode() ?: 0)
        result = 31 * result + (recall?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClassifierEvaluationMetrics

        if (accuracy != other.accuracy) return false
        if (f1Score != other.f1Score) return false
        if (hammingLoss != other.hammingLoss) return false
        if (microF1Score != other.microF1Score) return false
        if (microPrecision != other.microPrecision) return false
        if (microRecall != other.microRecall) return false
        if (precision != other.precision) return false
        if (recall != other.recall) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.ClassifierEvaluationMetrics = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The fraction of the labels that were correct recognized. It is computed by dividing the number of labels in the test documents that were correctly recognized by the total number of labels in the test documents.
         */
        public var accuracy: kotlin.Double? = null
        /**
         * A measure of how accurate the classifier results are for the test data. It is derived from the `Precision` and `Recall` values. The `F1Score` is the harmonic average of the two scores. The highest score is 1, and the worst score is 0.
         */
        public var f1Score: kotlin.Double? = null
        /**
         * Indicates the fraction of labels that are incorrectly predicted. Also seen as the fraction of wrong labels compared to the total number of labels. Scores closer to zero are better.
         */
        public var hammingLoss: kotlin.Double? = null
        /**
         * A measure of how accurate the classifier results are for the test data. It is a combination of the `Micro Precision` and `Micro Recall` values. The `Micro F1Score` is the harmonic mean of the two scores. The highest score is 1, and the worst score is 0.
         */
        public var microF1Score: kotlin.Double? = null
        /**
         * A measure of the usefulness of the recognizer results in the test data. High precision means that the recognizer returned substantially more relevant results than irrelevant ones. Unlike the Precision metric which comes from averaging the precision of all available labels, this is based on the overall score of all precision scores added together.
         */
        public var microPrecision: kotlin.Double? = null
        /**
         * A measure of how complete the classifier results are for the test data. High recall means that the classifier returned most of the relevant results. Specifically, this indicates how many of the correct categories in the text that the model can predict. It is a percentage of correct categories in the text that can found. Instead of averaging the recall scores of all labels (as with Recall), micro Recall is based on the overall score of all recall scores added together.
         */
        public var microRecall: kotlin.Double? = null
        /**
         * A measure of the usefulness of the classifier results in the test data. High precision means that the classifier returned substantially more relevant results than irrelevant ones.
         */
        public var precision: kotlin.Double? = null
        /**
         * A measure of how complete the classifier results are for the test data. High recall means that the classifier returned most of the relevant results.
         */
        public var recall: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.ClassifierEvaluationMetrics) : this() {
            this.accuracy = x.accuracy
            this.f1Score = x.f1Score
            this.hammingLoss = x.hammingLoss
            this.microF1Score = x.microF1Score
            this.microPrecision = x.microPrecision
            this.microRecall = x.microRecall
            this.precision = x.precision
            this.recall = x.recall
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.ClassifierEvaluationMetrics = ClassifierEvaluationMetrics(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
