// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model



public class StartPiiEntitiesDetectionJobRequest private constructor(builder: Builder) {
    /**
     * A unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates one.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data.
     */
    public val dataAccessRoleArn: kotlin.String? = builder.dataAccessRoleArn
    /**
     * The input properties for a PII entities detection job.
     */
    public val inputDataConfig: aws.sdk.kotlin.services.comprehend.model.InputDataConfig? = builder.inputDataConfig
    /**
     * The identifier of the job.
     */
    public val jobName: kotlin.String? = builder.jobName
    /**
     * The language of the input documents. Enter the language code for English (en) or Spanish (es).
     */
    public val languageCode: aws.sdk.kotlin.services.comprehend.model.LanguageCode? = builder.languageCode
    /**
     * Specifies whether the output provides the locations (offsets) of PII entities or a file in which PII entities are redacted.
     */
    public val mode: aws.sdk.kotlin.services.comprehend.model.PiiEntitiesDetectionMode? = builder.mode
    /**
     * Provides conﬁguration parameters for the output of PII entity detection jobs.
     */
    public val outputDataConfig: aws.sdk.kotlin.services.comprehend.model.OutputDataConfig? = builder.outputDataConfig
    /**
     * Provides configuration parameters for PII entity redaction.
     *
     * This parameter is required if you set the `Mode` parameter to `ONLY_REDACTION`. In that case, you must provide a `RedactionConfig` definition that includes the `PiiEntityTypes` parameter.
     */
    public val redactionConfig: aws.sdk.kotlin.services.comprehend.model.RedactionConfig? = builder.redactionConfig
    /**
     * Tags to associate with the PII entities detection job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.StartPiiEntitiesDetectionJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartPiiEntitiesDetectionJobRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("dataAccessRoleArn=$dataAccessRoleArn,")
        append("inputDataConfig=$inputDataConfig,")
        append("jobName=$jobName,")
        append("languageCode=$languageCode,")
        append("mode=$mode,")
        append("outputDataConfig=$outputDataConfig,")
        append("redactionConfig=$redactionConfig,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (dataAccessRoleArn?.hashCode() ?: 0)
        result = 31 * result + (inputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (outputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (redactionConfig?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartPiiEntitiesDetectionJobRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (dataAccessRoleArn != other.dataAccessRoleArn) return false
        if (inputDataConfig != other.inputDataConfig) return false
        if (jobName != other.jobName) return false
        if (languageCode != other.languageCode) return false
        if (mode != other.mode) return false
        if (outputDataConfig != other.outputDataConfig) return false
        if (redactionConfig != other.redactionConfig) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.StartPiiEntitiesDetectionJobRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates one.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data.
         */
        public var dataAccessRoleArn: kotlin.String? = null
        /**
         * The input properties for a PII entities detection job.
         */
        public var inputDataConfig: aws.sdk.kotlin.services.comprehend.model.InputDataConfig? = null
        /**
         * The identifier of the job.
         */
        public var jobName: kotlin.String? = null
        /**
         * The language of the input documents. Enter the language code for English (en) or Spanish (es).
         */
        public var languageCode: aws.sdk.kotlin.services.comprehend.model.LanguageCode? = null
        /**
         * Specifies whether the output provides the locations (offsets) of PII entities or a file in which PII entities are redacted.
         */
        public var mode: aws.sdk.kotlin.services.comprehend.model.PiiEntitiesDetectionMode? = null
        /**
         * Provides conﬁguration parameters for the output of PII entity detection jobs.
         */
        public var outputDataConfig: aws.sdk.kotlin.services.comprehend.model.OutputDataConfig? = null
        /**
         * Provides configuration parameters for PII entity redaction.
         *
         * This parameter is required if you set the `Mode` parameter to `ONLY_REDACTION`. In that case, you must provide a `RedactionConfig` definition that includes the `PiiEntityTypes` parameter.
         */
        public var redactionConfig: aws.sdk.kotlin.services.comprehend.model.RedactionConfig? = null
        /**
         * Tags to associate with the PII entities detection job. A tag is a key-value pair that adds metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.StartPiiEntitiesDetectionJobRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.dataAccessRoleArn = x.dataAccessRoleArn
            this.inputDataConfig = x.inputDataConfig
            this.jobName = x.jobName
            this.languageCode = x.languageCode
            this.mode = x.mode
            this.outputDataConfig = x.outputDataConfig
            this.redactionConfig = x.redactionConfig
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.StartPiiEntitiesDetectionJobRequest = StartPiiEntitiesDetectionJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.InputDataConfig] inside the given [block]
         */
        public fun inputDataConfig(block: aws.sdk.kotlin.services.comprehend.model.InputDataConfig.Builder.() -> kotlin.Unit) {
            this.inputDataConfig = aws.sdk.kotlin.services.comprehend.model.InputDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.OutputDataConfig] inside the given [block]
         */
        public fun outputDataConfig(block: aws.sdk.kotlin.services.comprehend.model.OutputDataConfig.Builder.() -> kotlin.Unit) {
            this.outputDataConfig = aws.sdk.kotlin.services.comprehend.model.OutputDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.RedactionConfig] inside the given [block]
         */
        public fun redactionConfig(block: aws.sdk.kotlin.services.comprehend.model.RedactionConfig.Builder.() -> kotlin.Unit) {
            this.redactionConfig = aws.sdk.kotlin.services.comprehend.model.RedactionConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
