// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about a document classifier.
 */
public class DocumentClassifierProperties private constructor(builder: Builder) {
    /**
     * Information about the document classifier, including the number of documents used for training the classifier, the number of documents used for test the classifier, and an accuracy rating.
     */
    public val classifierMetadata: aws.sdk.kotlin.services.comprehend.model.ClassifierMetadata? = builder.classifierMetadata
    /**
     * The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data.
     */
    public val dataAccessRoleArn: kotlin.String? = builder.dataAccessRoleArn
    /**
     * The Amazon Resource Name (ARN) that identifies the document classifier.
     */
    public val documentClassifierArn: kotlin.String? = builder.documentClassifierArn
    /**
     * The time that training the document classifier completed.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The Amazon Resource Number (ARN) of the flywheel
     */
    public val flywheelArn: kotlin.String? = builder.flywheelArn
    /**
     * The input data configuration that you supplied when you created the document classifier for training.
     */
    public val inputDataConfig: aws.sdk.kotlin.services.comprehend.model.DocumentClassifierInputDataConfig? = builder.inputDataConfig
    /**
     * The language code for the language of the documents that the classifier was trained on.
     */
    public val languageCode: aws.sdk.kotlin.services.comprehend.model.LanguageCode? = builder.languageCode
    /**
     * Additional information about the status of the classifier.
     */
    public val message: kotlin.String? = builder.message
    /**
     * Indicates the mode in which the specific classifier was trained. This also indicates the format of input documents and the format of the confusion matrix. Each classifier can only be trained in one mode and this cannot be changed once the classifier is trained.
     */
    public val mode: aws.sdk.kotlin.services.comprehend.model.DocumentClassifierMode? = builder.mode
    /**
     * ID for the KMS key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats:
     * + KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
     * + Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
     */
    public val modelKmsKeyId: kotlin.String? = builder.modelKmsKeyId
    /**
     * Provides output results configuration parameters for custom classifier jobs.
     */
    public val outputDataConfig: aws.sdk.kotlin.services.comprehend.model.DocumentClassifierOutputDataConfig? = builder.outputDataConfig
    /**
     * The Amazon Resource Name (ARN) of the source model. This model was imported from a different Amazon Web Services account to create the document classifier model in your Amazon Web Services account.
     */
    public val sourceModelArn: kotlin.String? = builder.sourceModelArn
    /**
     * The status of the document classifier. If the status is `TRAINED` the classifier is ready to use. If the status is `TRAINED_WITH_WARNINGS` the classifier training succeeded, but you should review the warnings returned in the `CreateDocumentClassifier` response.
     *
     *  If the status is `FAILED` you can see additional information about why the classifier wasn't trained in the `Message` field.
     */
    public val status: aws.sdk.kotlin.services.comprehend.model.ModelStatus? = builder.status
    /**
     * The time that the document classifier was submitted for training.
     */
    public val submitTime: aws.smithy.kotlin.runtime.time.Instant? = builder.submitTime
    /**
     * The time that training of the document classifier was completed. Indicates the time when the training completes on documentation classifiers. You are billed for the time interval between this time and the value of TrainingStartTime.
     */
    public val trainingEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.trainingEndTime
    /**
     * Indicates the time when the training starts on documentation classifiers. You are billed for the time interval between this time and the value of TrainingEndTime.
     */
    public val trainingStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.trainingStartTime
    /**
     * The version name that you assigned to the document classifier.
     */
    public val versionName: kotlin.String? = builder.versionName
    /**
     * ID for the Amazon Web Services Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:
     * + KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
     * + Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
     */
    public val volumeKmsKeyId: kotlin.String? = builder.volumeKmsKeyId
    /**
     * Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for your custom classifier. For more information, see [Amazon VPC](https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
     */
    public val vpcConfig: aws.sdk.kotlin.services.comprehend.model.VpcConfig? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.DocumentClassifierProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DocumentClassifierProperties(")
        append("classifierMetadata=*** Sensitive Data Redacted ***,")
        append("dataAccessRoleArn=$dataAccessRoleArn,")
        append("documentClassifierArn=$documentClassifierArn,")
        append("endTime=$endTime,")
        append("flywheelArn=$flywheelArn,")
        append("inputDataConfig=$inputDataConfig,")
        append("languageCode=$languageCode,")
        append("message=$message,")
        append("mode=$mode,")
        append("modelKmsKeyId=$modelKmsKeyId,")
        append("outputDataConfig=$outputDataConfig,")
        append("sourceModelArn=$sourceModelArn,")
        append("status=$status,")
        append("submitTime=$submitTime,")
        append("trainingEndTime=$trainingEndTime,")
        append("trainingStartTime=$trainingStartTime,")
        append("versionName=$versionName,")
        append("volumeKmsKeyId=$volumeKmsKeyId,")
        append("vpcConfig=$vpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = classifierMetadata?.hashCode() ?: 0
        result = 31 * result + (dataAccessRoleArn?.hashCode() ?: 0)
        result = 31 * result + (documentClassifierArn?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (flywheelArn?.hashCode() ?: 0)
        result = 31 * result + (inputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (modelKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (outputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (sourceModelArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (submitTime?.hashCode() ?: 0)
        result = 31 * result + (trainingEndTime?.hashCode() ?: 0)
        result = 31 * result + (trainingStartTime?.hashCode() ?: 0)
        result = 31 * result + (versionName?.hashCode() ?: 0)
        result = 31 * result + (volumeKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DocumentClassifierProperties

        if (classifierMetadata != other.classifierMetadata) return false
        if (dataAccessRoleArn != other.dataAccessRoleArn) return false
        if (documentClassifierArn != other.documentClassifierArn) return false
        if (endTime != other.endTime) return false
        if (flywheelArn != other.flywheelArn) return false
        if (inputDataConfig != other.inputDataConfig) return false
        if (languageCode != other.languageCode) return false
        if (message != other.message) return false
        if (mode != other.mode) return false
        if (modelKmsKeyId != other.modelKmsKeyId) return false
        if (outputDataConfig != other.outputDataConfig) return false
        if (sourceModelArn != other.sourceModelArn) return false
        if (status != other.status) return false
        if (submitTime != other.submitTime) return false
        if (trainingEndTime != other.trainingEndTime) return false
        if (trainingStartTime != other.trainingStartTime) return false
        if (versionName != other.versionName) return false
        if (volumeKmsKeyId != other.volumeKmsKeyId) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.DocumentClassifierProperties = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Information about the document classifier, including the number of documents used for training the classifier, the number of documents used for test the classifier, and an accuracy rating.
         */
        public var classifierMetadata: aws.sdk.kotlin.services.comprehend.model.ClassifierMetadata? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data.
         */
        public var dataAccessRoleArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) that identifies the document classifier.
         */
        public var documentClassifierArn: kotlin.String? = null
        /**
         * The time that training the document classifier completed.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Number (ARN) of the flywheel
         */
        public var flywheelArn: kotlin.String? = null
        /**
         * The input data configuration that you supplied when you created the document classifier for training.
         */
        public var inputDataConfig: aws.sdk.kotlin.services.comprehend.model.DocumentClassifierInputDataConfig? = null
        /**
         * The language code for the language of the documents that the classifier was trained on.
         */
        public var languageCode: aws.sdk.kotlin.services.comprehend.model.LanguageCode? = null
        /**
         * Additional information about the status of the classifier.
         */
        public var message: kotlin.String? = null
        /**
         * Indicates the mode in which the specific classifier was trained. This also indicates the format of input documents and the format of the confusion matrix. Each classifier can only be trained in one mode and this cannot be changed once the classifier is trained.
         */
        public var mode: aws.sdk.kotlin.services.comprehend.model.DocumentClassifierMode? = null
        /**
         * ID for the KMS key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats:
         * + KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
         * + Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
         */
        public var modelKmsKeyId: kotlin.String? = null
        /**
         * Provides output results configuration parameters for custom classifier jobs.
         */
        public var outputDataConfig: aws.sdk.kotlin.services.comprehend.model.DocumentClassifierOutputDataConfig? = null
        /**
         * The Amazon Resource Name (ARN) of the source model. This model was imported from a different Amazon Web Services account to create the document classifier model in your Amazon Web Services account.
         */
        public var sourceModelArn: kotlin.String? = null
        /**
         * The status of the document classifier. If the status is `TRAINED` the classifier is ready to use. If the status is `TRAINED_WITH_WARNINGS` the classifier training succeeded, but you should review the warnings returned in the `CreateDocumentClassifier` response.
         *
         *  If the status is `FAILED` you can see additional information about why the classifier wasn't trained in the `Message` field.
         */
        public var status: aws.sdk.kotlin.services.comprehend.model.ModelStatus? = null
        /**
         * The time that the document classifier was submitted for training.
         */
        public var submitTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time that training of the document classifier was completed. Indicates the time when the training completes on documentation classifiers. You are billed for the time interval between this time and the value of TrainingStartTime.
         */
        public var trainingEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Indicates the time when the training starts on documentation classifiers. You are billed for the time interval between this time and the value of TrainingEndTime.
         */
        public var trainingStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The version name that you assigned to the document classifier.
         */
        public var versionName: kotlin.String? = null
        /**
         * ID for the Amazon Web Services Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:
         * + KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
         * + Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
         */
        public var volumeKmsKeyId: kotlin.String? = null
        /**
         * Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for your custom classifier. For more information, see [Amazon VPC](https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
         */
        public var vpcConfig: aws.sdk.kotlin.services.comprehend.model.VpcConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.DocumentClassifierProperties) : this() {
            this.classifierMetadata = x.classifierMetadata
            this.dataAccessRoleArn = x.dataAccessRoleArn
            this.documentClassifierArn = x.documentClassifierArn
            this.endTime = x.endTime
            this.flywheelArn = x.flywheelArn
            this.inputDataConfig = x.inputDataConfig
            this.languageCode = x.languageCode
            this.message = x.message
            this.mode = x.mode
            this.modelKmsKeyId = x.modelKmsKeyId
            this.outputDataConfig = x.outputDataConfig
            this.sourceModelArn = x.sourceModelArn
            this.status = x.status
            this.submitTime = x.submitTime
            this.trainingEndTime = x.trainingEndTime
            this.trainingStartTime = x.trainingStartTime
            this.versionName = x.versionName
            this.volumeKmsKeyId = x.volumeKmsKeyId
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.DocumentClassifierProperties = DocumentClassifierProperties(this)

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.ClassifierMetadata] inside the given [block]
         */
        public fun classifierMetadata(block: aws.sdk.kotlin.services.comprehend.model.ClassifierMetadata.Builder.() -> kotlin.Unit) {
            this.classifierMetadata = aws.sdk.kotlin.services.comprehend.model.ClassifierMetadata.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.DocumentClassifierInputDataConfig] inside the given [block]
         */
        public fun inputDataConfig(block: aws.sdk.kotlin.services.comprehend.model.DocumentClassifierInputDataConfig.Builder.() -> kotlin.Unit) {
            this.inputDataConfig = aws.sdk.kotlin.services.comprehend.model.DocumentClassifierInputDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.DocumentClassifierOutputDataConfig] inside the given [block]
         */
        public fun outputDataConfig(block: aws.sdk.kotlin.services.comprehend.model.DocumentClassifierOutputDataConfig.Builder.() -> kotlin.Unit) {
            this.outputDataConfig = aws.sdk.kotlin.services.comprehend.model.DocumentClassifierOutputDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.VpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.comprehend.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.comprehend.model.VpcConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
