// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model



public class DetectEntitiesRequest private constructor(builder: Builder) {
    /**
     * This field applies only when you use a custom entity recognition model that was trained with PDF annotations. For other cases, enter your text input in the `Text` field.
     *
     *  Use the `Bytes` parameter to input a text, PDF, Word or image file. Using a plain-text file in the `Bytes` parameter is equivelent to using the `Text` parameter (the `Entities` field in the response is identical).
     *
     * You can also use the `Bytes` parameter to input an Amazon Textract `DetectDocumentText` or `AnalyzeDocument` output file.
     *
     * Provide the input document as a sequence of base64-encoded bytes. If your code uses an Amazon Web Services SDK to detect entities, the SDK may encode the document file bytes for you.
     *
     * The maximum length of this field depends on the input document type. For details, see [ Inputs for real-time custom analysis](https://docs.aws.amazon.com/comprehend/latest/dg/idp-inputs-sync.html) in the Comprehend Developer Guide.
     *
     * If you use the `Bytes` parameter, do not use the `Text` parameter.
     */
    public val bytes: kotlin.ByteArray? = builder.bytes
    /**
     * Provides configuration parameters to override the default actions for extracting text from PDF documents and image files.
     */
    public val documentReaderConfig: aws.sdk.kotlin.services.comprehend.model.DocumentReaderConfig? = builder.documentReaderConfig
    /**
     * The Amazon Resource Name of an endpoint that is associated with a custom entity recognition model. Provide an endpoint if you want to detect entities by using your own custom model instead of the default model that is used by Amazon Comprehend.
     *
     * If you specify an endpoint, Amazon Comprehend uses the language of your custom model, and it ignores any language code that you provide in your request.
     *
     * For information about endpoints, see [Managing endpoints](https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html).
     */
    public val endpointArn: kotlin.String? = builder.endpointArn
    /**
     * The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. If your request includes the endpoint for a custom entity recognition model, Amazon Comprehend uses the language of your custom model, and it ignores any language code that you specify here.
     *
     * All input documents must be in the same language.
     */
    public val languageCode: aws.sdk.kotlin.services.comprehend.model.LanguageCode? = builder.languageCode
    /**
     * A UTF-8 text string. The maximum string size is 100 KB. If you enter text using this parameter, do not use the `Bytes` parameter.
     */
    public val text: kotlin.String? = builder.text

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.DetectEntitiesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DetectEntitiesRequest(")
        append("bytes=$bytes,")
        append("documentReaderConfig=$documentReaderConfig,")
        append("endpointArn=$endpointArn,")
        append("languageCode=$languageCode,")
        append("text=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bytes?.contentHashCode() ?: 0
        result = 31 * result + (documentReaderConfig?.hashCode() ?: 0)
        result = 31 * result + (endpointArn?.hashCode() ?: 0)
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (text?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DetectEntitiesRequest

        if (bytes != null) {
            if (other.bytes == null) return false
            if (!bytes.contentEquals(other.bytes)) return false
        } else if (other.bytes != null) return false
        if (documentReaderConfig != other.documentReaderConfig) return false
        if (endpointArn != other.endpointArn) return false
        if (languageCode != other.languageCode) return false
        if (text != other.text) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.DetectEntitiesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * This field applies only when you use a custom entity recognition model that was trained with PDF annotations. For other cases, enter your text input in the `Text` field.
         *
         *  Use the `Bytes` parameter to input a text, PDF, Word or image file. Using a plain-text file in the `Bytes` parameter is equivelent to using the `Text` parameter (the `Entities` field in the response is identical).
         *
         * You can also use the `Bytes` parameter to input an Amazon Textract `DetectDocumentText` or `AnalyzeDocument` output file.
         *
         * Provide the input document as a sequence of base64-encoded bytes. If your code uses an Amazon Web Services SDK to detect entities, the SDK may encode the document file bytes for you.
         *
         * The maximum length of this field depends on the input document type. For details, see [ Inputs for real-time custom analysis](https://docs.aws.amazon.com/comprehend/latest/dg/idp-inputs-sync.html) in the Comprehend Developer Guide.
         *
         * If you use the `Bytes` parameter, do not use the `Text` parameter.
         */
        public var bytes: kotlin.ByteArray? = null
        /**
         * Provides configuration parameters to override the default actions for extracting text from PDF documents and image files.
         */
        public var documentReaderConfig: aws.sdk.kotlin.services.comprehend.model.DocumentReaderConfig? = null
        /**
         * The Amazon Resource Name of an endpoint that is associated with a custom entity recognition model. Provide an endpoint if you want to detect entities by using your own custom model instead of the default model that is used by Amazon Comprehend.
         *
         * If you specify an endpoint, Amazon Comprehend uses the language of your custom model, and it ignores any language code that you provide in your request.
         *
         * For information about endpoints, see [Managing endpoints](https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html).
         */
        public var endpointArn: kotlin.String? = null
        /**
         * The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend. If your request includes the endpoint for a custom entity recognition model, Amazon Comprehend uses the language of your custom model, and it ignores any language code that you specify here.
         *
         * All input documents must be in the same language.
         */
        public var languageCode: aws.sdk.kotlin.services.comprehend.model.LanguageCode? = null
        /**
         * A UTF-8 text string. The maximum string size is 100 KB. If you enter text using this parameter, do not use the `Bytes` parameter.
         */
        public var text: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.DetectEntitiesRequest) : this() {
            this.bytes = x.bytes
            this.documentReaderConfig = x.documentReaderConfig
            this.endpointArn = x.endpointArn
            this.languageCode = x.languageCode
            this.text = x.text
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.DetectEntitiesRequest = DetectEntitiesRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.DocumentReaderConfig] inside the given [block]
         */
        public fun documentReaderConfig(block: aws.sdk.kotlin.services.comprehend.model.DocumentReaderConfig.Builder.() -> kotlin.Unit) {
            this.documentReaderConfig = aws.sdk.kotlin.services.comprehend.model.DocumentReaderConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
