// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.serde

import aws.sdk.kotlin.services.comprehend.model.ClassifyDocumentResponse
import aws.sdk.kotlin.services.comprehend.model.ComprehendException
import aws.sdk.kotlin.services.comprehend.model.DocumentClass
import aws.sdk.kotlin.services.comprehend.model.DocumentLabel
import aws.sdk.kotlin.services.comprehend.model.DocumentMetadata
import aws.sdk.kotlin.services.comprehend.model.DocumentTypeListItem
import aws.sdk.kotlin.services.comprehend.model.ErrorsListItem
import aws.sdk.kotlin.services.comprehend.model.WarningsListItem
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ClassifyDocumentOperationDeserializer: HttpDeserialize<ClassifyDocumentResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ClassifyDocumentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwClassifyDocumentError(context, call)
        }
        val builder = ClassifyDocumentResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeClassifyDocumentOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwClassifyDocumentError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ComprehendException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceUnavailableException" -> ResourceUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "TextSizeLimitExceededException" -> TextSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ComprehendException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeClassifyDocumentOperationBody(builder: ClassifyDocumentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CLASSES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Classes"))
    val DOCUMENTMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DocumentMetadata"))
    val DOCUMENTTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DocumentType"))
    val ERRORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Errors"))
    val LABELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Labels"))
    val WARNINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Warnings"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLASSES_DESCRIPTOR)
        field(DOCUMENTMETADATA_DESCRIPTOR)
        field(DOCUMENTTYPE_DESCRIPTOR)
        field(ERRORS_DESCRIPTOR)
        field(LABELS_DESCRIPTOR)
        field(WARNINGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CLASSES_DESCRIPTOR.index -> builder.classes =
                    deserializer.deserializeList(CLASSES_DESCRIPTOR) {
                        val col0 = mutableListOf<DocumentClass>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDocumentClassDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                DOCUMENTMETADATA_DESCRIPTOR.index -> builder.documentMetadata = deserializeDocumentMetadataDocument(deserializer)
                DOCUMENTTYPE_DESCRIPTOR.index -> builder.documentType =
                    deserializer.deserializeList(DOCUMENTTYPE_DESCRIPTOR) {
                        val col0 = mutableListOf<DocumentTypeListItem>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDocumentTypeListItemDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ERRORS_DESCRIPTOR.index -> builder.errors =
                    deserializer.deserializeList(ERRORS_DESCRIPTOR) {
                        val col0 = mutableListOf<ErrorsListItem>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeErrorsListItemDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                LABELS_DESCRIPTOR.index -> builder.labels =
                    deserializer.deserializeList(LABELS_DESCRIPTOR) {
                        val col0 = mutableListOf<DocumentLabel>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDocumentLabelDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                WARNINGS_DESCRIPTOR.index -> builder.warnings =
                    deserializer.deserializeList(WARNINGS_DESCRIPTOR) {
                        val col0 = mutableListOf<WarningsListItem>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeWarningsListItemDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
