// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model



/**
 * Information about one of the entities found by targeted sentiment analysis.
 *
 * For more information about targeted sentiment, see [Targeted sentiment](https://docs.aws.amazon.com/comprehend/latest/dg/how-targeted-sentiment.html) in the *Amazon Comprehend Developer Guide*.
 */
public class TargetedSentimentEntity private constructor(builder: Builder) {
    /**
     * One or more index into the Mentions array that provides the best name for the entity group.
     */
    public val descriptiveMentionIndex: List<Int>? = builder.descriptiveMentionIndex
    /**
     * An array of mentions of the entity in the document. The array represents a co-reference group. See [ Co-reference group](https://docs.aws.amazon.com/comprehend/latest/dg/how-targeted-sentiment.html#how-targeted-sentiment-values) for an example.
     */
    public val mentions: List<TargetedSentimentMention>? = builder.mentions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.TargetedSentimentEntity = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TargetedSentimentEntity(")
        append("descriptiveMentionIndex=$descriptiveMentionIndex,")
        append("mentions=$mentions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = descriptiveMentionIndex?.hashCode() ?: 0
        result = 31 * result + (mentions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TargetedSentimentEntity

        if (descriptiveMentionIndex != other.descriptiveMentionIndex) return false
        if (mentions != other.mentions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.TargetedSentimentEntity = Builder(this).apply(block).build()

    public class Builder {
        /**
         * One or more index into the Mentions array that provides the best name for the entity group.
         */
        public var descriptiveMentionIndex: List<Int>? = null
        /**
         * An array of mentions of the entity in the document. The array represents a co-reference group. See [ Co-reference group](https://docs.aws.amazon.com/comprehend/latest/dg/how-targeted-sentiment.html#how-targeted-sentiment-values) for an example.
         */
        public var mentions: List<TargetedSentimentMention>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.TargetedSentimentEntity) : this() {
            this.descriptiveMentionIndex = x.descriptiveMentionIndex
            this.mentions = x.mentions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.TargetedSentimentEntity = TargetedSentimentEntity(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
