// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes information about an entity recognizer.
 */
public class EntityRecognizerProperties private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data.
     */
    public val dataAccessRoleArn: kotlin.String? = builder.dataAccessRoleArn
    /**
     * The time that the recognizer creation completed.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The Amazon Resource Name (ARN) that identifies the entity recognizer.
     */
    public val entityRecognizerArn: kotlin.String? = builder.entityRecognizerArn
    /**
     * The Amazon Resource Number (ARN) of the flywheel
     */
    public val flywheelArn: kotlin.String? = builder.flywheelArn
    /**
     * The input data properties of an entity recognizer.
     */
    public val inputDataConfig: aws.sdk.kotlin.services.comprehend.model.EntityRecognizerInputDataConfig? = builder.inputDataConfig
    /**
     * The language of the input documents. All documents must be in the same language. Only English ("en") is currently supported.
     */
    public val languageCode: aws.sdk.kotlin.services.comprehend.model.LanguageCode? = builder.languageCode
    /**
     * A description of the status of the recognizer.
     */
    public val message: kotlin.String? = builder.message
    /**
     * ID for the KMS key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats:
     * + KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
     * + Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
     */
    public val modelKmsKeyId: kotlin.String? = builder.modelKmsKeyId
    /**
     * Output data configuration.
     */
    public val outputDataConfig: aws.sdk.kotlin.services.comprehend.model.EntityRecognizerOutputDataConfig? = builder.outputDataConfig
    /**
     * Provides information about an entity recognizer.
     */
    public val recognizerMetadata: aws.sdk.kotlin.services.comprehend.model.EntityRecognizerMetadata? = builder.recognizerMetadata
    /**
     * The Amazon Resource Name (ARN) of the source model. This model was imported from a different Amazon Web Services account to create the entity recognizer model in your Amazon Web Services account.
     */
    public val sourceModelArn: kotlin.String? = builder.sourceModelArn
    /**
     * Provides the status of the entity recognizer.
     */
    public val status: aws.sdk.kotlin.services.comprehend.model.ModelStatus? = builder.status
    /**
     * The time that the recognizer was submitted for processing.
     */
    public val submitTime: aws.smithy.kotlin.runtime.time.Instant? = builder.submitTime
    /**
     * The time that training of the entity recognizer was completed.
     */
    public val trainingEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.trainingEndTime
    /**
     * The time that training of the entity recognizer started.
     */
    public val trainingStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.trainingStartTime
    /**
     * The version name you assigned to the entity recognizer.
     */
    public val versionName: kotlin.String? = builder.versionName
    /**
     * ID for the Amazon Web Services Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:
     * + KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
     * + Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
     */
    public val volumeKmsKeyId: kotlin.String? = builder.volumeKmsKeyId
    /**
     * Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for your custom entity recognizer. For more information, see [Amazon VPC](https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
     */
    public val vpcConfig: aws.sdk.kotlin.services.comprehend.model.VpcConfig? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.EntityRecognizerProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EntityRecognizerProperties(")
        append("dataAccessRoleArn=$dataAccessRoleArn,")
        append("endTime=$endTime,")
        append("entityRecognizerArn=$entityRecognizerArn,")
        append("flywheelArn=$flywheelArn,")
        append("inputDataConfig=$inputDataConfig,")
        append("languageCode=$languageCode,")
        append("message=$message,")
        append("modelKmsKeyId=$modelKmsKeyId,")
        append("outputDataConfig=$outputDataConfig,")
        append("recognizerMetadata=*** Sensitive Data Redacted ***,")
        append("sourceModelArn=$sourceModelArn,")
        append("status=$status,")
        append("submitTime=$submitTime,")
        append("trainingEndTime=$trainingEndTime,")
        append("trainingStartTime=$trainingStartTime,")
        append("versionName=$versionName,")
        append("volumeKmsKeyId=$volumeKmsKeyId,")
        append("vpcConfig=$vpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataAccessRoleArn?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (entityRecognizerArn?.hashCode() ?: 0)
        result = 31 * result + (flywheelArn?.hashCode() ?: 0)
        result = 31 * result + (inputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (modelKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (outputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (recognizerMetadata?.hashCode() ?: 0)
        result = 31 * result + (sourceModelArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (submitTime?.hashCode() ?: 0)
        result = 31 * result + (trainingEndTime?.hashCode() ?: 0)
        result = 31 * result + (trainingStartTime?.hashCode() ?: 0)
        result = 31 * result + (versionName?.hashCode() ?: 0)
        result = 31 * result + (volumeKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EntityRecognizerProperties

        if (dataAccessRoleArn != other.dataAccessRoleArn) return false
        if (endTime != other.endTime) return false
        if (entityRecognizerArn != other.entityRecognizerArn) return false
        if (flywheelArn != other.flywheelArn) return false
        if (inputDataConfig != other.inputDataConfig) return false
        if (languageCode != other.languageCode) return false
        if (message != other.message) return false
        if (modelKmsKeyId != other.modelKmsKeyId) return false
        if (outputDataConfig != other.outputDataConfig) return false
        if (recognizerMetadata != other.recognizerMetadata) return false
        if (sourceModelArn != other.sourceModelArn) return false
        if (status != other.status) return false
        if (submitTime != other.submitTime) return false
        if (trainingEndTime != other.trainingEndTime) return false
        if (trainingStartTime != other.trainingStartTime) return false
        if (versionName != other.versionName) return false
        if (volumeKmsKeyId != other.volumeKmsKeyId) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.EntityRecognizerProperties = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data.
         */
        public var dataAccessRoleArn: kotlin.String? = null
        /**
         * The time that the recognizer creation completed.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) that identifies the entity recognizer.
         */
        public var entityRecognizerArn: kotlin.String? = null
        /**
         * The Amazon Resource Number (ARN) of the flywheel
         */
        public var flywheelArn: kotlin.String? = null
        /**
         * The input data properties of an entity recognizer.
         */
        public var inputDataConfig: aws.sdk.kotlin.services.comprehend.model.EntityRecognizerInputDataConfig? = null
        /**
         * The language of the input documents. All documents must be in the same language. Only English ("en") is currently supported.
         */
        public var languageCode: aws.sdk.kotlin.services.comprehend.model.LanguageCode? = null
        /**
         * A description of the status of the recognizer.
         */
        public var message: kotlin.String? = null
        /**
         * ID for the KMS key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats:
         * + KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
         * + Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
         */
        public var modelKmsKeyId: kotlin.String? = null
        /**
         * Output data configuration.
         */
        public var outputDataConfig: aws.sdk.kotlin.services.comprehend.model.EntityRecognizerOutputDataConfig? = null
        /**
         * Provides information about an entity recognizer.
         */
        public var recognizerMetadata: aws.sdk.kotlin.services.comprehend.model.EntityRecognizerMetadata? = null
        /**
         * The Amazon Resource Name (ARN) of the source model. This model was imported from a different Amazon Web Services account to create the entity recognizer model in your Amazon Web Services account.
         */
        public var sourceModelArn: kotlin.String? = null
        /**
         * Provides the status of the entity recognizer.
         */
        public var status: aws.sdk.kotlin.services.comprehend.model.ModelStatus? = null
        /**
         * The time that the recognizer was submitted for processing.
         */
        public var submitTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time that training of the entity recognizer was completed.
         */
        public var trainingEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time that training of the entity recognizer started.
         */
        public var trainingStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The version name you assigned to the entity recognizer.
         */
        public var versionName: kotlin.String? = null
        /**
         * ID for the Amazon Web Services Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:
         * + KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
         * + Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
         */
        public var volumeKmsKeyId: kotlin.String? = null
        /**
         * Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for your custom entity recognizer. For more information, see [Amazon VPC](https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
         */
        public var vpcConfig: aws.sdk.kotlin.services.comprehend.model.VpcConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.EntityRecognizerProperties) : this() {
            this.dataAccessRoleArn = x.dataAccessRoleArn
            this.endTime = x.endTime
            this.entityRecognizerArn = x.entityRecognizerArn
            this.flywheelArn = x.flywheelArn
            this.inputDataConfig = x.inputDataConfig
            this.languageCode = x.languageCode
            this.message = x.message
            this.modelKmsKeyId = x.modelKmsKeyId
            this.outputDataConfig = x.outputDataConfig
            this.recognizerMetadata = x.recognizerMetadata
            this.sourceModelArn = x.sourceModelArn
            this.status = x.status
            this.submitTime = x.submitTime
            this.trainingEndTime = x.trainingEndTime
            this.trainingStartTime = x.trainingStartTime
            this.versionName = x.versionName
            this.volumeKmsKeyId = x.volumeKmsKeyId
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.EntityRecognizerProperties = EntityRecognizerProperties(this)

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.EntityRecognizerInputDataConfig] inside the given [block]
         */
        public fun inputDataConfig(block: aws.sdk.kotlin.services.comprehend.model.EntityRecognizerInputDataConfig.Builder.() -> kotlin.Unit) {
            this.inputDataConfig = aws.sdk.kotlin.services.comprehend.model.EntityRecognizerInputDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.EntityRecognizerOutputDataConfig] inside the given [block]
         */
        public fun outputDataConfig(block: aws.sdk.kotlin.services.comprehend.model.EntityRecognizerOutputDataConfig.Builder.() -> kotlin.Unit) {
            this.outputDataConfig = aws.sdk.kotlin.services.comprehend.model.EntityRecognizerOutputDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.EntityRecognizerMetadata] inside the given [block]
         */
        public fun recognizerMetadata(block: aws.sdk.kotlin.services.comprehend.model.EntityRecognizerMetadata.Builder.() -> kotlin.Unit) {
            this.recognizerMetadata = aws.sdk.kotlin.services.comprehend.model.EntityRecognizerMetadata.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.VpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.comprehend.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.comprehend.model.VpcConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
