// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model



/**
 * The location of the training documents. This parameter is required in a request to create a semi-structured document classification model.
 */
public class DocumentClassifierDocuments private constructor(builder: Builder) {
    /**
     * The S3 URI location of the training documents specified in the S3Uri CSV file.
     */
    public val s3Uri: kotlin.String = requireNotNull(builder.s3Uri) { "A non-null value must be provided for s3Uri" }
    /**
     * The S3 URI location of the test documents included in the TestS3Uri CSV file. This field is not required if you do not specify a test CSV file.
     */
    public val testS3Uri: kotlin.String? = builder.testS3Uri

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.DocumentClassifierDocuments = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DocumentClassifierDocuments(")
        append("s3Uri=$s3Uri,")
        append("testS3Uri=$testS3Uri")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = s3Uri.hashCode()
        result = 31 * result + (testS3Uri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DocumentClassifierDocuments

        if (s3Uri != other.s3Uri) return false
        if (testS3Uri != other.testS3Uri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.DocumentClassifierDocuments = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The S3 URI location of the training documents specified in the S3Uri CSV file.
         */
        public var s3Uri: kotlin.String? = null
        /**
         * The S3 URI location of the test documents included in the TestS3Uri CSV file. This field is not required if you do not specify a test CSV file.
         */
        public var testS3Uri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.DocumentClassifierDocuments) : this() {
            this.s3Uri = x.s3Uri
            this.testS3Uri = x.testS3Uri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.DocumentClassifierDocuments = DocumentClassifierDocuments(this)

        internal fun correctErrors(): Builder {
            if (s3Uri == null) s3Uri = ""
            return this
        }
    }
}
