// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.cognitoidentityprovider.model.CodeDeliveryDetailsType
import aws.sdk.kotlin.services.cognitoidentityprovider.model.CognitoIdentityProviderException
import aws.sdk.kotlin.services.cognitoidentityprovider.model.UpdateUserAttributesResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateUserAttributesOperationDeserializer: HttpDeserialize<UpdateUserAttributesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateUserAttributesResponse {
        if (!response.status.isSuccess()) {
            throwUpdateUserAttributesError(context, response)
        }
        val builder = UpdateUserAttributesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateUserAttributesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateUserAttributesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CognitoIdentityProviderException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AliasExistsException" -> AliasExistsExceptionDeserializer().deserialize(context, wrappedResponse)
        "CodeDeliveryFailureException" -> CodeDeliveryFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "CodeMismatchException" -> CodeMismatchExceptionDeserializer().deserialize(context, wrappedResponse)
        "ExpiredCodeException" -> ExpiredCodeExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidEmailRoleAccessPolicyException" -> InvalidEmailRoleAccessPolicyExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidLambdaResponseException" -> InvalidLambdaResponseExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidSmsRoleAccessPolicyException" -> InvalidSmsRoleAccessPolicyExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidSmsRoleTrustRelationshipException" -> InvalidSmsRoleTrustRelationshipExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotAuthorizedException" -> NotAuthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        "PasswordResetRequiredException" -> PasswordResetRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnexpectedLambdaException" -> UnexpectedLambdaExceptionDeserializer().deserialize(context, wrappedResponse)
        "UserLambdaValidationException" -> UserLambdaValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        "UserNotConfirmedException" -> UserNotConfirmedExceptionDeserializer().deserialize(context, wrappedResponse)
        "UserNotFoundException" -> UserNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CognitoIdentityProviderException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateUserAttributesOperationBody(builder: UpdateUserAttributesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CODEDELIVERYDETAILSLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("CodeDeliveryDetailsList"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CODEDELIVERYDETAILSLIST_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CODEDELIVERYDETAILSLIST_DESCRIPTOR.index -> builder.codeDeliveryDetailsList =
                    deserializer.deserializeList(CODEDELIVERYDETAILSLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<CodeDeliveryDetailsType>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeCodeDeliveryDetailsTypeDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
