// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.cognitoidentityprovider.model.CognitoIdentityProviderException
import aws.sdk.kotlin.services.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.SmsMfaConfigType
import aws.sdk.kotlin.services.cognitoidentityprovider.model.SoftwareTokenMfaConfigType
import aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolMfaType
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class SetUserPoolMfaConfigOperationDeserializer: HttpDeserialize<SetUserPoolMfaConfigResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): SetUserPoolMfaConfigResponse {
        if (!response.status.isSuccess()) {
            throwSetUserPoolMfaConfigError(context, response)
        }
        val builder = SetUserPoolMfaConfigResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeSetUserPoolMfaConfigOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwSetUserPoolMfaConfigError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CognitoIdentityProviderException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidSmsRoleAccessPolicyException" -> InvalidSmsRoleAccessPolicyExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidSmsRoleTrustRelationshipException" -> InvalidSmsRoleTrustRelationshipExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotAuthorizedException" -> NotAuthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CognitoIdentityProviderException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeSetUserPoolMfaConfigOperationBody(builder: SetUserPoolMfaConfigResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val MFACONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MfaConfiguration"))
    val SMSMFACONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SmsMfaConfiguration"))
    val SOFTWARETOKENMFACONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SoftwareTokenMfaConfiguration"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MFACONFIGURATION_DESCRIPTOR)
        field(SMSMFACONFIGURATION_DESCRIPTOR)
        field(SOFTWARETOKENMFACONFIGURATION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MFACONFIGURATION_DESCRIPTOR.index -> builder.mfaConfiguration = deserializeString().let { UserPoolMfaType.fromValue(it) }
                SMSMFACONFIGURATION_DESCRIPTOR.index -> builder.smsMfaConfiguration = deserializeSmsMfaConfigTypeDocument(deserializer)
                SOFTWARETOKENMFACONFIGURATION_DESCRIPTOR.index -> builder.softwareTokenMfaConfiguration = deserializeSoftwareTokenMfaConfigTypeDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
