// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminUpdateUserAttributesResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.CognitoIdentityProviderException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class AdminUpdateUserAttributesOperationDeserializer: HttpDeserialize<AdminUpdateUserAttributesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): AdminUpdateUserAttributesResponse {
        if (!response.status.isSuccess()) {
            throwAdminUpdateUserAttributesError(context, response)
        }
        val builder = AdminUpdateUserAttributesResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwAdminUpdateUserAttributesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CognitoIdentityProviderException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AliasExistsException" -> AliasExistsExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidEmailRoleAccessPolicyException" -> InvalidEmailRoleAccessPolicyExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidLambdaResponseException" -> InvalidLambdaResponseExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidSmsRoleAccessPolicyException" -> InvalidSmsRoleAccessPolicyExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidSmsRoleTrustRelationshipException" -> InvalidSmsRoleTrustRelationshipExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotAuthorizedException" -> NotAuthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnexpectedLambdaException" -> UnexpectedLambdaExceptionDeserializer().deserialize(context, wrappedResponse)
        "UserLambdaValidationException" -> UserLambdaValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        "UserNotFoundException" -> UserNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CognitoIdentityProviderException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
