// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model



/**
 * The template for verification messages.
 */
class VerificationMessageTemplateType private constructor(builder: Builder) {
    /**
     * The default email option.
     */
    val defaultEmailOption: aws.sdk.kotlin.services.cognitoidentityprovider.model.DefaultEmailOptionType? = builder.defaultEmailOption
    /**
     * The template for email messages that Amazon Cognito sends to your users. You can set an `EmailMessage` template only if the value of [ EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is `DEVELOPER`. When your [EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is `DEVELOPER`, your user pool sends email messages with your own Amazon SES configuration.
     */
    val emailMessage: kotlin.String? = builder.emailMessage
    /**
     * The email message template for sending a confirmation link to the user. You can set an `EmailMessageByLink` template only if the value of [ EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is `DEVELOPER`. When your [EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is `DEVELOPER`, your user pool sends email messages with your own Amazon SES configuration.
     */
    val emailMessageByLink: kotlin.String? = builder.emailMessageByLink
    /**
     * The subject line for the email message template. You can set an `EmailSubject` template only if the value of [ EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is `DEVELOPER`. When your [EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is `DEVELOPER`, your user pool sends email messages with your own Amazon SES configuration.
     */
    val emailSubject: kotlin.String? = builder.emailSubject
    /**
     * The subject line for the email message template for sending a confirmation link to the user. You can set an `EmailSubjectByLink` template only if the value of [ EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is `DEVELOPER`. When your [EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is `DEVELOPER`, your user pool sends email messages with your own Amazon SES configuration.
     */
    val emailSubjectByLink: kotlin.String? = builder.emailSubjectByLink
    /**
     * The template for SMS messages that Amazon Cognito sends to your users.
     */
    val smsMessage: kotlin.String? = builder.smsMessage

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.VerificationMessageTemplateType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VerificationMessageTemplateType(")
        append("defaultEmailOption=$defaultEmailOption,")
        append("emailMessage=$emailMessage,")
        append("emailMessageByLink=$emailMessageByLink,")
        append("emailSubject=$emailSubject,")
        append("emailSubjectByLink=$emailSubjectByLink,")
        append("smsMessage=$smsMessage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultEmailOption?.hashCode() ?: 0
        result = 31 * result + (emailMessage?.hashCode() ?: 0)
        result = 31 * result + (emailMessageByLink?.hashCode() ?: 0)
        result = 31 * result + (emailSubject?.hashCode() ?: 0)
        result = 31 * result + (emailSubjectByLink?.hashCode() ?: 0)
        result = 31 * result + (smsMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VerificationMessageTemplateType

        if (defaultEmailOption != other.defaultEmailOption) return false
        if (emailMessage != other.emailMessage) return false
        if (emailMessageByLink != other.emailMessageByLink) return false
        if (emailSubject != other.emailSubject) return false
        if (emailSubjectByLink != other.emailSubjectByLink) return false
        if (smsMessage != other.smsMessage) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.VerificationMessageTemplateType = Builder(this).apply(block).build()

    class Builder {
        /**
         * The default email option.
         */
        var defaultEmailOption: aws.sdk.kotlin.services.cognitoidentityprovider.model.DefaultEmailOptionType? = null
        /**
         * The template for email messages that Amazon Cognito sends to your users. You can set an `EmailMessage` template only if the value of [ EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is `DEVELOPER`. When your [EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is `DEVELOPER`, your user pool sends email messages with your own Amazon SES configuration.
         */
        var emailMessage: kotlin.String? = null
        /**
         * The email message template for sending a confirmation link to the user. You can set an `EmailMessageByLink` template only if the value of [ EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is `DEVELOPER`. When your [EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is `DEVELOPER`, your user pool sends email messages with your own Amazon SES configuration.
         */
        var emailMessageByLink: kotlin.String? = null
        /**
         * The subject line for the email message template. You can set an `EmailSubject` template only if the value of [ EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is `DEVELOPER`. When your [EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is `DEVELOPER`, your user pool sends email messages with your own Amazon SES configuration.
         */
        var emailSubject: kotlin.String? = null
        /**
         * The subject line for the email message template for sending a confirmation link to the user. You can set an `EmailSubjectByLink` template only if the value of [ EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is `DEVELOPER`. When your [EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is `DEVELOPER`, your user pool sends email messages with your own Amazon SES configuration.
         */
        var emailSubjectByLink: kotlin.String? = null
        /**
         * The template for SMS messages that Amazon Cognito sends to your users.
         */
        var smsMessage: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.VerificationMessageTemplateType) : this() {
            this.defaultEmailOption = x.defaultEmailOption
            this.emailMessage = x.emailMessage
            this.emailMessageByLink = x.emailMessageByLink
            this.emailSubject = x.emailSubject
            this.emailSubjectByLink = x.emailSubjectByLink
            this.smsMessage = x.smsMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.VerificationMessageTemplateType = VerificationMessageTemplateType(this)
    }
}
