// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a user pool client.
 */
class UserPoolClientType private constructor(builder: Builder) {
    /**
     * The access token time limit. After this limit expires, your user can't use their access token. To specify the time unit for `AccessTokenValidity` as `seconds`, `minutes`, `hours`, or `days`, set a `TokenValidityUnits` value in your API request.
     *
     * For example, when you set `AccessTokenValidity` to `10` and `TokenValidityUnits` to `hours`, your user can authorize access with their access token for 10 hours.
     *
     * The default time unit for `AccessTokenValidity` in an API request is hours. *Valid range* is displayed below in seconds.
     */
    val accessTokenValidity: kotlin.Int? = builder.accessTokenValidity
    /**
     * The allowed OAuth flows.
     *
     * ## code
     * Use a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the `/oauth2/token` endpoint.
     *
     * ## implicit
     * Issue the access token (and, optionally, ID token, based on scopes) directly to your user.
     *
     * ## client_credentials
     * Issue the access token from the `/oauth2/token` endpoint directly to a non-person user using a combination of the client ID and client secret.
     */
    val allowedOAuthFlows: List<OAuthFlowType>? = builder.allowedOAuthFlows
    /**
     * Set to true if the client is allowed to follow the OAuth protocol when interacting with Amazon Cognito user pools.
     */
    val allowedOAuthFlowsUserPoolClient: kotlin.Boolean = builder.allowedOAuthFlowsUserPoolClient
    /**
     * The OAuth scopes that your app client supports. Possible values that OAuth provides are `phone`, `email`, `openid`, and `profile`. Possible values that Amazon Web Services provides are `aws.cognito.signin.user.admin`. Amazon Cognito also supports custom scopes that you create in Resource Servers.
     */
    val allowedOAuthScopes: List<String>? = builder.allowedOAuthScopes
    /**
     * The Amazon Pinpoint analytics configuration for the user pool client.
     *
     * Amazon Cognito user pools only support sending events to Amazon Pinpoint projects in the US East (N. Virginia) us-east-1 Region, regardless of the Region where the user pool resides.
     */
    val analyticsConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsConfigurationType? = builder.analyticsConfiguration
    /**
     * A list of allowed redirect (callback) URLs for the IdPs.
     *
     * A redirect URI must:
     * + Be an absolute URI.
     * + Be registered with the authorization server.
     * + Not include a fragment component.
     *
     * See [OAuth 2.0 - Redirection Endpoint](https://tools.ietf.org/html/rfc6749#section-3.1.2).
     *
     * Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
     *
     * App callback URLs such as myapp://example are also supported.
     */
    val callbackUrLs: List<String>? = builder.callbackUrLs
    /**
     * The ID of the client associated with the user pool.
     */
    val clientId: kotlin.String? = builder.clientId
    /**
     * The client name from the user pool request of the client type.
     */
    val clientName: kotlin.String? = builder.clientName
    /**
     * The client secret from the user pool request of the client type.
     */
    val clientSecret: kotlin.String? = builder.clientSecret
    /**
     * The date the user pool client was created.
     */
    val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * The default redirect URI. Must be in the `CallbackURLs` list.
     *
     * A redirect URI must:
     * + Be an absolute URI.
     * + Be registered with the authorization server.
     * + Not include a fragment component.
     *
     * See [OAuth 2.0 - Redirection Endpoint](https://tools.ietf.org/html/rfc6749#section-3.1.2).
     *
     * Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
     *
     * App callback URLs such as myapp://example are also supported.
     */
    val defaultRedirectUri: kotlin.String? = builder.defaultRedirectUri
    /**
     * When `EnablePropagateAdditionalUserContextData` is true, Amazon Cognito accepts an `IpAddress` value that you send in the `UserContextData` parameter. The `UserContextData` parameter sends information to Amazon Cognito advanced security for risk analysis. You can send `UserContextData` when you sign in Amazon Cognito native users with the `InitiateAuth` and `RespondToAuthChallenge` API operations.
     *
     * When `EnablePropagateAdditionalUserContextData` is false, you can't send your user's source IP address to Amazon Cognito advanced security with unauthenticated API operations. `EnablePropagateAdditionalUserContextData` doesn't affect whether you can send a source IP address in a `ContextData` parameter with the authenticated API operations `AdminInitiateAuth` and `AdminRespondToAuthChallenge`.
     *
     * You can only activate `EnablePropagateAdditionalUserContextData` in an app client that has a client secret. For more information about propagation of user context data, see [Adding user device and session data to API requests](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-adaptive-authentication.html#user-pool-settings-adaptive-authentication-device-fingerprint).
     */
    val enablePropagateAdditionalUserContextData: kotlin.Boolean? = builder.enablePropagateAdditionalUserContextData
    /**
     * Indicates whether token revocation is activated for the user pool client. When you create a new user pool client, token revocation is activated by default. For more information about revoking tokens, see [RevokeToken](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html).
     */
    val enableTokenRevocation: kotlin.Boolean? = builder.enableTokenRevocation
    /**
     * The authentication flows that are supported by the user pool clients. Flow names without the `ALLOW_` prefix are no longer supported in favor of new names with the `ALLOW_` prefix. Note that values with `ALLOW_` prefix must be used only along with values including the `ALLOW_` prefix.
     *
     * Valid values include:
     * + `ALLOW_ADMIN_USER_PASSWORD_AUTH`: Enable admin based user password authentication flow `ADMIN_USER_PASSWORD_AUTH`. This setting replaces the `ADMIN_NO_SRP_AUTH` setting. With this authentication flow, Amazon Cognito receives the password in the request instead of using the Secure Remote Password (SRP) protocol to verify passwords.
     * + `ALLOW_CUSTOM_AUTH`: Enable Lambda trigger based authentication.
     * + `ALLOW_USER_PASSWORD_AUTH`: Enable user password-based authentication. In this flow, Amazon Cognito receives the password in the request instead of using the SRP protocol to verify passwords.
     * + `ALLOW_USER_SRP_AUTH`: Enable SRP-based authentication.
     * + `ALLOW_REFRESH_TOKEN_AUTH`: Enable authflow to refresh tokens.
     */
    val explicitAuthFlows: List<ExplicitAuthFlowsType>? = builder.explicitAuthFlows
    /**
     * The ID token time limit. After this limit expires, your user can't use their ID token. To specify the time unit for `IdTokenValidity` as `seconds`, `minutes`, `hours`, or `days`, set a `TokenValidityUnits` value in your API request.
     *
     * For example, when you set `IdTokenValidity` as `10` and `TokenValidityUnits` as `hours`, your user can authenticate their session with their ID token for 10 hours.
     *
     * The default time unit for `AccessTokenValidity` in an API request is hours. *Valid range* is displayed below in seconds.
     */
    val idTokenValidity: kotlin.Int? = builder.idTokenValidity
    /**
     * The date the user pool client was last modified.
     */
    val lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedDate
    /**
     * A list of allowed logout URLs for the IdPs.
     */
    val logoutUrLs: List<String>? = builder.logoutUrLs
    /**
     * Errors and responses that you want Amazon Cognito APIs to return during authentication, account confirmation, and password recovery when the user doesn't exist in the user pool. When set to `ENABLED` and the user doesn't exist, authentication returns an error indicating either the username or password was incorrect. Account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to `LEGACY`, those APIs return a `UserNotFoundException` exception if the user doesn't exist in the user pool.
     *
     * Valid values include:
     * + `ENABLED` - This prevents user existence-related errors.
     * + `LEGACY` - This represents the old behavior of Amazon Cognito where user existence related errors aren't prevented.
     */
    val preventUserExistenceErrors: aws.sdk.kotlin.services.cognitoidentityprovider.model.PreventUserExistenceErrorTypes? = builder.preventUserExistenceErrors
    /**
     * The Read-only attributes.
     */
    val readAttributes: List<String>? = builder.readAttributes
    /**
     * The refresh token time limit. After this limit expires, your user can't use their refresh token. To specify the time unit for `RefreshTokenValidity` as `seconds`, `minutes`, `hours`, or `days`, set a `TokenValidityUnits` value in your API request.
     *
     * For example, when you set `RefreshTokenValidity` as `10` and `TokenValidityUnits` as `days`, your user can refresh their session and retrieve new access and ID tokens for 10 days.
     *
     * The default time unit for `RefreshTokenValidity` in an API request is days. You can't set `RefreshTokenValidity` to 0. If you do, Amazon Cognito overrides the value with the default value of 30 days. *Valid range* is displayed below in seconds.
     */
    val refreshTokenValidity: kotlin.Int = builder.refreshTokenValidity
    /**
     * A list of provider names for the IdPs that this client supports. The following are supported: `COGNITO`, `Facebook`, `Google``LoginWithAmazon`, and the names of your own SAML and OIDC providers.
     */
    val supportedIdentityProviders: List<String>? = builder.supportedIdentityProviders
    /**
     * The time units used to specify the token validity times of each token type: ID, access, and refresh.
     */
    val tokenValidityUnits: aws.sdk.kotlin.services.cognitoidentityprovider.model.TokenValidityUnitsType? = builder.tokenValidityUnits
    /**
     * The user pool ID for the user pool client.
     */
    val userPoolId: kotlin.String? = builder.userPoolId
    /**
     * The writeable attributes.
     */
    val writeAttributes: List<String>? = builder.writeAttributes

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolClientType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UserPoolClientType(")
        append("accessTokenValidity=$accessTokenValidity,")
        append("allowedOAuthFlows=$allowedOAuthFlows,")
        append("allowedOAuthFlowsUserPoolClient=$allowedOAuthFlowsUserPoolClient,")
        append("allowedOAuthScopes=$allowedOAuthScopes,")
        append("analyticsConfiguration=$analyticsConfiguration,")
        append("callbackUrLs=$callbackUrLs,")
        append("clientId=*** Sensitive Data Redacted ***,")
        append("clientName=$clientName,")
        append("clientSecret=*** Sensitive Data Redacted ***,")
        append("creationDate=$creationDate,")
        append("defaultRedirectUri=$defaultRedirectUri,")
        append("enablePropagateAdditionalUserContextData=$enablePropagateAdditionalUserContextData,")
        append("enableTokenRevocation=$enableTokenRevocation,")
        append("explicitAuthFlows=$explicitAuthFlows,")
        append("idTokenValidity=$idTokenValidity,")
        append("lastModifiedDate=$lastModifiedDate,")
        append("logoutUrLs=$logoutUrLs,")
        append("preventUserExistenceErrors=$preventUserExistenceErrors,")
        append("readAttributes=$readAttributes,")
        append("refreshTokenValidity=$refreshTokenValidity,")
        append("supportedIdentityProviders=$supportedIdentityProviders,")
        append("tokenValidityUnits=$tokenValidityUnits,")
        append("userPoolId=$userPoolId,")
        append("writeAttributes=$writeAttributes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessTokenValidity ?: 0
        result = 31 * result + (allowedOAuthFlows?.hashCode() ?: 0)
        result = 31 * result + (allowedOAuthFlowsUserPoolClient.hashCode())
        result = 31 * result + (allowedOAuthScopes?.hashCode() ?: 0)
        result = 31 * result + (analyticsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (callbackUrLs?.hashCode() ?: 0)
        result = 31 * result + (clientId?.hashCode() ?: 0)
        result = 31 * result + (clientName?.hashCode() ?: 0)
        result = 31 * result + (clientSecret?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (defaultRedirectUri?.hashCode() ?: 0)
        result = 31 * result + (enablePropagateAdditionalUserContextData?.hashCode() ?: 0)
        result = 31 * result + (enableTokenRevocation?.hashCode() ?: 0)
        result = 31 * result + (explicitAuthFlows?.hashCode() ?: 0)
        result = 31 * result + (idTokenValidity ?: 0)
        result = 31 * result + (lastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (logoutUrLs?.hashCode() ?: 0)
        result = 31 * result + (preventUserExistenceErrors?.hashCode() ?: 0)
        result = 31 * result + (readAttributes?.hashCode() ?: 0)
        result = 31 * result + (refreshTokenValidity)
        result = 31 * result + (supportedIdentityProviders?.hashCode() ?: 0)
        result = 31 * result + (tokenValidityUnits?.hashCode() ?: 0)
        result = 31 * result + (userPoolId?.hashCode() ?: 0)
        result = 31 * result + (writeAttributes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UserPoolClientType

        if (accessTokenValidity != other.accessTokenValidity) return false
        if (allowedOAuthFlows != other.allowedOAuthFlows) return false
        if (allowedOAuthFlowsUserPoolClient != other.allowedOAuthFlowsUserPoolClient) return false
        if (allowedOAuthScopes != other.allowedOAuthScopes) return false
        if (analyticsConfiguration != other.analyticsConfiguration) return false
        if (callbackUrLs != other.callbackUrLs) return false
        if (clientId != other.clientId) return false
        if (clientName != other.clientName) return false
        if (clientSecret != other.clientSecret) return false
        if (creationDate != other.creationDate) return false
        if (defaultRedirectUri != other.defaultRedirectUri) return false
        if (enablePropagateAdditionalUserContextData != other.enablePropagateAdditionalUserContextData) return false
        if (enableTokenRevocation != other.enableTokenRevocation) return false
        if (explicitAuthFlows != other.explicitAuthFlows) return false
        if (idTokenValidity != other.idTokenValidity) return false
        if (lastModifiedDate != other.lastModifiedDate) return false
        if (logoutUrLs != other.logoutUrLs) return false
        if (preventUserExistenceErrors != other.preventUserExistenceErrors) return false
        if (readAttributes != other.readAttributes) return false
        if (refreshTokenValidity != other.refreshTokenValidity) return false
        if (supportedIdentityProviders != other.supportedIdentityProviders) return false
        if (tokenValidityUnits != other.tokenValidityUnits) return false
        if (userPoolId != other.userPoolId) return false
        if (writeAttributes != other.writeAttributes) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolClientType = Builder(this).apply(block).build()

    class Builder {
        /**
         * The access token time limit. After this limit expires, your user can't use their access token. To specify the time unit for `AccessTokenValidity` as `seconds`, `minutes`, `hours`, or `days`, set a `TokenValidityUnits` value in your API request.
         *
         * For example, when you set `AccessTokenValidity` to `10` and `TokenValidityUnits` to `hours`, your user can authorize access with their access token for 10 hours.
         *
         * The default time unit for `AccessTokenValidity` in an API request is hours. *Valid range* is displayed below in seconds.
         */
        var accessTokenValidity: kotlin.Int? = null
        /**
         * The allowed OAuth flows.
         *
         * ## code
         * Use a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the `/oauth2/token` endpoint.
         *
         * ## implicit
         * Issue the access token (and, optionally, ID token, based on scopes) directly to your user.
         *
         * ## client_credentials
         * Issue the access token from the `/oauth2/token` endpoint directly to a non-person user using a combination of the client ID and client secret.
         */
        var allowedOAuthFlows: List<OAuthFlowType>? = null
        /**
         * Set to true if the client is allowed to follow the OAuth protocol when interacting with Amazon Cognito user pools.
         */
        var allowedOAuthFlowsUserPoolClient: kotlin.Boolean = false
        /**
         * The OAuth scopes that your app client supports. Possible values that OAuth provides are `phone`, `email`, `openid`, and `profile`. Possible values that Amazon Web Services provides are `aws.cognito.signin.user.admin`. Amazon Cognito also supports custom scopes that you create in Resource Servers.
         */
        var allowedOAuthScopes: List<String>? = null
        /**
         * The Amazon Pinpoint analytics configuration for the user pool client.
         *
         * Amazon Cognito user pools only support sending events to Amazon Pinpoint projects in the US East (N. Virginia) us-east-1 Region, regardless of the Region where the user pool resides.
         */
        var analyticsConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsConfigurationType? = null
        /**
         * A list of allowed redirect (callback) URLs for the IdPs.
         *
         * A redirect URI must:
         * + Be an absolute URI.
         * + Be registered with the authorization server.
         * + Not include a fragment component.
         *
         * See [OAuth 2.0 - Redirection Endpoint](https://tools.ietf.org/html/rfc6749#section-3.1.2).
         *
         * Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
         *
         * App callback URLs such as myapp://example are also supported.
         */
        var callbackUrLs: List<String>? = null
        /**
         * The ID of the client associated with the user pool.
         */
        var clientId: kotlin.String? = null
        /**
         * The client name from the user pool request of the client type.
         */
        var clientName: kotlin.String? = null
        /**
         * The client secret from the user pool request of the client type.
         */
        var clientSecret: kotlin.String? = null
        /**
         * The date the user pool client was created.
         */
        var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The default redirect URI. Must be in the `CallbackURLs` list.
         *
         * A redirect URI must:
         * + Be an absolute URI.
         * + Be registered with the authorization server.
         * + Not include a fragment component.
         *
         * See [OAuth 2.0 - Redirection Endpoint](https://tools.ietf.org/html/rfc6749#section-3.1.2).
         *
         * Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
         *
         * App callback URLs such as myapp://example are also supported.
         */
        var defaultRedirectUri: kotlin.String? = null
        /**
         * When `EnablePropagateAdditionalUserContextData` is true, Amazon Cognito accepts an `IpAddress` value that you send in the `UserContextData` parameter. The `UserContextData` parameter sends information to Amazon Cognito advanced security for risk analysis. You can send `UserContextData` when you sign in Amazon Cognito native users with the `InitiateAuth` and `RespondToAuthChallenge` API operations.
         *
         * When `EnablePropagateAdditionalUserContextData` is false, you can't send your user's source IP address to Amazon Cognito advanced security with unauthenticated API operations. `EnablePropagateAdditionalUserContextData` doesn't affect whether you can send a source IP address in a `ContextData` parameter with the authenticated API operations `AdminInitiateAuth` and `AdminRespondToAuthChallenge`.
         *
         * You can only activate `EnablePropagateAdditionalUserContextData` in an app client that has a client secret. For more information about propagation of user context data, see [Adding user device and session data to API requests](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-adaptive-authentication.html#user-pool-settings-adaptive-authentication-device-fingerprint).
         */
        var enablePropagateAdditionalUserContextData: kotlin.Boolean? = null
        /**
         * Indicates whether token revocation is activated for the user pool client. When you create a new user pool client, token revocation is activated by default. For more information about revoking tokens, see [RevokeToken](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html).
         */
        var enableTokenRevocation: kotlin.Boolean? = null
        /**
         * The authentication flows that are supported by the user pool clients. Flow names without the `ALLOW_` prefix are no longer supported in favor of new names with the `ALLOW_` prefix. Note that values with `ALLOW_` prefix must be used only along with values including the `ALLOW_` prefix.
         *
         * Valid values include:
         * + `ALLOW_ADMIN_USER_PASSWORD_AUTH`: Enable admin based user password authentication flow `ADMIN_USER_PASSWORD_AUTH`. This setting replaces the `ADMIN_NO_SRP_AUTH` setting. With this authentication flow, Amazon Cognito receives the password in the request instead of using the Secure Remote Password (SRP) protocol to verify passwords.
         * + `ALLOW_CUSTOM_AUTH`: Enable Lambda trigger based authentication.
         * + `ALLOW_USER_PASSWORD_AUTH`: Enable user password-based authentication. In this flow, Amazon Cognito receives the password in the request instead of using the SRP protocol to verify passwords.
         * + `ALLOW_USER_SRP_AUTH`: Enable SRP-based authentication.
         * + `ALLOW_REFRESH_TOKEN_AUTH`: Enable authflow to refresh tokens.
         */
        var explicitAuthFlows: List<ExplicitAuthFlowsType>? = null
        /**
         * The ID token time limit. After this limit expires, your user can't use their ID token. To specify the time unit for `IdTokenValidity` as `seconds`, `minutes`, `hours`, or `days`, set a `TokenValidityUnits` value in your API request.
         *
         * For example, when you set `IdTokenValidity` as `10` and `TokenValidityUnits` as `hours`, your user can authenticate their session with their ID token for 10 hours.
         *
         * The default time unit for `AccessTokenValidity` in an API request is hours. *Valid range* is displayed below in seconds.
         */
        var idTokenValidity: kotlin.Int? = null
        /**
         * The date the user pool client was last modified.
         */
        var lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of allowed logout URLs for the IdPs.
         */
        var logoutUrLs: List<String>? = null
        /**
         * Errors and responses that you want Amazon Cognito APIs to return during authentication, account confirmation, and password recovery when the user doesn't exist in the user pool. When set to `ENABLED` and the user doesn't exist, authentication returns an error indicating either the username or password was incorrect. Account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to `LEGACY`, those APIs return a `UserNotFoundException` exception if the user doesn't exist in the user pool.
         *
         * Valid values include:
         * + `ENABLED` - This prevents user existence-related errors.
         * + `LEGACY` - This represents the old behavior of Amazon Cognito where user existence related errors aren't prevented.
         */
        var preventUserExistenceErrors: aws.sdk.kotlin.services.cognitoidentityprovider.model.PreventUserExistenceErrorTypes? = null
        /**
         * The Read-only attributes.
         */
        var readAttributes: List<String>? = null
        /**
         * The refresh token time limit. After this limit expires, your user can't use their refresh token. To specify the time unit for `RefreshTokenValidity` as `seconds`, `minutes`, `hours`, or `days`, set a `TokenValidityUnits` value in your API request.
         *
         * For example, when you set `RefreshTokenValidity` as `10` and `TokenValidityUnits` as `days`, your user can refresh their session and retrieve new access and ID tokens for 10 days.
         *
         * The default time unit for `RefreshTokenValidity` in an API request is days. You can't set `RefreshTokenValidity` to 0. If you do, Amazon Cognito overrides the value with the default value of 30 days. *Valid range* is displayed below in seconds.
         */
        var refreshTokenValidity: kotlin.Int = 0
        /**
         * A list of provider names for the IdPs that this client supports. The following are supported: `COGNITO`, `Facebook`, `Google``LoginWithAmazon`, and the names of your own SAML and OIDC providers.
         */
        var supportedIdentityProviders: List<String>? = null
        /**
         * The time units used to specify the token validity times of each token type: ID, access, and refresh.
         */
        var tokenValidityUnits: aws.sdk.kotlin.services.cognitoidentityprovider.model.TokenValidityUnitsType? = null
        /**
         * The user pool ID for the user pool client.
         */
        var userPoolId: kotlin.String? = null
        /**
         * The writeable attributes.
         */
        var writeAttributes: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolClientType) : this() {
            this.accessTokenValidity = x.accessTokenValidity
            this.allowedOAuthFlows = x.allowedOAuthFlows
            this.allowedOAuthFlowsUserPoolClient = x.allowedOAuthFlowsUserPoolClient
            this.allowedOAuthScopes = x.allowedOAuthScopes
            this.analyticsConfiguration = x.analyticsConfiguration
            this.callbackUrLs = x.callbackUrLs
            this.clientId = x.clientId
            this.clientName = x.clientName
            this.clientSecret = x.clientSecret
            this.creationDate = x.creationDate
            this.defaultRedirectUri = x.defaultRedirectUri
            this.enablePropagateAdditionalUserContextData = x.enablePropagateAdditionalUserContextData
            this.enableTokenRevocation = x.enableTokenRevocation
            this.explicitAuthFlows = x.explicitAuthFlows
            this.idTokenValidity = x.idTokenValidity
            this.lastModifiedDate = x.lastModifiedDate
            this.logoutUrLs = x.logoutUrLs
            this.preventUserExistenceErrors = x.preventUserExistenceErrors
            this.readAttributes = x.readAttributes
            this.refreshTokenValidity = x.refreshTokenValidity
            this.supportedIdentityProviders = x.supportedIdentityProviders
            this.tokenValidityUnits = x.tokenValidityUnits
            this.userPoolId = x.userPoolId
            this.writeAttributes = x.writeAttributes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolClientType = UserPoolClientType(this)

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsConfigurationType] inside the given [block]
         */
        fun analyticsConfiguration(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsConfigurationType.Builder.() -> kotlin.Unit) {
            this.analyticsConfiguration = aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsConfigurationType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.TokenValidityUnitsType] inside the given [block]
         */
        fun tokenValidityUnits(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.TokenValidityUnitsType.Builder.() -> kotlin.Unit) {
            this.tokenValidityUnits = aws.sdk.kotlin.services.cognitoidentityprovider.model.TokenValidityUnitsType.invoke(block)
        }
    }
}
