// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The user import job type.
 */
class UserImportJobType private constructor(builder: Builder) {
    /**
     * The role Amazon Resource Name (ARN) for the Amazon CloudWatch Logging role for the user import job. For more information, see "Creating the CloudWatch Logs IAM Role" in the Amazon Cognito Developer Guide.
     */
    val cloudWatchLogsRoleArn: kotlin.String? = builder.cloudWatchLogsRoleArn
    /**
     * The date when the user import job was completed.
     */
    val completionDate: aws.smithy.kotlin.runtime.time.Instant? = builder.completionDate
    /**
     * The message returned when the user import job is completed.
     */
    val completionMessage: kotlin.String? = builder.completionMessage
    /**
     * The date the user import job was created.
     */
    val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * The number of users that couldn't be imported.
     */
    val failedUsers: kotlin.Long = builder.failedUsers
    /**
     * The number of users that were successfully imported.
     */
    val importedUsers: kotlin.Long = builder.importedUsers
    /**
     * The job ID for the user import job.
     */
    val jobId: kotlin.String? = builder.jobId
    /**
     * The job name for the user import job.
     */
    val jobName: kotlin.String? = builder.jobName
    /**
     * The pre-signed URL to be used to upload the `.csv` file.
     */
    val preSignedUrl: kotlin.String? = builder.preSignedUrl
    /**
     * The number of users that were skipped.
     */
    val skippedUsers: kotlin.Long = builder.skippedUsers
    /**
     * The date when the user import job was started.
     */
    val startDate: aws.smithy.kotlin.runtime.time.Instant? = builder.startDate
    /**
     * The status of the user import job. One of the following:
     * + `Created` - The job was created but not started.
     * + `Pending` - A transition state. You have started the job, but it has not begun importing users yet.
     * + `InProgress` - The job has started, and users are being imported.
     * + `Stopping` - You have stopped the job, but the job has not stopped importing users yet.
     * + `Stopped` - You have stopped the job, and the job has stopped importing users.
     * + `Succeeded` - The job has completed successfully.
     * + `Failed` - The job has stopped due to an error.
     * + `Expired` - You created a job, but did not start the job within 24-48 hours. All data associated with the job was deleted, and the job can't be started.
     */
    val status: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserImportJobStatusType? = builder.status
    /**
     * The user pool ID for the user pool that the users are being imported into.
     */
    val userPoolId: kotlin.String? = builder.userPoolId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.UserImportJobType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UserImportJobType(")
        append("cloudWatchLogsRoleArn=$cloudWatchLogsRoleArn,")
        append("completionDate=$completionDate,")
        append("completionMessage=$completionMessage,")
        append("creationDate=$creationDate,")
        append("failedUsers=$failedUsers,")
        append("importedUsers=$importedUsers,")
        append("jobId=$jobId,")
        append("jobName=$jobName,")
        append("preSignedUrl=$preSignedUrl,")
        append("skippedUsers=$skippedUsers,")
        append("startDate=$startDate,")
        append("status=$status,")
        append("userPoolId=$userPoolId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchLogsRoleArn?.hashCode() ?: 0
        result = 31 * result + (completionDate?.hashCode() ?: 0)
        result = 31 * result + (completionMessage?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (failedUsers.hashCode())
        result = 31 * result + (importedUsers.hashCode())
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (preSignedUrl?.hashCode() ?: 0)
        result = 31 * result + (skippedUsers.hashCode())
        result = 31 * result + (startDate?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (userPoolId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UserImportJobType

        if (cloudWatchLogsRoleArn != other.cloudWatchLogsRoleArn) return false
        if (completionDate != other.completionDate) return false
        if (completionMessage != other.completionMessage) return false
        if (creationDate != other.creationDate) return false
        if (failedUsers != other.failedUsers) return false
        if (importedUsers != other.importedUsers) return false
        if (jobId != other.jobId) return false
        if (jobName != other.jobName) return false
        if (preSignedUrl != other.preSignedUrl) return false
        if (skippedUsers != other.skippedUsers) return false
        if (startDate != other.startDate) return false
        if (status != other.status) return false
        if (userPoolId != other.userPoolId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.UserImportJobType = Builder(this).apply(block).build()

    class Builder {
        /**
         * The role Amazon Resource Name (ARN) for the Amazon CloudWatch Logging role for the user import job. For more information, see "Creating the CloudWatch Logs IAM Role" in the Amazon Cognito Developer Guide.
         */
        var cloudWatchLogsRoleArn: kotlin.String? = null
        /**
         * The date when the user import job was completed.
         */
        var completionDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The message returned when the user import job is completed.
         */
        var completionMessage: kotlin.String? = null
        /**
         * The date the user import job was created.
         */
        var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of users that couldn't be imported.
         */
        var failedUsers: kotlin.Long = 0L
        /**
         * The number of users that were successfully imported.
         */
        var importedUsers: kotlin.Long = 0L
        /**
         * The job ID for the user import job.
         */
        var jobId: kotlin.String? = null
        /**
         * The job name for the user import job.
         */
        var jobName: kotlin.String? = null
        /**
         * The pre-signed URL to be used to upload the `.csv` file.
         */
        var preSignedUrl: kotlin.String? = null
        /**
         * The number of users that were skipped.
         */
        var skippedUsers: kotlin.Long = 0L
        /**
         * The date when the user import job was started.
         */
        var startDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the user import job. One of the following:
         * + `Created` - The job was created but not started.
         * + `Pending` - A transition state. You have started the job, but it has not begun importing users yet.
         * + `InProgress` - The job has started, and users are being imported.
         * + `Stopping` - You have stopped the job, but the job has not stopped importing users yet.
         * + `Stopped` - You have stopped the job, and the job has stopped importing users.
         * + `Succeeded` - The job has completed successfully.
         * + `Failed` - The job has stopped due to an error.
         * + `Expired` - You created a job, but did not start the job within 24-48 hours. All data associated with the job was deleted, and the job can't be started.
         */
        var status: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserImportJobStatusType? = null
        /**
         * The user pool ID for the user pool that the users are being imported into.
         */
        var userPoolId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserImportJobType) : this() {
            this.cloudWatchLogsRoleArn = x.cloudWatchLogsRoleArn
            this.completionDate = x.completionDate
            this.completionMessage = x.completionMessage
            this.creationDate = x.creationDate
            this.failedUsers = x.failedUsers
            this.importedUsers = x.importedUsers
            this.jobId = x.jobId
            this.jobName = x.jobName
            this.preSignedUrl = x.preSignedUrl
            this.skippedUsers = x.skippedUsers
            this.startDate = x.startDate
            this.status = x.status
            this.userPoolId = x.userPoolId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.UserImportJobType = UserImportJobType(this)
    }
}
