// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model



/**
 * The type used for enabling SMS multi-factor authentication (MFA) at the user level. Phone numbers don't need to be verified to be used for SMS MFA. If an MFA type is activated for a user, the user will be prompted for MFA during all sign-in attempts, unless device tracking is turned on and the device has been trusted. If you would like MFA to be applied selectively based on the assessed risk level of sign-in attempts, deactivate MFA for users and turn on Adaptive Authentication for the user pool.
 */
class SmsMfaSettingsType private constructor(builder: Builder) {
    /**
     * Specifies whether SMS text message MFA is activated. If an MFA type is activated for a user, the user will be prompted for MFA during all sign-in attempts, unless device tracking is turned on and the device has been trusted.
     */
    val enabled: kotlin.Boolean = builder.enabled
    /**
     * Specifies whether SMS is the preferred MFA method.
     */
    val preferredMfa: kotlin.Boolean = builder.preferredMfa

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.SmsMfaSettingsType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SmsMfaSettingsType(")
        append("enabled=$enabled,")
        append("preferredMfa=$preferredMfa)")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled.hashCode()
        result = 31 * result + (preferredMfa.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SmsMfaSettingsType

        if (enabled != other.enabled) return false
        if (preferredMfa != other.preferredMfa) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.SmsMfaSettingsType = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies whether SMS text message MFA is activated. If an MFA type is activated for a user, the user will be prompted for MFA during all sign-in attempts, unless device tracking is turned on and the device has been trusted.
         */
        var enabled: kotlin.Boolean = false
        /**
         * Specifies whether SMS is the preferred MFA method.
         */
        var preferredMfa: kotlin.Boolean = false

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.SmsMfaSettingsType) : this() {
            this.enabled = x.enabled
            this.preferredMfa = x.preferredMfa
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.SmsMfaSettingsType = SmsMfaSettingsType(this)
    }
}
