// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model



/**
 * The request to respond to an authentication challenge.
 */
class RespondToAuthChallengeRequest private constructor(builder: Builder) {
    /**
     * The Amazon Pinpoint analytics metadata that contributes to your metrics for `RespondToAuthChallenge` calls.
     */
    val analyticsMetadata: aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsMetadataType? = builder.analyticsMetadata
    /**
     * The challenge name. For more information, see [InitiateAuth](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html).
     *
     * `ADMIN_NO_SRP_AUTH` isn't a valid value.
     */
    val challengeName: aws.sdk.kotlin.services.cognitoidentityprovider.model.ChallengeNameType? = builder.challengeName
    /**
     * The challenge responses. These are inputs corresponding to the value of `ChallengeName`, for example:
     *
     * `SECRET_HASH` (if app client is configured with client secret) applies to all of the inputs that follow (including `SOFTWARE_TOKEN_MFA`).
     *
     * + `SMS_MFA`: `SMS_MFA_CODE`, `USERNAME`.
     * + `PASSWORD_VERIFIER`: `PASSWORD_CLAIM_SIGNATURE`, `PASSWORD_CLAIM_SECRET_BLOCK`, `TIMESTAMP`, `USERNAME`.`PASSWORD_VERIFIER` requires `DEVICE_KEY` when you sign in with a remembered device.
     * + `NEW_PASSWORD_REQUIRED`: `NEW_PASSWORD`, `USERNAME`, `SECRET_HASH` (if app client is configured with client secret). To set any required attributes that Amazon Cognito returned as `requiredAttributes` in the `InitiateAuth` response, add a `userAttributes.<i>attributename</i> ` parameter. This parameter can also set values for writable attributes that aren't required by your user pool.In a `NEW_PASSWORD_REQUIRED` challenge response, you can't modify a required attribute that already has a value. In `RespondToAuthChallenge`, set a value for any keys that Amazon Cognito returned in the `requiredAttributes` parameter, then use the `UpdateUserAttributes` API operation to modify the value of any additional attributes.
     * + `SOFTWARE_TOKEN_MFA`: `USERNAME` and `SOFTWARE_TOKEN_MFA_CODE` are required attributes.
     * + `DEVICE_SRP_AUTH` requires `USERNAME`, `DEVICE_KEY`, `SRP_A` (and `SECRET_HASH`).
     * + `DEVICE_PASSWORD_VERIFIER` requires everything that `PASSWORD_VERIFIER` requires, plus `DEVICE_KEY`.
     * + `MFA_SETUP` requires `USERNAME`, plus you must use the session value returned by `VerifySoftwareToken` in the `Session` parameter.
     */
    val challengeResponses: Map<String, String>? = builder.challengeResponses
    /**
     * The app client ID.
     */
    val clientId: kotlin.String? = builder.clientId
    /**
     * A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.
     *
     * You create custom workflows by assigning Lambda functions to user pool triggers. When you use the RespondToAuthChallenge API action, Amazon Cognito invokes any functions that are assigned to the following triggers: *post authentication*, *pre token generation*, *define auth challenge*, *create auth challenge*, and *verify auth challenge*. When Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function receives as input. This payload contains a `clientMetadata` attribute, which provides the data that you assigned to the ClientMetadata parameter in your RespondToAuthChallenge request. In your function code in Lambda, you can process the `clientMetadata` value to enhance your workflow for your specific needs.
     *
     * For more information, see [ Customizing user pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html) in the *Amazon Cognito Developer Guide*.
     *
     * When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:
     * + Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.
     * + Validate the ClientMetadata value.
     * + Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.
     */
    val clientMetadata: Map<String, String>? = builder.clientMetadata
    /**
     * The session that should be passed both ways in challenge-response calls to the service. If `InitiateAuth` or `RespondToAuthChallenge` API call determines that the caller must pass another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next `RespondToAuthChallenge` API call.
     */
    val session: kotlin.String? = builder.session
    /**
     * Contextual data about your user session, such as the device fingerprint, IP address, or location. Amazon Cognito advanced security evaluates the risk of an authentication event based on the context that your app generates and passes to Amazon Cognito when it makes API requests.
     */
    val userContextData: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserContextDataType? = builder.userContextData

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.RespondToAuthChallengeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RespondToAuthChallengeRequest(")
        append("analyticsMetadata=$analyticsMetadata,")
        append("challengeName=$challengeName,")
        append("challengeResponses=$challengeResponses,")
        append("clientId=*** Sensitive Data Redacted ***,")
        append("clientMetadata=$clientMetadata,")
        append("session=$session,")
        append("userContextData=$userContextData)")
    }

    override fun hashCode(): kotlin.Int {
        var result = analyticsMetadata?.hashCode() ?: 0
        result = 31 * result + (challengeName?.hashCode() ?: 0)
        result = 31 * result + (challengeResponses?.hashCode() ?: 0)
        result = 31 * result + (clientId?.hashCode() ?: 0)
        result = 31 * result + (clientMetadata?.hashCode() ?: 0)
        result = 31 * result + (session?.hashCode() ?: 0)
        result = 31 * result + (userContextData?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RespondToAuthChallengeRequest

        if (analyticsMetadata != other.analyticsMetadata) return false
        if (challengeName != other.challengeName) return false
        if (challengeResponses != other.challengeResponses) return false
        if (clientId != other.clientId) return false
        if (clientMetadata != other.clientMetadata) return false
        if (session != other.session) return false
        if (userContextData != other.userContextData) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.RespondToAuthChallengeRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Pinpoint analytics metadata that contributes to your metrics for `RespondToAuthChallenge` calls.
         */
        var analyticsMetadata: aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsMetadataType? = null
        /**
         * The challenge name. For more information, see [InitiateAuth](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html).
         *
         * `ADMIN_NO_SRP_AUTH` isn't a valid value.
         */
        var challengeName: aws.sdk.kotlin.services.cognitoidentityprovider.model.ChallengeNameType? = null
        /**
         * The challenge responses. These are inputs corresponding to the value of `ChallengeName`, for example:
         *
         * `SECRET_HASH` (if app client is configured with client secret) applies to all of the inputs that follow (including `SOFTWARE_TOKEN_MFA`).
         *
         * + `SMS_MFA`: `SMS_MFA_CODE`, `USERNAME`.
         * + `PASSWORD_VERIFIER`: `PASSWORD_CLAIM_SIGNATURE`, `PASSWORD_CLAIM_SECRET_BLOCK`, `TIMESTAMP`, `USERNAME`.`PASSWORD_VERIFIER` requires `DEVICE_KEY` when you sign in with a remembered device.
         * + `NEW_PASSWORD_REQUIRED`: `NEW_PASSWORD`, `USERNAME`, `SECRET_HASH` (if app client is configured with client secret). To set any required attributes that Amazon Cognito returned as `requiredAttributes` in the `InitiateAuth` response, add a `userAttributes.<i>attributename</i> ` parameter. This parameter can also set values for writable attributes that aren't required by your user pool.In a `NEW_PASSWORD_REQUIRED` challenge response, you can't modify a required attribute that already has a value. In `RespondToAuthChallenge`, set a value for any keys that Amazon Cognito returned in the `requiredAttributes` parameter, then use the `UpdateUserAttributes` API operation to modify the value of any additional attributes.
         * + `SOFTWARE_TOKEN_MFA`: `USERNAME` and `SOFTWARE_TOKEN_MFA_CODE` are required attributes.
         * + `DEVICE_SRP_AUTH` requires `USERNAME`, `DEVICE_KEY`, `SRP_A` (and `SECRET_HASH`).
         * + `DEVICE_PASSWORD_VERIFIER` requires everything that `PASSWORD_VERIFIER` requires, plus `DEVICE_KEY`.
         * + `MFA_SETUP` requires `USERNAME`, plus you must use the session value returned by `VerifySoftwareToken` in the `Session` parameter.
         */
        var challengeResponses: Map<String, String>? = null
        /**
         * The app client ID.
         */
        var clientId: kotlin.String? = null
        /**
         * A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.
         *
         * You create custom workflows by assigning Lambda functions to user pool triggers. When you use the RespondToAuthChallenge API action, Amazon Cognito invokes any functions that are assigned to the following triggers: *post authentication*, *pre token generation*, *define auth challenge*, *create auth challenge*, and *verify auth challenge*. When Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function receives as input. This payload contains a `clientMetadata` attribute, which provides the data that you assigned to the ClientMetadata parameter in your RespondToAuthChallenge request. In your function code in Lambda, you can process the `clientMetadata` value to enhance your workflow for your specific needs.
         *
         * For more information, see [ Customizing user pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html) in the *Amazon Cognito Developer Guide*.
         *
         * When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:
         * + Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.
         * + Validate the ClientMetadata value.
         * + Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.
         */
        var clientMetadata: Map<String, String>? = null
        /**
         * The session that should be passed both ways in challenge-response calls to the service. If `InitiateAuth` or `RespondToAuthChallenge` API call determines that the caller must pass another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next `RespondToAuthChallenge` API call.
         */
        var session: kotlin.String? = null
        /**
         * Contextual data about your user session, such as the device fingerprint, IP address, or location. Amazon Cognito advanced security evaluates the risk of an authentication event based on the context that your app generates and passes to Amazon Cognito when it makes API requests.
         */
        var userContextData: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserContextDataType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.RespondToAuthChallengeRequest) : this() {
            this.analyticsMetadata = x.analyticsMetadata
            this.challengeName = x.challengeName
            this.challengeResponses = x.challengeResponses
            this.clientId = x.clientId
            this.clientMetadata = x.clientMetadata
            this.session = x.session
            this.userContextData = x.userContextData
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.RespondToAuthChallengeRequest = RespondToAuthChallengeRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsMetadataType] inside the given [block]
         */
        fun analyticsMetadata(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsMetadataType.Builder.() -> kotlin.Unit) {
            this.analyticsMetadata = aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsMetadataType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.UserContextDataType] inside the given [block]
         */
        fun userContextData(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserContextDataType.Builder.() -> kotlin.Unit) {
            this.userContextData = aws.sdk.kotlin.services.cognitoidentityprovider.model.UserContextDataType.invoke(block)
        }
    }
}
