// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model



/**
 * Represents the request to reset a user's password.
 */
class ForgotPasswordRequest private constructor(builder: Builder) {
    /**
     * The Amazon Pinpoint analytics metadata that contributes to your metrics for `ForgotPassword` calls.
     */
    val analyticsMetadata: aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsMetadataType? = builder.analyticsMetadata
    /**
     * The ID of the client associated with the user pool.
     */
    val clientId: kotlin.String? = builder.clientId
    /**
     * A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.
     *
     * You create custom workflows by assigning Lambda functions to user pool triggers. When you use the ForgotPassword API action, Amazon Cognito invokes any functions that are assigned to the following triggers: *pre sign-up*, *custom message*, and *user migration*. When Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function receives as input. This payload contains a `clientMetadata` attribute, which provides the data that you assigned to the ClientMetadata parameter in your ForgotPassword request. In your function code in Lambda, you can process the `clientMetadata` value to enhance your workflow for your specific needs.
     *
     * For more information, see [ Customizing user pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html) in the *Amazon Cognito Developer Guide*.
     *
     * When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:
     * + Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.
     * + Validate the ClientMetadata value.
     * + Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.
     */
    val clientMetadata: Map<String, String>? = builder.clientMetadata
    /**
     * A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.
     */
    val secretHash: kotlin.String? = builder.secretHash
    /**
     * Contextual data about your user session, such as the device fingerprint, IP address, or location. Amazon Cognito advanced security evaluates the risk of an authentication event based on the context that your app generates and passes to Amazon Cognito when it makes API requests.
     */
    val userContextData: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserContextDataType? = builder.userContextData
    /**
     * The user name of the user for whom you want to enter a code to reset a forgotten password.
     */
    val username: kotlin.String? = builder.username

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.ForgotPasswordRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ForgotPasswordRequest(")
        append("analyticsMetadata=$analyticsMetadata,")
        append("clientId=*** Sensitive Data Redacted ***,")
        append("clientMetadata=$clientMetadata,")
        append("secretHash=*** Sensitive Data Redacted ***,")
        append("userContextData=$userContextData,")
        append("username=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = analyticsMetadata?.hashCode() ?: 0
        result = 31 * result + (clientId?.hashCode() ?: 0)
        result = 31 * result + (clientMetadata?.hashCode() ?: 0)
        result = 31 * result + (secretHash?.hashCode() ?: 0)
        result = 31 * result + (userContextData?.hashCode() ?: 0)
        result = 31 * result + (username?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ForgotPasswordRequest

        if (analyticsMetadata != other.analyticsMetadata) return false
        if (clientId != other.clientId) return false
        if (clientMetadata != other.clientMetadata) return false
        if (secretHash != other.secretHash) return false
        if (userContextData != other.userContextData) return false
        if (username != other.username) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.ForgotPasswordRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Pinpoint analytics metadata that contributes to your metrics for `ForgotPassword` calls.
         */
        var analyticsMetadata: aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsMetadataType? = null
        /**
         * The ID of the client associated with the user pool.
         */
        var clientId: kotlin.String? = null
        /**
         * A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.
         *
         * You create custom workflows by assigning Lambda functions to user pool triggers. When you use the ForgotPassword API action, Amazon Cognito invokes any functions that are assigned to the following triggers: *pre sign-up*, *custom message*, and *user migration*. When Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function receives as input. This payload contains a `clientMetadata` attribute, which provides the data that you assigned to the ClientMetadata parameter in your ForgotPassword request. In your function code in Lambda, you can process the `clientMetadata` value to enhance your workflow for your specific needs.
         *
         * For more information, see [ Customizing user pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html) in the *Amazon Cognito Developer Guide*.
         *
         * When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:
         * + Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.
         * + Validate the ClientMetadata value.
         * + Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.
         */
        var clientMetadata: Map<String, String>? = null
        /**
         * A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.
         */
        var secretHash: kotlin.String? = null
        /**
         * Contextual data about your user session, such as the device fingerprint, IP address, or location. Amazon Cognito advanced security evaluates the risk of an authentication event based on the context that your app generates and passes to Amazon Cognito when it makes API requests.
         */
        var userContextData: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserContextDataType? = null
        /**
         * The user name of the user for whom you want to enter a code to reset a forgotten password.
         */
        var username: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.ForgotPasswordRequest) : this() {
            this.analyticsMetadata = x.analyticsMetadata
            this.clientId = x.clientId
            this.clientMetadata = x.clientMetadata
            this.secretHash = x.secretHash
            this.userContextData = x.userContextData
            this.username = x.username
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.ForgotPasswordRequest = ForgotPasswordRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsMetadataType] inside the given [block]
         */
        fun analyticsMetadata(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsMetadataType.Builder.() -> kotlin.Unit) {
            this.analyticsMetadata = aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsMetadataType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.UserContextDataType] inside the given [block]
         */
        fun userContextData(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserContextDataType.Builder.() -> kotlin.Unit) {
            this.userContextData = aws.sdk.kotlin.services.cognitoidentityprovider.model.UserContextDataType.invoke(block)
        }
    }
}
