// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model



/**
 * A container for information about a domain.
 */
class DomainDescriptionType private constructor(builder: Builder) {
    /**
     * The Amazon Web Services ID for the user pool owner.
     */
    val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * The Amazon Resource Name (ARN) of the Amazon CloudFront distribution.
     */
    val cloudFrontDistribution: kotlin.String? = builder.cloudFrontDistribution
    /**
     * The configuration for a custom domain that hosts the sign-up and sign-in webpages for your application.
     */
    val customDomainConfig: aws.sdk.kotlin.services.cognitoidentityprovider.model.CustomDomainConfigType? = builder.customDomainConfig
    /**
     * The domain string. For custom domains, this is the fully-qualified domain name, such as `auth.example.com`. For Amazon Cognito prefix domains, this is the prefix alone, such as `auth`.
     */
    val domain: kotlin.String? = builder.domain
    /**
     * The Amazon S3 bucket where the static files for this domain are stored.
     */
    val s3Bucket: kotlin.String? = builder.s3Bucket
    /**
     * The domain status.
     */
    val status: aws.sdk.kotlin.services.cognitoidentityprovider.model.DomainStatusType? = builder.status
    /**
     * The user pool ID.
     */
    val userPoolId: kotlin.String? = builder.userPoolId
    /**
     * The app version.
     */
    val version: kotlin.String? = builder.version

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.DomainDescriptionType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DomainDescriptionType(")
        append("awsAccountId=$awsAccountId,")
        append("cloudFrontDistribution=$cloudFrontDistribution,")
        append("customDomainConfig=$customDomainConfig,")
        append("domain=$domain,")
        append("s3Bucket=$s3Bucket,")
        append("status=$status,")
        append("userPoolId=$userPoolId,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (cloudFrontDistribution?.hashCode() ?: 0)
        result = 31 * result + (customDomainConfig?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (s3Bucket?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (userPoolId?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DomainDescriptionType

        if (awsAccountId != other.awsAccountId) return false
        if (cloudFrontDistribution != other.cloudFrontDistribution) return false
        if (customDomainConfig != other.customDomainConfig) return false
        if (domain != other.domain) return false
        if (s3Bucket != other.s3Bucket) return false
        if (status != other.status) return false
        if (userPoolId != other.userPoolId) return false
        if (version != other.version) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.DomainDescriptionType = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Web Services ID for the user pool owner.
         */
        var awsAccountId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon CloudFront distribution.
         */
        var cloudFrontDistribution: kotlin.String? = null
        /**
         * The configuration for a custom domain that hosts the sign-up and sign-in webpages for your application.
         */
        var customDomainConfig: aws.sdk.kotlin.services.cognitoidentityprovider.model.CustomDomainConfigType? = null
        /**
         * The domain string. For custom domains, this is the fully-qualified domain name, such as `auth.example.com`. For Amazon Cognito prefix domains, this is the prefix alone, such as `auth`.
         */
        var domain: kotlin.String? = null
        /**
         * The Amazon S3 bucket where the static files for this domain are stored.
         */
        var s3Bucket: kotlin.String? = null
        /**
         * The domain status.
         */
        var status: aws.sdk.kotlin.services.cognitoidentityprovider.model.DomainStatusType? = null
        /**
         * The user pool ID.
         */
        var userPoolId: kotlin.String? = null
        /**
         * The app version.
         */
        var version: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.DomainDescriptionType) : this() {
            this.awsAccountId = x.awsAccountId
            this.cloudFrontDistribution = x.cloudFrontDistribution
            this.customDomainConfig = x.customDomainConfig
            this.domain = x.domain
            this.s3Bucket = x.s3Bucket
            this.status = x.status
            this.userPoolId = x.userPoolId
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.DomainDescriptionType = DomainDescriptionType(this)

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.CustomDomainConfigType] inside the given [block]
         */
        fun customDomainConfig(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.CustomDomainConfigType.Builder.() -> kotlin.Unit) {
            this.customDomainConfig = aws.sdk.kotlin.services.cognitoidentityprovider.model.CustomDomainConfigType.invoke(block)
        }
    }
}
