// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model



/**
 * Represents the request to create a user pool.
 */
class CreateUserPoolRequest private constructor(builder: Builder) {
    /**
     * The available verified method a user can use to recover their password when they call `ForgotPassword`. You can use this setting to define a preferred method when a user has more than one method available. With this setting, SMS doesn't qualify for a valid password recovery mechanism if the user also has SMS multi-factor authentication (MFA) activated. In the absence of this setting, Amazon Cognito uses the legacy behavior to determine the recovery method where SMS is preferred through email.
     */
    val accountRecoverySetting: aws.sdk.kotlin.services.cognitoidentityprovider.model.AccountRecoverySettingType? = builder.accountRecoverySetting
    /**
     * The configuration for `AdminCreateUser` requests.
     */
    val adminCreateUserConfig: aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminCreateUserConfigType? = builder.adminCreateUserConfig
    /**
     * Attributes supported as an alias for this user pool. Possible values: **phone_number**, **email**, or **preferred_username**.
     */
    val aliasAttributes: List<AliasAttributeType>? = builder.aliasAttributes
    /**
     * The attributes to be auto-verified. Possible values: **email**, **phone_number**.
     */
    val autoVerifiedAttributes: List<VerifiedAttributeType>? = builder.autoVerifiedAttributes
    /**
     * The device configuration.
     */
    val deviceConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.DeviceConfigurationType? = builder.deviceConfiguration
    /**
     * The email configuration of your user pool. The email configuration type sets your preferred sending method, Amazon Web Services Region, and sender for messages from your user pool.
     */
    val emailConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.EmailConfigurationType? = builder.emailConfiguration
    /**
     * A string representing the email verification message. EmailVerificationMessage is allowed only if [EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is DEVELOPER.
     */
    val emailVerificationMessage: kotlin.String? = builder.emailVerificationMessage
    /**
     * A string representing the email verification subject. EmailVerificationSubject is allowed only if [EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is DEVELOPER.
     */
    val emailVerificationSubject: kotlin.String? = builder.emailVerificationSubject
    /**
     * The Lambda trigger configuration information for the new user pool.
     *
     * In a push model, event sources (such as Amazon S3 and custom applications) need permission to invoke a function. So you must make an extra call to add permission for these event sources to invoke your Lambda function.
     *
     * For more information on using the Lambda API to add permission, see[ AddPermission ](https://docs.aws.amazon.com/lambda/latest/dg/API_AddPermission.html).
     *
     * For adding permission using the CLI, see[ add-permission ](https://docs.aws.amazon.com/cli/latest/reference/lambda/add-permission.html).
     */
    val lambdaConfig: aws.sdk.kotlin.services.cognitoidentityprovider.model.LambdaConfigType? = builder.lambdaConfig
    /**
     * Specifies MFA configuration details.
     */
    val mfaConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolMfaType? = builder.mfaConfiguration
    /**
     * The policies associated with the new user pool.
     */
    val policies: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolPolicyType? = builder.policies
    /**
     * A string used to name the user pool.
     */
    val poolName: kotlin.String? = builder.poolName
    /**
     * An array of schema attributes for the new user pool. These attributes can be standard or custom attributes.
     */
    val schema: List<SchemaAttributeType>? = builder.schema
    /**
     * A string representing the SMS authentication message.
     */
    val smsAuthenticationMessage: kotlin.String? = builder.smsAuthenticationMessage
    /**
     * The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from your Amazon Web Services account through Amazon Simple Notification Service. To send SMS messages with Amazon SNS in the Amazon Web Services Region that you want, the Amazon Cognito user pool uses an Identity and Access Management (IAM) role in your Amazon Web Services account.
     */
    val smsConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.SmsConfigurationType? = builder.smsConfiguration
    /**
     * A string representing the SMS verification message.
     */
    val smsVerificationMessage: kotlin.String? = builder.smsVerificationMessage
    /**
     * The settings for updates to user attributes. These settings include the property `AttributesRequireVerificationBeforeUpdate`, a user-pool setting that tells Amazon Cognito how to handle changes to the value of your users' email address and phone number attributes. For more information, see [ Verifying updates to to email addresses and phone numbers](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html#user-pool-settings-verifications-verify-attribute-updates).
     */
    val userAttributeUpdateSettings: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserAttributeUpdateSettingsType? = builder.userAttributeUpdateSettings
    /**
     * Enables advanced security risk detection. Set the key `AdvancedSecurityMode` to the value "AUDIT".
     */
    val userPoolAddOns: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolAddOnsType? = builder.userPoolAddOns
    /**
     * The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.
     */
    val userPoolTags: Map<String, String>? = builder.userPoolTags
    /**
     * Specifies whether a user can use an email address or phone number as a username when they sign up.
     */
    val usernameAttributes: List<UsernameAttributeType>? = builder.usernameAttributes
    /**
     * Case sensitivity on the username input for the selected sign-in option. For example, when case sensitivity is set to `False`, users can sign in using either "username" or "Username". This configuration is immutable once it has been set. For more information, see [UsernameConfigurationType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UsernameConfigurationType.html).
     */
    val usernameConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.UsernameConfigurationType? = builder.usernameConfiguration
    /**
     * The template for the verification message that the user sees when the app requests permission to access the user's information.
     */
    val verificationMessageTemplate: aws.sdk.kotlin.services.cognitoidentityprovider.model.VerificationMessageTemplateType? = builder.verificationMessageTemplate

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateUserPoolRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateUserPoolRequest(")
        append("accountRecoverySetting=$accountRecoverySetting,")
        append("adminCreateUserConfig=$adminCreateUserConfig,")
        append("aliasAttributes=$aliasAttributes,")
        append("autoVerifiedAttributes=$autoVerifiedAttributes,")
        append("deviceConfiguration=$deviceConfiguration,")
        append("emailConfiguration=$emailConfiguration,")
        append("emailVerificationMessage=$emailVerificationMessage,")
        append("emailVerificationSubject=$emailVerificationSubject,")
        append("lambdaConfig=$lambdaConfig,")
        append("mfaConfiguration=$mfaConfiguration,")
        append("policies=$policies,")
        append("poolName=$poolName,")
        append("schema=$schema,")
        append("smsAuthenticationMessage=$smsAuthenticationMessage,")
        append("smsConfiguration=$smsConfiguration,")
        append("smsVerificationMessage=$smsVerificationMessage,")
        append("userAttributeUpdateSettings=$userAttributeUpdateSettings,")
        append("userPoolAddOns=$userPoolAddOns,")
        append("userPoolTags=$userPoolTags,")
        append("usernameAttributes=$usernameAttributes,")
        append("usernameConfiguration=$usernameConfiguration,")
        append("verificationMessageTemplate=$verificationMessageTemplate)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountRecoverySetting?.hashCode() ?: 0
        result = 31 * result + (adminCreateUserConfig?.hashCode() ?: 0)
        result = 31 * result + (aliasAttributes?.hashCode() ?: 0)
        result = 31 * result + (autoVerifiedAttributes?.hashCode() ?: 0)
        result = 31 * result + (deviceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (emailConfiguration?.hashCode() ?: 0)
        result = 31 * result + (emailVerificationMessage?.hashCode() ?: 0)
        result = 31 * result + (emailVerificationSubject?.hashCode() ?: 0)
        result = 31 * result + (lambdaConfig?.hashCode() ?: 0)
        result = 31 * result + (mfaConfiguration?.hashCode() ?: 0)
        result = 31 * result + (policies?.hashCode() ?: 0)
        result = 31 * result + (poolName?.hashCode() ?: 0)
        result = 31 * result + (schema?.hashCode() ?: 0)
        result = 31 * result + (smsAuthenticationMessage?.hashCode() ?: 0)
        result = 31 * result + (smsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (smsVerificationMessage?.hashCode() ?: 0)
        result = 31 * result + (userAttributeUpdateSettings?.hashCode() ?: 0)
        result = 31 * result + (userPoolAddOns?.hashCode() ?: 0)
        result = 31 * result + (userPoolTags?.hashCode() ?: 0)
        result = 31 * result + (usernameAttributes?.hashCode() ?: 0)
        result = 31 * result + (usernameConfiguration?.hashCode() ?: 0)
        result = 31 * result + (verificationMessageTemplate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateUserPoolRequest

        if (accountRecoverySetting != other.accountRecoverySetting) return false
        if (adminCreateUserConfig != other.adminCreateUserConfig) return false
        if (aliasAttributes != other.aliasAttributes) return false
        if (autoVerifiedAttributes != other.autoVerifiedAttributes) return false
        if (deviceConfiguration != other.deviceConfiguration) return false
        if (emailConfiguration != other.emailConfiguration) return false
        if (emailVerificationMessage != other.emailVerificationMessage) return false
        if (emailVerificationSubject != other.emailVerificationSubject) return false
        if (lambdaConfig != other.lambdaConfig) return false
        if (mfaConfiguration != other.mfaConfiguration) return false
        if (policies != other.policies) return false
        if (poolName != other.poolName) return false
        if (schema != other.schema) return false
        if (smsAuthenticationMessage != other.smsAuthenticationMessage) return false
        if (smsConfiguration != other.smsConfiguration) return false
        if (smsVerificationMessage != other.smsVerificationMessage) return false
        if (userAttributeUpdateSettings != other.userAttributeUpdateSettings) return false
        if (userPoolAddOns != other.userPoolAddOns) return false
        if (userPoolTags != other.userPoolTags) return false
        if (usernameAttributes != other.usernameAttributes) return false
        if (usernameConfiguration != other.usernameConfiguration) return false
        if (verificationMessageTemplate != other.verificationMessageTemplate) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateUserPoolRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The available verified method a user can use to recover their password when they call `ForgotPassword`. You can use this setting to define a preferred method when a user has more than one method available. With this setting, SMS doesn't qualify for a valid password recovery mechanism if the user also has SMS multi-factor authentication (MFA) activated. In the absence of this setting, Amazon Cognito uses the legacy behavior to determine the recovery method where SMS is preferred through email.
         */
        var accountRecoverySetting: aws.sdk.kotlin.services.cognitoidentityprovider.model.AccountRecoverySettingType? = null
        /**
         * The configuration for `AdminCreateUser` requests.
         */
        var adminCreateUserConfig: aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminCreateUserConfigType? = null
        /**
         * Attributes supported as an alias for this user pool. Possible values: **phone_number**, **email**, or **preferred_username**.
         */
        var aliasAttributes: List<AliasAttributeType>? = null
        /**
         * The attributes to be auto-verified. Possible values: **email**, **phone_number**.
         */
        var autoVerifiedAttributes: List<VerifiedAttributeType>? = null
        /**
         * The device configuration.
         */
        var deviceConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.DeviceConfigurationType? = null
        /**
         * The email configuration of your user pool. The email configuration type sets your preferred sending method, Amazon Web Services Region, and sender for messages from your user pool.
         */
        var emailConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.EmailConfigurationType? = null
        /**
         * A string representing the email verification message. EmailVerificationMessage is allowed only if [EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is DEVELOPER.
         */
        var emailVerificationMessage: kotlin.String? = null
        /**
         * A string representing the email verification subject. EmailVerificationSubject is allowed only if [EmailSendingAccount](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount) is DEVELOPER.
         */
        var emailVerificationSubject: kotlin.String? = null
        /**
         * The Lambda trigger configuration information for the new user pool.
         *
         * In a push model, event sources (such as Amazon S3 and custom applications) need permission to invoke a function. So you must make an extra call to add permission for these event sources to invoke your Lambda function.
         *
         * For more information on using the Lambda API to add permission, see[ AddPermission ](https://docs.aws.amazon.com/lambda/latest/dg/API_AddPermission.html).
         *
         * For adding permission using the CLI, see[ add-permission ](https://docs.aws.amazon.com/cli/latest/reference/lambda/add-permission.html).
         */
        var lambdaConfig: aws.sdk.kotlin.services.cognitoidentityprovider.model.LambdaConfigType? = null
        /**
         * Specifies MFA configuration details.
         */
        var mfaConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolMfaType? = null
        /**
         * The policies associated with the new user pool.
         */
        var policies: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolPolicyType? = null
        /**
         * A string used to name the user pool.
         */
        var poolName: kotlin.String? = null
        /**
         * An array of schema attributes for the new user pool. These attributes can be standard or custom attributes.
         */
        var schema: List<SchemaAttributeType>? = null
        /**
         * A string representing the SMS authentication message.
         */
        var smsAuthenticationMessage: kotlin.String? = null
        /**
         * The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from your Amazon Web Services account through Amazon Simple Notification Service. To send SMS messages with Amazon SNS in the Amazon Web Services Region that you want, the Amazon Cognito user pool uses an Identity and Access Management (IAM) role in your Amazon Web Services account.
         */
        var smsConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.SmsConfigurationType? = null
        /**
         * A string representing the SMS verification message.
         */
        var smsVerificationMessage: kotlin.String? = null
        /**
         * The settings for updates to user attributes. These settings include the property `AttributesRequireVerificationBeforeUpdate`, a user-pool setting that tells Amazon Cognito how to handle changes to the value of your users' email address and phone number attributes. For more information, see [ Verifying updates to to email addresses and phone numbers](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html#user-pool-settings-verifications-verify-attribute-updates).
         */
        var userAttributeUpdateSettings: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserAttributeUpdateSettingsType? = null
        /**
         * Enables advanced security risk detection. Set the key `AdvancedSecurityMode` to the value "AUDIT".
         */
        var userPoolAddOns: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolAddOnsType? = null
        /**
         * The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.
         */
        var userPoolTags: Map<String, String>? = null
        /**
         * Specifies whether a user can use an email address or phone number as a username when they sign up.
         */
        var usernameAttributes: List<UsernameAttributeType>? = null
        /**
         * Case sensitivity on the username input for the selected sign-in option. For example, when case sensitivity is set to `False`, users can sign in using either "username" or "Username". This configuration is immutable once it has been set. For more information, see [UsernameConfigurationType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UsernameConfigurationType.html).
         */
        var usernameConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.UsernameConfigurationType? = null
        /**
         * The template for the verification message that the user sees when the app requests permission to access the user's information.
         */
        var verificationMessageTemplate: aws.sdk.kotlin.services.cognitoidentityprovider.model.VerificationMessageTemplateType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateUserPoolRequest) : this() {
            this.accountRecoverySetting = x.accountRecoverySetting
            this.adminCreateUserConfig = x.adminCreateUserConfig
            this.aliasAttributes = x.aliasAttributes
            this.autoVerifiedAttributes = x.autoVerifiedAttributes
            this.deviceConfiguration = x.deviceConfiguration
            this.emailConfiguration = x.emailConfiguration
            this.emailVerificationMessage = x.emailVerificationMessage
            this.emailVerificationSubject = x.emailVerificationSubject
            this.lambdaConfig = x.lambdaConfig
            this.mfaConfiguration = x.mfaConfiguration
            this.policies = x.policies
            this.poolName = x.poolName
            this.schema = x.schema
            this.smsAuthenticationMessage = x.smsAuthenticationMessage
            this.smsConfiguration = x.smsConfiguration
            this.smsVerificationMessage = x.smsVerificationMessage
            this.userAttributeUpdateSettings = x.userAttributeUpdateSettings
            this.userPoolAddOns = x.userPoolAddOns
            this.userPoolTags = x.userPoolTags
            this.usernameAttributes = x.usernameAttributes
            this.usernameConfiguration = x.usernameConfiguration
            this.verificationMessageTemplate = x.verificationMessageTemplate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateUserPoolRequest = CreateUserPoolRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.AccountRecoverySettingType] inside the given [block]
         */
        fun accountRecoverySetting(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.AccountRecoverySettingType.Builder.() -> kotlin.Unit) {
            this.accountRecoverySetting = aws.sdk.kotlin.services.cognitoidentityprovider.model.AccountRecoverySettingType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminCreateUserConfigType] inside the given [block]
         */
        fun adminCreateUserConfig(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminCreateUserConfigType.Builder.() -> kotlin.Unit) {
            this.adminCreateUserConfig = aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminCreateUserConfigType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.DeviceConfigurationType] inside the given [block]
         */
        fun deviceConfiguration(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.DeviceConfigurationType.Builder.() -> kotlin.Unit) {
            this.deviceConfiguration = aws.sdk.kotlin.services.cognitoidentityprovider.model.DeviceConfigurationType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.EmailConfigurationType] inside the given [block]
         */
        fun emailConfiguration(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.EmailConfigurationType.Builder.() -> kotlin.Unit) {
            this.emailConfiguration = aws.sdk.kotlin.services.cognitoidentityprovider.model.EmailConfigurationType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.LambdaConfigType] inside the given [block]
         */
        fun lambdaConfig(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.LambdaConfigType.Builder.() -> kotlin.Unit) {
            this.lambdaConfig = aws.sdk.kotlin.services.cognitoidentityprovider.model.LambdaConfigType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolPolicyType] inside the given [block]
         */
        fun policies(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolPolicyType.Builder.() -> kotlin.Unit) {
            this.policies = aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolPolicyType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.SmsConfigurationType] inside the given [block]
         */
        fun smsConfiguration(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.SmsConfigurationType.Builder.() -> kotlin.Unit) {
            this.smsConfiguration = aws.sdk.kotlin.services.cognitoidentityprovider.model.SmsConfigurationType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.UserAttributeUpdateSettingsType] inside the given [block]
         */
        fun userAttributeUpdateSettings(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserAttributeUpdateSettingsType.Builder.() -> kotlin.Unit) {
            this.userAttributeUpdateSettings = aws.sdk.kotlin.services.cognitoidentityprovider.model.UserAttributeUpdateSettingsType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolAddOnsType] inside the given [block]
         */
        fun userPoolAddOns(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolAddOnsType.Builder.() -> kotlin.Unit) {
            this.userPoolAddOns = aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolAddOnsType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.UsernameConfigurationType] inside the given [block]
         */
        fun usernameConfiguration(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.UsernameConfigurationType.Builder.() -> kotlin.Unit) {
            this.usernameConfiguration = aws.sdk.kotlin.services.cognitoidentityprovider.model.UsernameConfigurationType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.VerificationMessageTemplateType] inside the given [block]
         */
        fun verificationMessageTemplate(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.VerificationMessageTemplateType.Builder.() -> kotlin.Unit) {
            this.verificationMessageTemplate = aws.sdk.kotlin.services.cognitoidentityprovider.model.VerificationMessageTemplateType.invoke(block)
        }
    }
}
