// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model



class CreateUserPoolDomainRequest private constructor(builder: Builder) {
    /**
     * The configuration for a custom domain that hosts the sign-up and sign-in webpages for your application.
     *
     * Provide this parameter only if you want to use a custom domain for your user pool. Otherwise, you can exclude this parameter and use the Amazon Cognito hosted domain instead.
     *
     * For more information about the hosted domain and custom domains, see [Configuring a User Pool Domain](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-assign-domain.html).
     */
    val customDomainConfig: aws.sdk.kotlin.services.cognitoidentityprovider.model.CustomDomainConfigType? = builder.customDomainConfig
    /**
     * The domain string. For custom domains, this is the fully-qualified domain name, such as `auth.example.com`. For Amazon Cognito prefix domains, this is the prefix alone, such as `auth`.
     */
    val domain: kotlin.String? = builder.domain
    /**
     * The user pool ID.
     */
    val userPoolId: kotlin.String? = builder.userPoolId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateUserPoolDomainRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateUserPoolDomainRequest(")
        append("customDomainConfig=$customDomainConfig,")
        append("domain=$domain,")
        append("userPoolId=$userPoolId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = customDomainConfig?.hashCode() ?: 0
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (userPoolId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateUserPoolDomainRequest

        if (customDomainConfig != other.customDomainConfig) return false
        if (domain != other.domain) return false
        if (userPoolId != other.userPoolId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateUserPoolDomainRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The configuration for a custom domain that hosts the sign-up and sign-in webpages for your application.
         *
         * Provide this parameter only if you want to use a custom domain for your user pool. Otherwise, you can exclude this parameter and use the Amazon Cognito hosted domain instead.
         *
         * For more information about the hosted domain and custom domains, see [Configuring a User Pool Domain](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-assign-domain.html).
         */
        var customDomainConfig: aws.sdk.kotlin.services.cognitoidentityprovider.model.CustomDomainConfigType? = null
        /**
         * The domain string. For custom domains, this is the fully-qualified domain name, such as `auth.example.com`. For Amazon Cognito prefix domains, this is the prefix alone, such as `auth`.
         */
        var domain: kotlin.String? = null
        /**
         * The user pool ID.
         */
        var userPoolId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateUserPoolDomainRequest) : this() {
            this.customDomainConfig = x.customDomainConfig
            this.domain = x.domain
            this.userPoolId = x.userPoolId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateUserPoolDomainRequest = CreateUserPoolDomainRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.CustomDomainConfigType] inside the given [block]
         */
        fun customDomainConfig(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.CustomDomainConfigType.Builder.() -> kotlin.Unit) {
            this.customDomainConfig = aws.sdk.kotlin.services.cognitoidentityprovider.model.CustomDomainConfigType.invoke(block)
        }
    }
}
