// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model



class CreateIdentityProviderRequest private constructor(builder: Builder) {
    /**
     * A mapping of IdP attributes to standard and custom user pool attributes.
     */
    val attributeMapping: Map<String, String>? = builder.attributeMapping
    /**
     * A list of IdP identifiers.
     */
    val idpIdentifiers: List<String>? = builder.idpIdentifiers
    /**
     * The IdP details. The following list describes the provider detail keys for each IdP type.
     * + For Google and Login with Amazon:
     *    + client_id
     *    + client_secret
     *    + authorize_scopes
     * + For Facebook:
     *    + client_id
     *    + client_secret
     *    + authorize_scopes
     *    + api_version
     * + For Sign in with Apple:
     *    + client_id
     *    + team_id
     *    + key_id
     *    + private_key
     *    + authorize_scopes
     * + For OpenID Connect (OIDC) providers:
     *    + client_id
     *    + client_secret
     *    + attributes_request_method
     *    + oidc_issuer
     *    + authorize_scopes
     *    + The following keys are only present if Amazon Cognito didn't discover them at the `oidc_issuer` URL.
     *       + authorize_url
     *       + token_url
     *       + attributes_url
     *       + jwks_uri
     *    + Amazon Cognito sets the value of the following keys automatically. They are read-only.
     *       + attributes_url_add_attributes
     * + For SAML providers:
     *    + MetadataFile or MetadataURL
     *    + IDPSignout *optional*
     */
    val providerDetails: Map<String, String>? = builder.providerDetails
    /**
     * The IdP name.
     */
    val providerName: kotlin.String? = builder.providerName
    /**
     * The IdP type.
     */
    val providerType: aws.sdk.kotlin.services.cognitoidentityprovider.model.IdentityProviderTypeType? = builder.providerType
    /**
     * The user pool ID.
     */
    val userPoolId: kotlin.String? = builder.userPoolId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateIdentityProviderRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateIdentityProviderRequest(")
        append("attributeMapping=$attributeMapping,")
        append("idpIdentifiers=$idpIdentifiers,")
        append("providerDetails=$providerDetails,")
        append("providerName=$providerName,")
        append("providerType=$providerType,")
        append("userPoolId=$userPoolId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeMapping?.hashCode() ?: 0
        result = 31 * result + (idpIdentifiers?.hashCode() ?: 0)
        result = 31 * result + (providerDetails?.hashCode() ?: 0)
        result = 31 * result + (providerName?.hashCode() ?: 0)
        result = 31 * result + (providerType?.hashCode() ?: 0)
        result = 31 * result + (userPoolId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateIdentityProviderRequest

        if (attributeMapping != other.attributeMapping) return false
        if (idpIdentifiers != other.idpIdentifiers) return false
        if (providerDetails != other.providerDetails) return false
        if (providerName != other.providerName) return false
        if (providerType != other.providerType) return false
        if (userPoolId != other.userPoolId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateIdentityProviderRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A mapping of IdP attributes to standard and custom user pool attributes.
         */
        var attributeMapping: Map<String, String>? = null
        /**
         * A list of IdP identifiers.
         */
        var idpIdentifiers: List<String>? = null
        /**
         * The IdP details. The following list describes the provider detail keys for each IdP type.
         * + For Google and Login with Amazon:
         *    + client_id
         *    + client_secret
         *    + authorize_scopes
         * + For Facebook:
         *    + client_id
         *    + client_secret
         *    + authorize_scopes
         *    + api_version
         * + For Sign in with Apple:
         *    + client_id
         *    + team_id
         *    + key_id
         *    + private_key
         *    + authorize_scopes
         * + For OpenID Connect (OIDC) providers:
         *    + client_id
         *    + client_secret
         *    + attributes_request_method
         *    + oidc_issuer
         *    + authorize_scopes
         *    + The following keys are only present if Amazon Cognito didn't discover them at the `oidc_issuer` URL.
         *       + authorize_url
         *       + token_url
         *       + attributes_url
         *       + jwks_uri
         *    + Amazon Cognito sets the value of the following keys automatically. They are read-only.
         *       + attributes_url_add_attributes
         * + For SAML providers:
         *    + MetadataFile or MetadataURL
         *    + IDPSignout *optional*
         */
        var providerDetails: Map<String, String>? = null
        /**
         * The IdP name.
         */
        var providerName: kotlin.String? = null
        /**
         * The IdP type.
         */
        var providerType: aws.sdk.kotlin.services.cognitoidentityprovider.model.IdentityProviderTypeType? = null
        /**
         * The user pool ID.
         */
        var userPoolId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateIdentityProviderRequest) : this() {
            this.attributeMapping = x.attributeMapping
            this.idpIdentifiers = x.idpIdentifiers
            this.providerDetails = x.providerDetails
            this.providerName = x.providerName
            this.providerType = x.providerType
            this.userPoolId = x.userPoolId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateIdentityProviderRequest = CreateIdentityProviderRequest(this)
    }
}
