// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model



class CreateGroupRequest private constructor(builder: Builder) {
    /**
     * A string containing the description of the group.
     */
    val description: kotlin.String? = builder.description
    /**
     * The name of the group. Must be unique.
     */
    val groupName: kotlin.String? = builder.groupName
    /**
     * A non-negative integer value that specifies the precedence of this group relative to the other groups that a user can belong to in the user pool. Zero is the highest precedence value. Groups with lower `Precedence` values take precedence over groups with higher or null `Precedence` values. If a user belongs to two or more groups, it is the group with the lowest precedence value whose role ARN is given in the user's tokens for the `cognito:roles` and `cognito:preferred_role` claims.
     *
     * Two groups can have the same `Precedence` value. If this happens, neither group takes precedence over the other. If two groups with the same `Precedence` have the same role ARN, that role is used in the `cognito:preferred_role` claim in tokens for users in each group. If the two groups have different role ARNs, the `cognito:preferred_role` claim isn't set in users' tokens.
     *
     * The default `Precedence` value is null. The maximum `Precedence` value is `2^31-1`.
     */
    val precedence: kotlin.Int? = builder.precedence
    /**
     * The role Amazon Resource Name (ARN) for the group.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * The user pool ID for the user pool.
     */
    val userPoolId: kotlin.String? = builder.userPoolId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateGroupRequest(")
        append("description=$description,")
        append("groupName=$groupName,")
        append("precedence=$precedence,")
        append("roleArn=$roleArn,")
        append("userPoolId=$userPoolId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (groupName?.hashCode() ?: 0)
        result = 31 * result + (precedence ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (userPoolId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateGroupRequest

        if (description != other.description) return false
        if (groupName != other.groupName) return false
        if (precedence != other.precedence) return false
        if (roleArn != other.roleArn) return false
        if (userPoolId != other.userPoolId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateGroupRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A string containing the description of the group.
         */
        var description: kotlin.String? = null
        /**
         * The name of the group. Must be unique.
         */
        var groupName: kotlin.String? = null
        /**
         * A non-negative integer value that specifies the precedence of this group relative to the other groups that a user can belong to in the user pool. Zero is the highest precedence value. Groups with lower `Precedence` values take precedence over groups with higher or null `Precedence` values. If a user belongs to two or more groups, it is the group with the lowest precedence value whose role ARN is given in the user's tokens for the `cognito:roles` and `cognito:preferred_role` claims.
         *
         * Two groups can have the same `Precedence` value. If this happens, neither group takes precedence over the other. If two groups with the same `Precedence` have the same role ARN, that role is used in the `cognito:preferred_role` claim in tokens for users in each group. If the two groups have different role ARNs, the `cognito:preferred_role` claim isn't set in users' tokens.
         *
         * The default `Precedence` value is null. The maximum `Precedence` value is `2^31-1`.
         */
        var precedence: kotlin.Int? = null
        /**
         * The role Amazon Resource Name (ARN) for the group.
         */
        var roleArn: kotlin.String? = null
        /**
         * The user pool ID for the user pool.
         */
        var userPoolId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateGroupRequest) : this() {
            this.description = x.description
            this.groupName = x.groupName
            this.precedence = x.precedence
            this.roleArn = x.roleArn
            this.userPoolId = x.userPoolId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateGroupRequest = CreateGroupRequest(this)
    }
}
