// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model



/**
 * Contextual user data type used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.
 */
class ContextDataType private constructor(builder: Builder) {
    /**
     * Encoded device-fingerprint details that your app collected with the Amazon Cognito context data collection library. For more information, see [Adding user device and session data to API requests](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-adaptive-authentication.html#user-pool-settings-adaptive-authentication-device-fingerprint).
     */
    val encodedData: kotlin.String? = builder.encodedData
    /**
     * HttpHeaders received on your server in same order.
     */
    val httpHeaders: List<HttpHeader>? = builder.httpHeaders
    /**
     * The source IP address of your user's device.
     */
    val ipAddress: kotlin.String? = builder.ipAddress
    /**
     * Your server endpoint where this API is invoked.
     */
    val serverName: kotlin.String? = builder.serverName
    /**
     * Your server path where this API is invoked.
     */
    val serverPath: kotlin.String? = builder.serverPath

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.ContextDataType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContextDataType(")
        append("encodedData=$encodedData,")
        append("httpHeaders=$httpHeaders,")
        append("ipAddress=$ipAddress,")
        append("serverName=$serverName,")
        append("serverPath=$serverPath)")
    }

    override fun hashCode(): kotlin.Int {
        var result = encodedData?.hashCode() ?: 0
        result = 31 * result + (httpHeaders?.hashCode() ?: 0)
        result = 31 * result + (ipAddress?.hashCode() ?: 0)
        result = 31 * result + (serverName?.hashCode() ?: 0)
        result = 31 * result + (serverPath?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContextDataType

        if (encodedData != other.encodedData) return false
        if (httpHeaders != other.httpHeaders) return false
        if (ipAddress != other.ipAddress) return false
        if (serverName != other.serverName) return false
        if (serverPath != other.serverPath) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.ContextDataType = Builder(this).apply(block).build()

    class Builder {
        /**
         * Encoded device-fingerprint details that your app collected with the Amazon Cognito context data collection library. For more information, see [Adding user device and session data to API requests](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-adaptive-authentication.html#user-pool-settings-adaptive-authentication-device-fingerprint).
         */
        var encodedData: kotlin.String? = null
        /**
         * HttpHeaders received on your server in same order.
         */
        var httpHeaders: List<HttpHeader>? = null
        /**
         * The source IP address of your user's device.
         */
        var ipAddress: kotlin.String? = null
        /**
         * Your server endpoint where this API is invoked.
         */
        var serverName: kotlin.String? = null
        /**
         * Your server path where this API is invoked.
         */
        var serverPath: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.ContextDataType) : this() {
            this.encodedData = x.encodedData
            this.httpHeaders = x.httpHeaders
            this.ipAddress = x.ipAddress
            this.serverName = x.serverName
            this.serverPath = x.serverPath
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.ContextDataType = ContextDataType(this)
    }
}
