// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model



/**
 * Responds to the authentication challenge, as an administrator.
 */
class AdminRespondToAuthChallengeResponse private constructor(builder: Builder) {
    /**
     * The result returned by the server in response to the authentication request.
     */
    val authenticationResult: aws.sdk.kotlin.services.cognitoidentityprovider.model.AuthenticationResultType? = builder.authenticationResult
    /**
     * The name of the challenge. For more information, see [AdminInitiateAuth](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminInitiateAuth.html).
     */
    val challengeName: aws.sdk.kotlin.services.cognitoidentityprovider.model.ChallengeNameType? = builder.challengeName
    /**
     * The challenge parameters. For more information, see [AdminInitiateAuth](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminInitiateAuth.html).
     */
    val challengeParameters: Map<String, String>? = builder.challengeParameters
    /**
     * The session that should be passed both ways in challenge-response calls to the service. If the caller must pass another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next `RespondToAuthChallenge` API call.
     */
    val session: kotlin.String? = builder.session

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AdminRespondToAuthChallengeResponse(")
        append("authenticationResult=$authenticationResult,")
        append("challengeName=$challengeName,")
        append("challengeParameters=$challengeParameters,")
        append("session=$session)")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticationResult?.hashCode() ?: 0
        result = 31 * result + (challengeName?.hashCode() ?: 0)
        result = 31 * result + (challengeParameters?.hashCode() ?: 0)
        result = 31 * result + (session?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AdminRespondToAuthChallengeResponse

        if (authenticationResult != other.authenticationResult) return false
        if (challengeName != other.challengeName) return false
        if (challengeParameters != other.challengeParameters) return false
        if (session != other.session) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The result returned by the server in response to the authentication request.
         */
        var authenticationResult: aws.sdk.kotlin.services.cognitoidentityprovider.model.AuthenticationResultType? = null
        /**
         * The name of the challenge. For more information, see [AdminInitiateAuth](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminInitiateAuth.html).
         */
        var challengeName: aws.sdk.kotlin.services.cognitoidentityprovider.model.ChallengeNameType? = null
        /**
         * The challenge parameters. For more information, see [AdminInitiateAuth](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminInitiateAuth.html).
         */
        var challengeParameters: Map<String, String>? = null
        /**
         * The session that should be passed both ways in challenge-response calls to the service. If the caller must pass another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next `RespondToAuthChallenge` API call.
         */
        var session: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeResponse) : this() {
            this.authenticationResult = x.authenticationResult
            this.challengeName = x.challengeName
            this.challengeParameters = x.challengeParameters
            this.session = x.session
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeResponse = AdminRespondToAuthChallengeResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.AuthenticationResultType] inside the given [block]
         */
        fun authenticationResult(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.AuthenticationResultType.Builder.() -> kotlin.Unit) {
            this.authenticationResult = aws.sdk.kotlin.services.cognitoidentityprovider.model.AuthenticationResultType.invoke(block)
        }
    }
}
