// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model



/**
 * The request to respond to the authentication challenge, as an administrator.
 */
class AdminRespondToAuthChallengeRequest private constructor(builder: Builder) {
    /**
     * The analytics metadata for collecting Amazon Pinpoint metrics for `AdminRespondToAuthChallenge` calls.
     */
    val analyticsMetadata: aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsMetadataType? = builder.analyticsMetadata
    /**
     * The challenge name. For more information, see [AdminInitiateAuth](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminInitiateAuth.html).
     */
    val challengeName: aws.sdk.kotlin.services.cognitoidentityprovider.model.ChallengeNameType? = builder.challengeName
    /**
     * The challenge responses. These are inputs corresponding to the value of `ChallengeName`, for example:
     * + `SMS_MFA`: `SMS_MFA_CODE`, `USERNAME`, `SECRET_HASH` (if app client is configured with client secret).
     * + `PASSWORD_VERIFIER`: `PASSWORD_CLAIM_SIGNATURE`, `PASSWORD_CLAIM_SECRET_BLOCK`, `TIMESTAMP`, `USERNAME`, `SECRET_HASH` (if app client is configured with client secret).`PASSWORD_VERIFIER` requires `DEVICE_KEY` when signing in with a remembered device.
     * + `ADMIN_NO_SRP_AUTH`: `PASSWORD`, `USERNAME`, `SECRET_HASH` (if app client is configured with client secret).
     * + `NEW_PASSWORD_REQUIRED`: `NEW_PASSWORD`, `USERNAME`, `SECRET_HASH` (if app client is configured with client secret). To set any required attributes that Amazon Cognito returned as `requiredAttributes` in the `AdminInitiateAuth` response, add a `userAttributes.<i>attributename</i> ` parameter. This parameter can also set values for writable attributes that aren't required by your user pool.In a `NEW_PASSWORD_REQUIRED` challenge response, you can't modify a required attribute that already has a value. In `AdminRespondToAuthChallenge`, set a value for any keys that Amazon Cognito returned in the `requiredAttributes` parameter, then use the `AdminUpdateUserAttributes` API operation to modify the value of any additional attributes.
     * + `MFA_SETUP` requires `USERNAME`, plus you must use the session value returned by `VerifySoftwareToken` in the `Session` parameter.
     *
     * The value of the `USERNAME` attribute must be the user's actual username, not an alias (such as an email address or phone number). To make this simpler, the `AdminInitiateAuth` response includes the actual username value in the `USERNAMEUSER_ID_FOR_SRP` attribute. This happens even if you specified an alias in your call to `AdminInitiateAuth`.
     */
    val challengeResponses: Map<String, String>? = builder.challengeResponses
    /**
     * The app client ID.
     */
    val clientId: kotlin.String? = builder.clientId
    /**
     * A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.
     *
     * You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminRespondToAuthChallenge API action, Amazon Cognito invokes any functions that you have assigned to the following triggers:
     * + pre sign-up
     * + custom message
     * + post authentication
     * + user migration
     * + pre token generation
     * + define auth challenge
     * + create auth challenge
     * + verify auth challenge response
     *
     * When Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function receives as input. This payload contains a `clientMetadata` attribute that provides the data that you assigned to the ClientMetadata parameter in your AdminRespondToAuthChallenge request. In your function code in Lambda, you can process the `clientMetadata` value to enhance your workflow for your specific needs.
     *
     * For more information, see [ Customizing user pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html) in the *Amazon Cognito Developer Guide*.
     *
     * When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:
     * + Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.
     * + Validate the ClientMetadata value.
     * + Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.
     */
    val clientMetadata: Map<String, String>? = builder.clientMetadata
    /**
     * Contextual data about your user session, such as the device fingerprint, IP address, or location. Amazon Cognito advanced security evaluates the risk of an authentication event based on the context that your app generates and passes to Amazon Cognito when it makes API requests.
     */
    val contextData: aws.sdk.kotlin.services.cognitoidentityprovider.model.ContextDataType? = builder.contextData
    /**
     * The session that should be passed both ways in challenge-response calls to the service. If an `InitiateAuth` or `RespondToAuthChallenge` API call determines that the caller must pass another challenge, it returns a session with other challenge parameters. This session should be passed as it is to the next `RespondToAuthChallenge` API call.
     */
    val session: kotlin.String? = builder.session
    /**
     * The ID of the Amazon Cognito user pool.
     */
    val userPoolId: kotlin.String? = builder.userPoolId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AdminRespondToAuthChallengeRequest(")
        append("analyticsMetadata=$analyticsMetadata,")
        append("challengeName=$challengeName,")
        append("challengeResponses=$challengeResponses,")
        append("clientId=*** Sensitive Data Redacted ***,")
        append("clientMetadata=$clientMetadata,")
        append("contextData=$contextData,")
        append("session=$session,")
        append("userPoolId=$userPoolId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = analyticsMetadata?.hashCode() ?: 0
        result = 31 * result + (challengeName?.hashCode() ?: 0)
        result = 31 * result + (challengeResponses?.hashCode() ?: 0)
        result = 31 * result + (clientId?.hashCode() ?: 0)
        result = 31 * result + (clientMetadata?.hashCode() ?: 0)
        result = 31 * result + (contextData?.hashCode() ?: 0)
        result = 31 * result + (session?.hashCode() ?: 0)
        result = 31 * result + (userPoolId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AdminRespondToAuthChallengeRequest

        if (analyticsMetadata != other.analyticsMetadata) return false
        if (challengeName != other.challengeName) return false
        if (challengeResponses != other.challengeResponses) return false
        if (clientId != other.clientId) return false
        if (clientMetadata != other.clientMetadata) return false
        if (contextData != other.contextData) return false
        if (session != other.session) return false
        if (userPoolId != other.userPoolId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The analytics metadata for collecting Amazon Pinpoint metrics for `AdminRespondToAuthChallenge` calls.
         */
        var analyticsMetadata: aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsMetadataType? = null
        /**
         * The challenge name. For more information, see [AdminInitiateAuth](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminInitiateAuth.html).
         */
        var challengeName: aws.sdk.kotlin.services.cognitoidentityprovider.model.ChallengeNameType? = null
        /**
         * The challenge responses. These are inputs corresponding to the value of `ChallengeName`, for example:
         * + `SMS_MFA`: `SMS_MFA_CODE`, `USERNAME`, `SECRET_HASH` (if app client is configured with client secret).
         * + `PASSWORD_VERIFIER`: `PASSWORD_CLAIM_SIGNATURE`, `PASSWORD_CLAIM_SECRET_BLOCK`, `TIMESTAMP`, `USERNAME`, `SECRET_HASH` (if app client is configured with client secret).`PASSWORD_VERIFIER` requires `DEVICE_KEY` when signing in with a remembered device.
         * + `ADMIN_NO_SRP_AUTH`: `PASSWORD`, `USERNAME`, `SECRET_HASH` (if app client is configured with client secret).
         * + `NEW_PASSWORD_REQUIRED`: `NEW_PASSWORD`, `USERNAME`, `SECRET_HASH` (if app client is configured with client secret). To set any required attributes that Amazon Cognito returned as `requiredAttributes` in the `AdminInitiateAuth` response, add a `userAttributes.<i>attributename</i> ` parameter. This parameter can also set values for writable attributes that aren't required by your user pool.In a `NEW_PASSWORD_REQUIRED` challenge response, you can't modify a required attribute that already has a value. In `AdminRespondToAuthChallenge`, set a value for any keys that Amazon Cognito returned in the `requiredAttributes` parameter, then use the `AdminUpdateUserAttributes` API operation to modify the value of any additional attributes.
         * + `MFA_SETUP` requires `USERNAME`, plus you must use the session value returned by `VerifySoftwareToken` in the `Session` parameter.
         *
         * The value of the `USERNAME` attribute must be the user's actual username, not an alias (such as an email address or phone number). To make this simpler, the `AdminInitiateAuth` response includes the actual username value in the `USERNAMEUSER_ID_FOR_SRP` attribute. This happens even if you specified an alias in your call to `AdminInitiateAuth`.
         */
        var challengeResponses: Map<String, String>? = null
        /**
         * The app client ID.
         */
        var clientId: kotlin.String? = null
        /**
         * A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.
         *
         * You create custom workflows by assigning Lambda functions to user pool triggers. When you use the AdminRespondToAuthChallenge API action, Amazon Cognito invokes any functions that you have assigned to the following triggers:
         * + pre sign-up
         * + custom message
         * + post authentication
         * + user migration
         * + pre token generation
         * + define auth challenge
         * + create auth challenge
         * + verify auth challenge response
         *
         * When Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function receives as input. This payload contains a `clientMetadata` attribute that provides the data that you assigned to the ClientMetadata parameter in your AdminRespondToAuthChallenge request. In your function code in Lambda, you can process the `clientMetadata` value to enhance your workflow for your specific needs.
         *
         * For more information, see [ Customizing user pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html) in the *Amazon Cognito Developer Guide*.
         *
         * When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:
         * + Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.
         * + Validate the ClientMetadata value.
         * + Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.
         */
        var clientMetadata: Map<String, String>? = null
        /**
         * Contextual data about your user session, such as the device fingerprint, IP address, or location. Amazon Cognito advanced security evaluates the risk of an authentication event based on the context that your app generates and passes to Amazon Cognito when it makes API requests.
         */
        var contextData: aws.sdk.kotlin.services.cognitoidentityprovider.model.ContextDataType? = null
        /**
         * The session that should be passed both ways in challenge-response calls to the service. If an `InitiateAuth` or `RespondToAuthChallenge` API call determines that the caller must pass another challenge, it returns a session with other challenge parameters. This session should be passed as it is to the next `RespondToAuthChallenge` API call.
         */
        var session: kotlin.String? = null
        /**
         * The ID of the Amazon Cognito user pool.
         */
        var userPoolId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeRequest) : this() {
            this.analyticsMetadata = x.analyticsMetadata
            this.challengeName = x.challengeName
            this.challengeResponses = x.challengeResponses
            this.clientId = x.clientId
            this.clientMetadata = x.clientMetadata
            this.contextData = x.contextData
            this.session = x.session
            this.userPoolId = x.userPoolId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeRequest = AdminRespondToAuthChallengeRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsMetadataType] inside the given [block]
         */
        fun analyticsMetadata(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsMetadataType.Builder.() -> kotlin.Unit) {
            this.analyticsMetadata = aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsMetadataType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.ContextDataType] inside the given [block]
         */
        fun contextData(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.ContextDataType.Builder.() -> kotlin.Unit) {
            this.contextData = aws.sdk.kotlin.services.cognitoidentityprovider.model.ContextDataType.invoke(block)
        }
    }
}
