// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.cognitoidentityprovider.model.*
import aws.sdk.kotlin.services.cognitoidentityprovider.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "Cognito Identity Provider"
const val ServiceApiVersion: String = "2016-04-18"
const val SdkVersion: String = "0.16.5-beta"

internal class DefaultCognitoIdentityProviderClient(override val config: CognitoIdentityProviderClient.Config) : CognitoIdentityProviderClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Adds additional user attributes to the user pool schema.
     */
    override suspend fun addCustomAttributes(input: AddCustomAttributesRequest): AddCustomAttributesResponse {
        val op = SdkHttpOperation.build<AddCustomAttributesRequest, AddCustomAttributesResponse> {
            serializer = AddCustomAttributesOperationSerializer()
            deserializer = AddCustomAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddCustomAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds the specified user to the specified group.
     *
     * Calling this action requires developer credentials.
     */
    override suspend fun adminAddUserToGroup(input: AdminAddUserToGroupRequest): AdminAddUserToGroupResponse {
        val op = SdkHttpOperation.build<AdminAddUserToGroupRequest, AdminAddUserToGroupResponse> {
            serializer = AdminAddUserToGroupOperationSerializer()
            deserializer = AdminAddUserToGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AdminAddUserToGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Confirms user registration as an admin without using a confirmation code. Works on any user.
     *
     * Calling this action requires developer credentials.
     */
    override suspend fun adminConfirmSignUp(input: AdminConfirmSignUpRequest): AdminConfirmSignUpResponse {
        val op = SdkHttpOperation.build<AdminConfirmSignUpRequest, AdminConfirmSignUpResponse> {
            serializer = AdminConfirmSignUpOperationSerializer()
            deserializer = AdminConfirmSignUpOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AdminConfirmSignUp"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new user in the specified user pool.
     *
     * If `MessageAction` isn't set, the default is to send a welcome message via email or phone (SMS).
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     *
     * This message is based on a template that you configured in your call to create or update a user pool. This template includes your custom sign-up instructions and placeholders for user name and temporary password.
     *
     * Alternatively, you can call `AdminCreateUser` with `SUPPRESS` for the `MessageAction` parameter, and Amazon Cognito won't send any email.
     *
     * In either case, the user will be in the `FORCE_CHANGE_PASSWORD` state until they sign in and change their password.
     *
     * `AdminCreateUser` requires developer credentials.
     */
    override suspend fun adminCreateUser(input: AdminCreateUserRequest): AdminCreateUserResponse {
        val op = SdkHttpOperation.build<AdminCreateUserRequest, AdminCreateUserResponse> {
            serializer = AdminCreateUserOperationSerializer()
            deserializer = AdminCreateUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AdminCreateUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a user as an administrator. Works on any user.
     *
     * Calling this action requires developer credentials.
     */
    override suspend fun adminDeleteUser(input: AdminDeleteUserRequest): AdminDeleteUserResponse {
        val op = SdkHttpOperation.build<AdminDeleteUserRequest, AdminDeleteUserResponse> {
            serializer = AdminDeleteUserOperationSerializer()
            deserializer = AdminDeleteUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AdminDeleteUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the user attributes in a user pool as an administrator. Works on any user.
     *
     * Calling this action requires developer credentials.
     */
    override suspend fun adminDeleteUserAttributes(input: AdminDeleteUserAttributesRequest): AdminDeleteUserAttributesResponse {
        val op = SdkHttpOperation.build<AdminDeleteUserAttributesRequest, AdminDeleteUserAttributesResponse> {
            serializer = AdminDeleteUserAttributesOperationSerializer()
            deserializer = AdminDeleteUserAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AdminDeleteUserAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Prevents the user from signing in with the specified external (SAML or social) identity provider (IdP). If the user that you want to deactivate is a Amazon Cognito user pools native username + password user, they can't use their password to sign in. If the user to deactivate is a linked external IdP user, any link between that user and an existing user is removed. When the external user signs in again, and the user is no longer attached to the previously linked `DestinationUser`, the user must create a new user account. See [AdminLinkProviderForUser](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminLinkProviderForUser.html).
     *
     * This action is enabled only for admin access and requires developer credentials.
     *
     * The `ProviderName` must match the value specified when creating an IdP for the pool.
     *
     * To deactivate a native username + password user, the `ProviderName` value must be `Cognito` and the `ProviderAttributeName` must be `Cognito_Subject`. The `ProviderAttributeValue` must be the name that is used in the user pool for the user.
     *
     * The `ProviderAttributeName` must always be `Cognito_Subject` for social IdPs. The `ProviderAttributeValue` must always be the exact subject that was used when the user was originally linked as a source user.
     *
     * For de-linking a SAML identity, there are two scenarios. If the linked identity has not yet been used to sign in, the `ProviderAttributeName` and `ProviderAttributeValue` must be the same values that were used for the `SourceUser` when the identities were originally linked using ` AdminLinkProviderForUser` call. (If the linking was done with `ProviderAttributeName` set to `Cognito_Subject`, the same applies here). However, if the user has already signed in, the `ProviderAttributeName` must be `Cognito_Subject` and `ProviderAttributeValue` must be the subject of the SAML assertion.
     */
    override suspend fun adminDisableProviderForUser(input: AdminDisableProviderForUserRequest): AdminDisableProviderForUserResponse {
        val op = SdkHttpOperation.build<AdminDisableProviderForUserRequest, AdminDisableProviderForUserResponse> {
            serializer = AdminDisableProviderForUserOperationSerializer()
            deserializer = AdminDisableProviderForUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AdminDisableProviderForUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disables the specified user.
     *
     * Calling this action requires developer credentials.
     */
    override suspend fun adminDisableUser(input: AdminDisableUserRequest): AdminDisableUserResponse {
        val op = SdkHttpOperation.build<AdminDisableUserRequest, AdminDisableUserResponse> {
            serializer = AdminDisableUserOperationSerializer()
            deserializer = AdminDisableUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AdminDisableUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enables the specified user as an administrator. Works on any user.
     *
     * Calling this action requires developer credentials.
     */
    override suspend fun adminEnableUser(input: AdminEnableUserRequest): AdminEnableUserResponse {
        val op = SdkHttpOperation.build<AdminEnableUserRequest, AdminEnableUserResponse> {
            serializer = AdminEnableUserOperationSerializer()
            deserializer = AdminEnableUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AdminEnableUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Forgets the device, as an administrator.
     *
     * Calling this action requires developer credentials.
     */
    override suspend fun adminForgetDevice(input: AdminForgetDeviceRequest): AdminForgetDeviceResponse {
        val op = SdkHttpOperation.build<AdminForgetDeviceRequest, AdminForgetDeviceResponse> {
            serializer = AdminForgetDeviceOperationSerializer()
            deserializer = AdminForgetDeviceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AdminForgetDevice"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the device, as an administrator.
     *
     * Calling this action requires developer credentials.
     */
    override suspend fun adminGetDevice(input: AdminGetDeviceRequest): AdminGetDeviceResponse {
        val op = SdkHttpOperation.build<AdminGetDeviceRequest, AdminGetDeviceResponse> {
            serializer = AdminGetDeviceOperationSerializer()
            deserializer = AdminGetDeviceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AdminGetDevice"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the specified user by user name in a user pool as an administrator. Works on any user.
     *
     * Calling this action requires developer credentials.
     */
    override suspend fun adminGetUser(input: AdminGetUserRequest): AdminGetUserResponse {
        val op = SdkHttpOperation.build<AdminGetUserRequest, AdminGetUserResponse> {
            serializer = AdminGetUserOperationSerializer()
            deserializer = AdminGetUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AdminGetUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Initiates the authentication flow, as an administrator.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     *
     * Calling this action requires developer credentials.
     */
    override suspend fun adminInitiateAuth(input: AdminInitiateAuthRequest): AdminInitiateAuthResponse {
        val op = SdkHttpOperation.build<AdminInitiateAuthRequest, AdminInitiateAuthResponse> {
            serializer = AdminInitiateAuthOperationSerializer()
            deserializer = AdminInitiateAuthOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AdminInitiateAuth"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Links an existing user account in a user pool (`DestinationUser`) to an identity from an external IdP (`SourceUser`) based on a specified attribute name and value from the external IdP. This allows you to create a link from the existing user account to an external federated user identity that has not yet been used to sign in. You can then use the federated user identity to sign in as the existing user account.
     *
     *  For example, if there is an existing user with a username and password, this API links that user to a federated user identity. When the user signs in with a federated user identity, they sign in as the existing user account.
     *
     * The maximum number of federated identities linked to a user is five.
     *
     * Because this API allows a user with an external federated identity to sign in as an existing user in the user pool, it is critical that it only be used with external IdPs and provider attributes that have been trusted by the application owner.
     *
     * This action is administrative and requires developer credentials.
     */
    override suspend fun adminLinkProviderForUser(input: AdminLinkProviderForUserRequest): AdminLinkProviderForUserResponse {
        val op = SdkHttpOperation.build<AdminLinkProviderForUserRequest, AdminLinkProviderForUserResponse> {
            serializer = AdminLinkProviderForUserOperationSerializer()
            deserializer = AdminLinkProviderForUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AdminLinkProviderForUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists devices, as an administrator.
     *
     * Calling this action requires developer credentials.
     */
    override suspend fun adminListDevices(input: AdminListDevicesRequest): AdminListDevicesResponse {
        val op = SdkHttpOperation.build<AdminListDevicesRequest, AdminListDevicesResponse> {
            serializer = AdminListDevicesOperationSerializer()
            deserializer = AdminListDevicesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AdminListDevices"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the groups that the user belongs to.
     *
     * Calling this action requires developer credentials.
     */
    override suspend fun adminListGroupsForUser(input: AdminListGroupsForUserRequest): AdminListGroupsForUserResponse {
        val op = SdkHttpOperation.build<AdminListGroupsForUserRequest, AdminListGroupsForUserResponse> {
            serializer = AdminListGroupsForUserOperationSerializer()
            deserializer = AdminListGroupsForUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AdminListGroupsForUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * A history of user activity and any risks detected as part of Amazon Cognito advanced security.
     */
    override suspend fun adminListUserAuthEvents(input: AdminListUserAuthEventsRequest): AdminListUserAuthEventsResponse {
        val op = SdkHttpOperation.build<AdminListUserAuthEventsRequest, AdminListUserAuthEventsResponse> {
            serializer = AdminListUserAuthEventsOperationSerializer()
            deserializer = AdminListUserAuthEventsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AdminListUserAuthEvents"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified user from the specified group.
     *
     * Calling this action requires developer credentials.
     */
    override suspend fun adminRemoveUserFromGroup(input: AdminRemoveUserFromGroupRequest): AdminRemoveUserFromGroupResponse {
        val op = SdkHttpOperation.build<AdminRemoveUserFromGroupRequest, AdminRemoveUserFromGroupResponse> {
            serializer = AdminRemoveUserFromGroupOperationSerializer()
            deserializer = AdminRemoveUserFromGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AdminRemoveUserFromGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Resets the specified user's password in a user pool as an administrator. Works on any user.
     *
     * When a developer calls this API, the current password is invalidated, so it must be changed. If a user tries to sign in after the API is called, the app will get a PasswordResetRequiredException exception back and should direct the user down the flow to reset the password, which is the same as the forgot password flow. In addition, if the user pool has phone verification selected and a verified phone number exists for the user, or if email verification is selected and a verified email exists for the user, calling this API will also result in sending a message to the end user with the code to change their password.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     *
     * Calling this action requires developer credentials.
     */
    override suspend fun adminResetUserPassword(input: AdminResetUserPasswordRequest): AdminResetUserPasswordResponse {
        val op = SdkHttpOperation.build<AdminResetUserPasswordRequest, AdminResetUserPasswordResponse> {
            serializer = AdminResetUserPasswordOperationSerializer()
            deserializer = AdminResetUserPasswordOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AdminResetUserPassword"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Responds to an authentication challenge, as an administrator.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     *
     * Calling this action requires developer credentials.
     */
    override suspend fun adminRespondToAuthChallenge(input: AdminRespondToAuthChallengeRequest): AdminRespondToAuthChallengeResponse {
        val op = SdkHttpOperation.build<AdminRespondToAuthChallengeRequest, AdminRespondToAuthChallengeResponse> {
            serializer = AdminRespondToAuthChallengeOperationSerializer()
            deserializer = AdminRespondToAuthChallengeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AdminRespondToAuthChallenge"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The user's multi-factor authentication (MFA) preference, including which MFA options are activated, and if any are preferred. Only one factor can be set as preferred. The preferred MFA factor will be used to authenticate a user if multiple factors are activated. If multiple options are activated and no preference is set, a challenge to choose an MFA option will be returned during sign-in.
     */
    override suspend fun adminSetUserMfaPreference(input: AdminSetUserMfaPreferenceRequest): AdminSetUserMfaPreferenceResponse {
        val op = SdkHttpOperation.build<AdminSetUserMfaPreferenceRequest, AdminSetUserMfaPreferenceResponse> {
            serializer = AdminSetUserMFAPreferenceOperationSerializer()
            deserializer = AdminSetUserMFAPreferenceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AdminSetUserMFAPreference"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sets the specified user's password in a user pool as an administrator. Works on any user.
     *
     * The password can be temporary or permanent. If it is temporary, the user status enters the `FORCE_CHANGE_PASSWORD` state. When the user next tries to sign in, the InitiateAuth/AdminInitiateAuth response will contain the `NEW_PASSWORD_REQUIRED` challenge. If the user doesn't sign in before it expires, the user won't be able to sign in, and an administrator must reset their password.
     *
     * Once the user has set a new password, or the password is permanent, the user status is set to `Confirmed`.
     */
    override suspend fun adminSetUserPassword(input: AdminSetUserPasswordRequest): AdminSetUserPasswordResponse {
        val op = SdkHttpOperation.build<AdminSetUserPasswordRequest, AdminSetUserPasswordResponse> {
            serializer = AdminSetUserPasswordOperationSerializer()
            deserializer = AdminSetUserPasswordOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AdminSetUserPassword"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * *This action is no longer supported.* You can use it to configure only SMS MFA. You can't use it to configure time-based one-time password (TOTP) software token MFA. To configure either type of MFA, use [AdminSetUserMFAPreference](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminSetUserMFAPreference.html) instead.
     */
    override suspend fun adminSetUserSettings(input: AdminSetUserSettingsRequest): AdminSetUserSettingsResponse {
        val op = SdkHttpOperation.build<AdminSetUserSettingsRequest, AdminSetUserSettingsResponse> {
            serializer = AdminSetUserSettingsOperationSerializer()
            deserializer = AdminSetUserSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AdminSetUserSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides feedback for an authentication event indicating if it was from a valid user. This feedback is used for improving the risk evaluation decision for the user pool as part of Amazon Cognito advanced security.
     */
    override suspend fun adminUpdateAuthEventFeedback(input: AdminUpdateAuthEventFeedbackRequest): AdminUpdateAuthEventFeedbackResponse {
        val op = SdkHttpOperation.build<AdminUpdateAuthEventFeedbackRequest, AdminUpdateAuthEventFeedbackResponse> {
            serializer = AdminUpdateAuthEventFeedbackOperationSerializer()
            deserializer = AdminUpdateAuthEventFeedbackOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AdminUpdateAuthEventFeedback"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the device status as an administrator.
     *
     * Calling this action requires developer credentials.
     */
    override suspend fun adminUpdateDeviceStatus(input: AdminUpdateDeviceStatusRequest): AdminUpdateDeviceStatusResponse {
        val op = SdkHttpOperation.build<AdminUpdateDeviceStatusRequest, AdminUpdateDeviceStatusResponse> {
            serializer = AdminUpdateDeviceStatusOperationSerializer()
            deserializer = AdminUpdateDeviceStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AdminUpdateDeviceStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified user's attributes, including developer attributes, as an administrator. Works on any user.
     *
     * For custom attributes, you must prepend the `custom:` prefix to the attribute name.
     *
     * In addition to updating user attributes, this API can also be used to mark phone and email as verified.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     *
     * Calling this action requires developer credentials.
     */
    override suspend fun adminUpdateUserAttributes(input: AdminUpdateUserAttributesRequest): AdminUpdateUserAttributesResponse {
        val op = SdkHttpOperation.build<AdminUpdateUserAttributesRequest, AdminUpdateUserAttributesResponse> {
            serializer = AdminUpdateUserAttributesOperationSerializer()
            deserializer = AdminUpdateUserAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AdminUpdateUserAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Signs out a user from all devices. You must sign `AdminUserGlobalSignOut` requests with Amazon Web Services credentials. It also invalidates all refresh tokens that Amazon Cognito has issued to a user. The user's current access and ID tokens remain valid until they expire. By default, access and ID tokens expire one hour after they're issued. A user can still use a hosted UI cookie to retrieve new tokens for the duration of the cookie validity period of 1 hour.
     *
     * Calling this action requires developer credentials.
     */
    override suspend fun adminUserGlobalSignOut(input: AdminUserGlobalSignOutRequest): AdminUserGlobalSignOutResponse {
        val op = SdkHttpOperation.build<AdminUserGlobalSignOutRequest, AdminUserGlobalSignOutResponse> {
            serializer = AdminUserGlobalSignOutOperationSerializer()
            deserializer = AdminUserGlobalSignOutOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AdminUserGlobalSignOut"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Begins setup of time-based one-time password multi-factor authentication (TOTP MFA) for a user, with a unique private key that Amazon Cognito generates and returns in the API response. You can authorize an `AssociateSoftwareToken` request with either the user's access token, or a session string from a challenge response that you received from Amazon Cognito.
     *
     * Amazon Cognito disassociates an existing software token when you verify the new token in a [ VerifySoftwareToken](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerifySoftwareToken.html) API request. If you don't verify the software token and your user pool doesn't require MFA, the user can then authenticate with user name and password credentials alone. If your user pool requires TOTP MFA, Amazon Cognito generates an `MFA_SETUP` or `SOFTWARE_TOKEN_SETUP` challenge each time your user signs. Complete setup with `AssociateSoftwareToken` and `VerifySoftwareToken`.
     *
     * After you set up software token MFA for your user, Amazon Cognito generates a `SOFTWARE_TOKEN_MFA` challenge when they authenticate. Respond to this challenge with your user's TOTP.
     */
    override suspend fun associateSoftwareToken(input: AssociateSoftwareTokenRequest): AssociateSoftwareTokenResponse {
        val op = SdkHttpOperation.build<AssociateSoftwareTokenRequest, AssociateSoftwareTokenResponse> {
            serializer = AssociateSoftwareTokenOperationSerializer()
            deserializer = AssociateSoftwareTokenOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateSoftwareToken"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Changes the password for a specified user in a user pool.
     */
    override suspend fun changePassword(input: ChangePasswordRequest): ChangePasswordResponse {
        val op = SdkHttpOperation.build<ChangePasswordRequest, ChangePasswordResponse> {
            serializer = ChangePasswordOperationSerializer()
            deserializer = ChangePasswordOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ChangePassword"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        return op.roundTrip(client, input)
    }

    /**
     * Confirms tracking of the device. This API call is the call that begins device tracking.
     */
    override suspend fun confirmDevice(input: ConfirmDeviceRequest): ConfirmDeviceResponse {
        val op = SdkHttpOperation.build<ConfirmDeviceRequest, ConfirmDeviceResponse> {
            serializer = ConfirmDeviceOperationSerializer()
            deserializer = ConfirmDeviceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ConfirmDevice"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        return op.roundTrip(client, input)
    }

    /**
     * Allows a user to enter a confirmation code to reset a forgotten password.
     */
    override suspend fun confirmForgotPassword(input: ConfirmForgotPasswordRequest): ConfirmForgotPasswordResponse {
        val op = SdkHttpOperation.build<ConfirmForgotPasswordRequest, ConfirmForgotPasswordResponse> {
            serializer = ConfirmForgotPasswordOperationSerializer()
            deserializer = ConfirmForgotPasswordOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ConfirmForgotPassword"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        return op.roundTrip(client, input)
    }

    /**
     * Confirms registration of a new user.
     */
    override suspend fun confirmSignUp(input: ConfirmSignUpRequest): ConfirmSignUpResponse {
        val op = SdkHttpOperation.build<ConfirmSignUpRequest, ConfirmSignUpResponse> {
            serializer = ConfirmSignUpOperationSerializer()
            deserializer = ConfirmSignUpOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ConfirmSignUp"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new group in the specified user pool.
     *
     * Calling this action requires developer credentials.
     */
    override suspend fun createGroup(input: CreateGroupRequest): CreateGroupResponse {
        val op = SdkHttpOperation.build<CreateGroupRequest, CreateGroupResponse> {
            serializer = CreateGroupOperationSerializer()
            deserializer = CreateGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an IdP for a user pool.
     */
    override suspend fun createIdentityProvider(input: CreateIdentityProviderRequest): CreateIdentityProviderResponse {
        val op = SdkHttpOperation.build<CreateIdentityProviderRequest, CreateIdentityProviderResponse> {
            serializer = CreateIdentityProviderOperationSerializer()
            deserializer = CreateIdentityProviderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateIdentityProvider"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new OAuth2.0 resource server and defines custom scopes within it.
     */
    override suspend fun createResourceServer(input: CreateResourceServerRequest): CreateResourceServerResponse {
        val op = SdkHttpOperation.build<CreateResourceServerRequest, CreateResourceServerResponse> {
            serializer = CreateResourceServerOperationSerializer()
            deserializer = CreateResourceServerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateResourceServer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates the user import job.
     */
    override suspend fun createUserImportJob(input: CreateUserImportJobRequest): CreateUserImportJobResponse {
        val op = SdkHttpOperation.build<CreateUserImportJobRequest, CreateUserImportJobResponse> {
            serializer = CreateUserImportJobOperationSerializer()
            deserializer = CreateUserImportJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateUserImportJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new Amazon Cognito user pool and sets the password policy for the pool.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    override suspend fun createUserPool(input: CreateUserPoolRequest): CreateUserPoolResponse {
        val op = SdkHttpOperation.build<CreateUserPoolRequest, CreateUserPoolResponse> {
            serializer = CreateUserPoolOperationSerializer()
            deserializer = CreateUserPoolOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateUserPool"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates the user pool client.
     *
     * When you create a new user pool client, token revocation is automatically activated. For more information about revoking tokens, see [RevokeToken](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html).
     */
    override suspend fun createUserPoolClient(input: CreateUserPoolClientRequest): CreateUserPoolClientResponse {
        val op = SdkHttpOperation.build<CreateUserPoolClientRequest, CreateUserPoolClientResponse> {
            serializer = CreateUserPoolClientOperationSerializer()
            deserializer = CreateUserPoolClientOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateUserPoolClient"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new domain for a user pool.
     */
    override suspend fun createUserPoolDomain(input: CreateUserPoolDomainRequest): CreateUserPoolDomainResponse {
        val op = SdkHttpOperation.build<CreateUserPoolDomainRequest, CreateUserPoolDomainResponse> {
            serializer = CreateUserPoolDomainOperationSerializer()
            deserializer = CreateUserPoolDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateUserPoolDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a group.
     *
     * Calling this action requires developer credentials.
     */
    override suspend fun deleteGroup(input: DeleteGroupRequest): DeleteGroupResponse {
        val op = SdkHttpOperation.build<DeleteGroupRequest, DeleteGroupResponse> {
            serializer = DeleteGroupOperationSerializer()
            deserializer = DeleteGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an IdP for a user pool.
     */
    override suspend fun deleteIdentityProvider(input: DeleteIdentityProviderRequest): DeleteIdentityProviderResponse {
        val op = SdkHttpOperation.build<DeleteIdentityProviderRequest, DeleteIdentityProviderResponse> {
            serializer = DeleteIdentityProviderOperationSerializer()
            deserializer = DeleteIdentityProviderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteIdentityProvider"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a resource server.
     */
    override suspend fun deleteResourceServer(input: DeleteResourceServerRequest): DeleteResourceServerResponse {
        val op = SdkHttpOperation.build<DeleteResourceServerRequest, DeleteResourceServerResponse> {
            serializer = DeleteResourceServerOperationSerializer()
            deserializer = DeleteResourceServerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteResourceServer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Allows a user to delete himself or herself.
     */
    override suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse {
        val op = SdkHttpOperation.build<DeleteUserRequest, DeleteUserResponse> {
            serializer = DeleteUserOperationSerializer()
            deserializer = DeleteUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the attributes for a user.
     */
    override suspend fun deleteUserAttributes(input: DeleteUserAttributesRequest): DeleteUserAttributesResponse {
        val op = SdkHttpOperation.build<DeleteUserAttributesRequest, DeleteUserAttributesResponse> {
            serializer = DeleteUserAttributesOperationSerializer()
            deserializer = DeleteUserAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteUserAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified Amazon Cognito user pool.
     */
    override suspend fun deleteUserPool(input: DeleteUserPoolRequest): DeleteUserPoolResponse {
        val op = SdkHttpOperation.build<DeleteUserPoolRequest, DeleteUserPoolResponse> {
            serializer = DeleteUserPoolOperationSerializer()
            deserializer = DeleteUserPoolOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteUserPool"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Allows the developer to delete the user pool client.
     */
    override suspend fun deleteUserPoolClient(input: DeleteUserPoolClientRequest): DeleteUserPoolClientResponse {
        val op = SdkHttpOperation.build<DeleteUserPoolClientRequest, DeleteUserPoolClientResponse> {
            serializer = DeleteUserPoolClientOperationSerializer()
            deserializer = DeleteUserPoolClientOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteUserPoolClient"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a domain for a user pool.
     */
    override suspend fun deleteUserPoolDomain(input: DeleteUserPoolDomainRequest): DeleteUserPoolDomainResponse {
        val op = SdkHttpOperation.build<DeleteUserPoolDomainRequest, DeleteUserPoolDomainResponse> {
            serializer = DeleteUserPoolDomainOperationSerializer()
            deserializer = DeleteUserPoolDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteUserPoolDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a specific IdP.
     */
    override suspend fun describeIdentityProvider(input: DescribeIdentityProviderRequest): DescribeIdentityProviderResponse {
        val op = SdkHttpOperation.build<DescribeIdentityProviderRequest, DescribeIdentityProviderResponse> {
            serializer = DescribeIdentityProviderOperationSerializer()
            deserializer = DescribeIdentityProviderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeIdentityProvider"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a resource server.
     */
    override suspend fun describeResourceServer(input: DescribeResourceServerRequest): DescribeResourceServerResponse {
        val op = SdkHttpOperation.build<DescribeResourceServerRequest, DescribeResourceServerResponse> {
            serializer = DescribeResourceServerOperationSerializer()
            deserializer = DescribeResourceServerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeResourceServer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the risk configuration.
     */
    override suspend fun describeRiskConfiguration(input: DescribeRiskConfigurationRequest): DescribeRiskConfigurationResponse {
        val op = SdkHttpOperation.build<DescribeRiskConfigurationRequest, DescribeRiskConfigurationResponse> {
            serializer = DescribeRiskConfigurationOperationSerializer()
            deserializer = DescribeRiskConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeRiskConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the user import job.
     */
    override suspend fun describeUserImportJob(input: DescribeUserImportJobRequest): DescribeUserImportJobResponse {
        val op = SdkHttpOperation.build<DescribeUserImportJobRequest, DescribeUserImportJobResponse> {
            serializer = DescribeUserImportJobOperationSerializer()
            deserializer = DescribeUserImportJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeUserImportJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the configuration information and metadata of the specified user pool.
     */
    override suspend fun describeUserPool(input: DescribeUserPoolRequest): DescribeUserPoolResponse {
        val op = SdkHttpOperation.build<DescribeUserPoolRequest, DescribeUserPoolResponse> {
            serializer = DescribeUserPoolOperationSerializer()
            deserializer = DescribeUserPoolOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeUserPool"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Client method for returning the configuration information and metadata of the specified user pool app client.
     */
    override suspend fun describeUserPoolClient(input: DescribeUserPoolClientRequest): DescribeUserPoolClientResponse {
        val op = SdkHttpOperation.build<DescribeUserPoolClientRequest, DescribeUserPoolClientResponse> {
            serializer = DescribeUserPoolClientOperationSerializer()
            deserializer = DescribeUserPoolClientOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeUserPoolClient"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a domain.
     */
    override suspend fun describeUserPoolDomain(input: DescribeUserPoolDomainRequest): DescribeUserPoolDomainResponse {
        val op = SdkHttpOperation.build<DescribeUserPoolDomainRequest, DescribeUserPoolDomainResponse> {
            serializer = DescribeUserPoolDomainOperationSerializer()
            deserializer = DescribeUserPoolDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeUserPoolDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Forgets the specified device.
     */
    override suspend fun forgetDevice(input: ForgetDeviceRequest): ForgetDeviceResponse {
        val op = SdkHttpOperation.build<ForgetDeviceRequest, ForgetDeviceResponse> {
            serializer = ForgetDeviceOperationSerializer()
            deserializer = ForgetDeviceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ForgetDevice"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        return op.roundTrip(client, input)
    }

    /**
     * Calling this API causes a message to be sent to the end user with a confirmation code that is required to change the user's password. For the `Username` parameter, you can use the username or user alias. The method used to send the confirmation code is sent according to the specified AccountRecoverySetting. For more information, see [Recovering User Accounts](https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-recover-a-user-account.html) in the *Amazon Cognito Developer Guide*. If neither a verified phone number nor a verified email exists, an `InvalidParameterException` is thrown. To use the confirmation code for resetting the password, call [ConfirmForgotPassword](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmForgotPassword.html).
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    override suspend fun forgotPassword(input: ForgotPasswordRequest): ForgotPasswordResponse {
        val op = SdkHttpOperation.build<ForgotPasswordRequest, ForgotPasswordResponse> {
            serializer = ForgotPasswordOperationSerializer()
            deserializer = ForgotPasswordOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ForgotPassword"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        return op.roundTrip(client, input)
    }

    /**
     * Gets the header information for the comma-separated value (CSV) file to be used as input for the user import job.
     */
    override suspend fun getCsvHeader(input: GetCsvHeaderRequest): GetCsvHeaderResponse {
        val op = SdkHttpOperation.build<GetCsvHeaderRequest, GetCsvHeaderResponse> {
            serializer = GetCSVHeaderOperationSerializer()
            deserializer = GetCSVHeaderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCSVHeader"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the device.
     */
    override suspend fun getDevice(input: GetDeviceRequest): GetDeviceResponse {
        val op = SdkHttpOperation.build<GetDeviceRequest, GetDeviceResponse> {
            serializer = GetDeviceOperationSerializer()
            deserializer = GetDeviceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDevice"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        return op.roundTrip(client, input)
    }

    /**
     * Gets a group.
     *
     * Calling this action requires developer credentials.
     */
    override suspend fun getGroup(input: GetGroupRequest): GetGroupResponse {
        val op = SdkHttpOperation.build<GetGroupRequest, GetGroupResponse> {
            serializer = GetGroupOperationSerializer()
            deserializer = GetGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the specified IdP.
     */
    override suspend fun getIdentityProviderByIdentifier(input: GetIdentityProviderByIdentifierRequest): GetIdentityProviderByIdentifierResponse {
        val op = SdkHttpOperation.build<GetIdentityProviderByIdentifierRequest, GetIdentityProviderByIdentifierResponse> {
            serializer = GetIdentityProviderByIdentifierOperationSerializer()
            deserializer = GetIdentityProviderByIdentifierOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetIdentityProviderByIdentifier"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This method takes a user pool ID, and returns the signing certificate.
     */
    override suspend fun getSigningCertificate(input: GetSigningCertificateRequest): GetSigningCertificateResponse {
        val op = SdkHttpOperation.build<GetSigningCertificateRequest, GetSigningCertificateResponse> {
            serializer = GetSigningCertificateOperationSerializer()
            deserializer = GetSigningCertificateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSigningCertificate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the user interface (UI) Customization information for a particular app client's app UI, if any such information exists for the client. If nothing is set for the particular client, but there is an existing pool level customization (the app `clientId` is `ALL`), then that information is returned. If nothing is present, then an empty shape is returned.
     */
    override suspend fun getUiCustomization(input: GetUiCustomizationRequest): GetUiCustomizationResponse {
        val op = SdkHttpOperation.build<GetUiCustomizationRequest, GetUiCustomizationResponse> {
            serializer = GetUICustomizationOperationSerializer()
            deserializer = GetUICustomizationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetUICustomization"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the user attributes and metadata for a user.
     */
    override suspend fun getUser(input: GetUserRequest): GetUserResponse {
        val op = SdkHttpOperation.build<GetUserRequest, GetUserResponse> {
            serializer = GetUserOperationSerializer()
            deserializer = GetUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        return op.roundTrip(client, input)
    }

    /**
     * Generates a user attribute verification code for the specified attribute name. Sends a message to a user with a code that they must return in a VerifyUserAttribute request.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    override suspend fun getUserAttributeVerificationCode(input: GetUserAttributeVerificationCodeRequest): GetUserAttributeVerificationCodeResponse {
        val op = SdkHttpOperation.build<GetUserAttributeVerificationCodeRequest, GetUserAttributeVerificationCodeResponse> {
            serializer = GetUserAttributeVerificationCodeOperationSerializer()
            deserializer = GetUserAttributeVerificationCodeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetUserAttributeVerificationCode"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        return op.roundTrip(client, input)
    }

    /**
     * Gets the user pool multi-factor authentication (MFA) configuration.
     */
    override suspend fun getUserPoolMfaConfig(input: GetUserPoolMfaConfigRequest): GetUserPoolMfaConfigResponse {
        val op = SdkHttpOperation.build<GetUserPoolMfaConfigRequest, GetUserPoolMfaConfigResponse> {
            serializer = GetUserPoolMfaConfigOperationSerializer()
            deserializer = GetUserPoolMfaConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetUserPoolMfaConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Signs out users from all devices. It also invalidates all refresh tokens that Amazon Cognito has issued to a user. The user's current access and ID tokens remain valid until their expiry. By default, access and ID tokens expire one hour after Amazon Cognito issues them. A user can still use a hosted UI cookie to retrieve new tokens for the duration of the cookie validity period of 1 hour.
     */
    override suspend fun globalSignOut(input: GlobalSignOutRequest): GlobalSignOutResponse {
        val op = SdkHttpOperation.build<GlobalSignOutRequest, GlobalSignOutResponse> {
            serializer = GlobalSignOutOperationSerializer()
            deserializer = GlobalSignOutOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GlobalSignOut"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        return op.roundTrip(client, input)
    }

    /**
     * Initiates sign-in for a user in the Amazon Cognito user directory. You can't sign in a user with a federated IdP with `InitiateAuth`. For more information, see [ Adding user pool sign-in through a third party](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation.html).
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    override suspend fun initiateAuth(input: InitiateAuthRequest): InitiateAuthResponse {
        val op = SdkHttpOperation.build<InitiateAuthRequest, InitiateAuthResponse> {
            serializer = InitiateAuthOperationSerializer()
            deserializer = InitiateAuthOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "InitiateAuth"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        return op.roundTrip(client, input)
    }

    /**
     * Lists the sign-in devices that Amazon Cognito has registered to the current user.
     */
    override suspend fun listDevices(input: ListDevicesRequest): ListDevicesResponse {
        val op = SdkHttpOperation.build<ListDevicesRequest, ListDevicesResponse> {
            serializer = ListDevicesOperationSerializer()
            deserializer = ListDevicesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDevices"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        return op.roundTrip(client, input)
    }

    /**
     * Lists the groups associated with a user pool.
     *
     * Calling this action requires developer credentials.
     */
    override suspend fun listGroups(input: ListGroupsRequest): ListGroupsResponse {
        val op = SdkHttpOperation.build<ListGroupsRequest, ListGroupsResponse> {
            serializer = ListGroupsOperationSerializer()
            deserializer = ListGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists information about all IdPs for a user pool.
     */
    override suspend fun listIdentityProviders(input: ListIdentityProvidersRequest): ListIdentityProvidersResponse {
        val op = SdkHttpOperation.build<ListIdentityProvidersRequest, ListIdentityProvidersResponse> {
            serializer = ListIdentityProvidersOperationSerializer()
            deserializer = ListIdentityProvidersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListIdentityProviders"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the resource servers for a user pool.
     */
    override suspend fun listResourceServers(input: ListResourceServersRequest): ListResourceServersResponse {
        val op = SdkHttpOperation.build<ListResourceServersRequest, ListResourceServersResponse> {
            serializer = ListResourceServersOperationSerializer()
            deserializer = ListResourceServersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListResourceServers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags that are assigned to an Amazon Cognito user pool.
     *
     * A tag is a label that you can apply to user pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.
     *
     * You can use this action up to 10 times per second, per account.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the user import jobs.
     */
    override suspend fun listUserImportJobs(input: ListUserImportJobsRequest): ListUserImportJobsResponse {
        val op = SdkHttpOperation.build<ListUserImportJobsRequest, ListUserImportJobsResponse> {
            serializer = ListUserImportJobsOperationSerializer()
            deserializer = ListUserImportJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListUserImportJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the clients that have been created for the specified user pool.
     */
    override suspend fun listUserPoolClients(input: ListUserPoolClientsRequest): ListUserPoolClientsResponse {
        val op = SdkHttpOperation.build<ListUserPoolClientsRequest, ListUserPoolClientsResponse> {
            serializer = ListUserPoolClientsOperationSerializer()
            deserializer = ListUserPoolClientsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListUserPoolClients"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the user pools associated with an Amazon Web Services account.
     */
    override suspend fun listUserPools(input: ListUserPoolsRequest): ListUserPoolsResponse {
        val op = SdkHttpOperation.build<ListUserPoolsRequest, ListUserPoolsResponse> {
            serializer = ListUserPoolsOperationSerializer()
            deserializer = ListUserPoolsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListUserPools"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the users in the Amazon Cognito user pool.
     */
    override suspend fun listUsers(input: ListUsersRequest): ListUsersResponse {
        val op = SdkHttpOperation.build<ListUsersRequest, ListUsersResponse> {
            serializer = ListUsersOperationSerializer()
            deserializer = ListUsersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListUsers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the users in the specified group.
     *
     * Calling this action requires developer credentials.
     */
    override suspend fun listUsersInGroup(input: ListUsersInGroupRequest): ListUsersInGroupResponse {
        val op = SdkHttpOperation.build<ListUsersInGroupRequest, ListUsersInGroupResponse> {
            serializer = ListUsersInGroupOperationSerializer()
            deserializer = ListUsersInGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListUsersInGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Resends the confirmation (for confirmation of registration) to a specific user in the user pool.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    override suspend fun resendConfirmationCode(input: ResendConfirmationCodeRequest): ResendConfirmationCodeResponse {
        val op = SdkHttpOperation.build<ResendConfirmationCodeRequest, ResendConfirmationCodeResponse> {
            serializer = ResendConfirmationCodeOperationSerializer()
            deserializer = ResendConfirmationCodeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ResendConfirmationCode"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        return op.roundTrip(client, input)
    }

    /**
     * Responds to the authentication challenge.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    override suspend fun respondToAuthChallenge(input: RespondToAuthChallengeRequest): RespondToAuthChallengeResponse {
        val op = SdkHttpOperation.build<RespondToAuthChallengeRequest, RespondToAuthChallengeResponse> {
            serializer = RespondToAuthChallengeOperationSerializer()
            deserializer = RespondToAuthChallengeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RespondToAuthChallenge"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        return op.roundTrip(client, input)
    }

    /**
     * Revokes all of the access tokens generated by the specified refresh token. After the token is revoked, you can't use the revoked token to access Amazon Cognito authenticated APIs.
     */
    override suspend fun revokeToken(input: RevokeTokenRequest): RevokeTokenResponse {
        val op = SdkHttpOperation.build<RevokeTokenRequest, RevokeTokenResponse> {
            serializer = RevokeTokenOperationSerializer()
            deserializer = RevokeTokenOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RevokeToken"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        return op.roundTrip(client, input)
    }

    /**
     * Configures actions on detected risks. To delete the risk configuration for `UserPoolId` or `ClientId`, pass null values for all four configuration types.
     *
     * To activate Amazon Cognito advanced security features, update the user pool to include the `UserPoolAddOns` key`AdvancedSecurityMode`.
     */
    override suspend fun setRiskConfiguration(input: SetRiskConfigurationRequest): SetRiskConfigurationResponse {
        val op = SdkHttpOperation.build<SetRiskConfigurationRequest, SetRiskConfigurationResponse> {
            serializer = SetRiskConfigurationOperationSerializer()
            deserializer = SetRiskConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SetRiskConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sets the user interface (UI) customization information for a user pool's built-in app UI.
     *
     * You can specify app UI customization settings for a single client (with a specific `clientId`) or for all clients (by setting the `clientId` to `ALL`). If you specify `ALL`, the default configuration is used for every client that has no previously set UI customization. If you specify UI customization settings for a particular client, it will no longer return to the `ALL` configuration.
     *
     * To use this API, your user pool must have a domain associated with it. Otherwise, there is no place to host the app's pages, and the service will throw an error.
     */
    override suspend fun setUiCustomization(input: SetUiCustomizationRequest): SetUiCustomizationResponse {
        val op = SdkHttpOperation.build<SetUiCustomizationRequest, SetUiCustomizationResponse> {
            serializer = SetUICustomizationOperationSerializer()
            deserializer = SetUICustomizationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SetUICustomization"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Set the user's multi-factor authentication (MFA) method preference, including which MFA factors are activated and if any are preferred. Only one factor can be set as preferred. The preferred MFA factor will be used to authenticate a user if multiple factors are activated. If multiple options are activated and no preference is set, a challenge to choose an MFA option will be returned during sign-in. If an MFA type is activated for a user, the user will be prompted for MFA during all sign-in attempts unless device tracking is turned on and the device has been trusted. If you want MFA to be applied selectively based on the assessed risk level of sign-in attempts, deactivate MFA for users and turn on Adaptive Authentication for the user pool.
     */
    override suspend fun setUserMfaPreference(input: SetUserMfaPreferenceRequest): SetUserMfaPreferenceResponse {
        val op = SdkHttpOperation.build<SetUserMfaPreferenceRequest, SetUserMfaPreferenceResponse> {
            serializer = SetUserMFAPreferenceOperationSerializer()
            deserializer = SetUserMFAPreferenceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SetUserMFAPreference"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sets the user pool multi-factor authentication (MFA) configuration.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    override suspend fun setUserPoolMfaConfig(input: SetUserPoolMfaConfigRequest): SetUserPoolMfaConfigResponse {
        val op = SdkHttpOperation.build<SetUserPoolMfaConfigRequest, SetUserPoolMfaConfigResponse> {
            serializer = SetUserPoolMfaConfigOperationSerializer()
            deserializer = SetUserPoolMfaConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SetUserPoolMfaConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * *This action is no longer supported.* You can use it to configure only SMS MFA. You can't use it to configure time-based one-time password (TOTP) software token MFA. To configure either type of MFA, use [SetUserMFAPreference](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUserMFAPreference.html) instead.
     */
    override suspend fun setUserSettings(input: SetUserSettingsRequest): SetUserSettingsResponse {
        val op = SdkHttpOperation.build<SetUserSettingsRequest, SetUserSettingsResponse> {
            serializer = SetUserSettingsOperationSerializer()
            deserializer = SetUserSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SetUserSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        return op.roundTrip(client, input)
    }

    /**
     * Registers the user in the specified user pool and creates a user name, password, and user attributes.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    override suspend fun signUp(input: SignUpRequest): SignUpResponse {
        val op = SdkHttpOperation.build<SignUpRequest, SignUpResponse> {
            serializer = SignUpOperationSerializer()
            deserializer = SignUpOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SignUp"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        return op.roundTrip(client, input)
    }

    /**
     * Starts the user import.
     */
    override suspend fun startUserImportJob(input: StartUserImportJobRequest): StartUserImportJobResponse {
        val op = SdkHttpOperation.build<StartUserImportJobRequest, StartUserImportJobResponse> {
            serializer = StartUserImportJobOperationSerializer()
            deserializer = StartUserImportJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartUserImportJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops the user import job.
     */
    override suspend fun stopUserImportJob(input: StopUserImportJobRequest): StopUserImportJobResponse {
        val op = SdkHttpOperation.build<StopUserImportJobRequest, StopUserImportJobResponse> {
            serializer = StopUserImportJobOperationSerializer()
            deserializer = StopUserImportJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopUserImportJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Assigns a set of tags to an Amazon Cognito user pool. A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.
     *
     * Each tag consists of a key and value, both of which you define. A key is a general category for more specific values. For example, if you have two versions of a user pool, one for testing and another for production, you might assign an `Environment` tag key to both user pools. The value of this key might be `Test` for one user pool, and `Production` for the other.
     *
     * Tags are useful for cost tracking and access control. You can activate your tags so that they appear on the Billing and Cost Management console, where you can track the costs associated with your user pools. In an Identity and Access Management policy, you can constrain permissions for user pools based on specific tags or tag values.
     *
     * You can use this action up to 5 times per second, per account. A user pool can have as many as 50 tags.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified tags from an Amazon Cognito user pool. You can use this action up to 5 times per second, per account.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides the feedback for an authentication event, whether it was from a valid user or not. This feedback is used for improving the risk evaluation decision for the user pool as part of Amazon Cognito advanced security.
     */
    override suspend fun updateAuthEventFeedback(input: UpdateAuthEventFeedbackRequest): UpdateAuthEventFeedbackResponse {
        val op = SdkHttpOperation.build<UpdateAuthEventFeedbackRequest, UpdateAuthEventFeedbackResponse> {
            serializer = UpdateAuthEventFeedbackOperationSerializer()
            deserializer = UpdateAuthEventFeedbackOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAuthEventFeedback"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the device status.
     */
    override suspend fun updateDeviceStatus(input: UpdateDeviceStatusRequest): UpdateDeviceStatusResponse {
        val op = SdkHttpOperation.build<UpdateDeviceStatusRequest, UpdateDeviceStatusResponse> {
            serializer = UpdateDeviceStatusOperationSerializer()
            deserializer = UpdateDeviceStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDeviceStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified group with the specified attributes.
     *
     * Calling this action requires developer credentials.
     */
    override suspend fun updateGroup(input: UpdateGroupRequest): UpdateGroupResponse {
        val op = SdkHttpOperation.build<UpdateGroupRequest, UpdateGroupResponse> {
            serializer = UpdateGroupOperationSerializer()
            deserializer = UpdateGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates IdP information for a user pool.
     */
    override suspend fun updateIdentityProvider(input: UpdateIdentityProviderRequest): UpdateIdentityProviderResponse {
        val op = SdkHttpOperation.build<UpdateIdentityProviderRequest, UpdateIdentityProviderResponse> {
            serializer = UpdateIdentityProviderOperationSerializer()
            deserializer = UpdateIdentityProviderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateIdentityProvider"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the name and scopes of resource server. All other fields are read-only.
     *
     * If you don't provide a value for an attribute, it is set to the default value.
     */
    override suspend fun updateResourceServer(input: UpdateResourceServerRequest): UpdateResourceServerResponse {
        val op = SdkHttpOperation.build<UpdateResourceServerRequest, UpdateResourceServerResponse> {
            serializer = UpdateResourceServerOperationSerializer()
            deserializer = UpdateResourceServerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateResourceServer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Allows a user to update a specific attribute (one at a time).
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    override suspend fun updateUserAttributes(input: UpdateUserAttributesRequest): UpdateUserAttributesResponse {
        val op = SdkHttpOperation.build<UpdateUserAttributesRequest, UpdateUserAttributesResponse> {
            serializer = UpdateUserAttributesOperationSerializer()
            deserializer = UpdateUserAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateUserAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified user pool with the specified attributes. You can get a list of the current user pool settings using [DescribeUserPool](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html). If you don't provide a value for an attribute, it will be set to the default value.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    override suspend fun updateUserPool(input: UpdateUserPoolRequest): UpdateUserPoolResponse {
        val op = SdkHttpOperation.build<UpdateUserPoolRequest, UpdateUserPoolResponse> {
            serializer = UpdateUserPoolOperationSerializer()
            deserializer = UpdateUserPoolOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateUserPool"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified user pool app client with the specified attributes. You can get a list of the current user pool app client settings using [DescribeUserPoolClient](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPoolClient.html).
     *
     * If you don't provide a value for an attribute, it will be set to the default value.
     *
     * You can also use this operation to enable token revocation for user pool clients. For more information about revoking tokens, see [RevokeToken](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html).
     */
    override suspend fun updateUserPoolClient(input: UpdateUserPoolClientRequest): UpdateUserPoolClientResponse {
        val op = SdkHttpOperation.build<UpdateUserPoolClientRequest, UpdateUserPoolClientResponse> {
            serializer = UpdateUserPoolClientOperationSerializer()
            deserializer = UpdateUserPoolClientOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateUserPoolClient"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the Secure Sockets Layer (SSL) certificate for the custom domain for your user pool.
     *
     * You can use this operation to provide the Amazon Resource Name (ARN) of a new certificate to Amazon Cognito. You can't use it to change the domain for a user pool.
     *
     * A custom domain is used to host the Amazon Cognito hosted UI, which provides sign-up and sign-in pages for your application. When you set up a custom domain, you provide a certificate that you manage with Certificate Manager (ACM). When necessary, you can use this operation to change the certificate that you applied to your custom domain.
     *
     * Usually, this is unnecessary following routine certificate renewal with ACM. When you renew your existing certificate in ACM, the ARN for your certificate remains the same, and your custom domain uses the new certificate automatically.
     *
     * However, if you replace your existing certificate with a new one, ACM gives the new certificate a new ARN. To apply the new certificate to your custom domain, you must provide this ARN to Amazon Cognito.
     *
     * When you add your new certificate in ACM, you must choose US East (N. Virginia) as the Amazon Web Services Region.
     *
     * After you submit your request, Amazon Cognito requires up to 1 hour to distribute your new certificate to your custom domain.
     *
     * For more information about adding a custom domain to your user pool, see [Using Your Own Domain for the Hosted UI](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html).
     */
    override suspend fun updateUserPoolDomain(input: UpdateUserPoolDomainRequest): UpdateUserPoolDomainResponse {
        val op = SdkHttpOperation.build<UpdateUserPoolDomainRequest, UpdateUserPoolDomainResponse> {
            serializer = UpdateUserPoolDomainOperationSerializer()
            deserializer = UpdateUserPoolDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateUserPoolDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Use this API to register a user's entered time-based one-time password (TOTP) code and mark the user's software token MFA status as "verified" if successful. The request takes an access token or a session string, but not both.
     */
    override suspend fun verifySoftwareToken(input: VerifySoftwareTokenRequest): VerifySoftwareTokenResponse {
        val op = SdkHttpOperation.build<VerifySoftwareTokenRequest, VerifySoftwareTokenResponse> {
            serializer = VerifySoftwareTokenOperationSerializer()
            deserializer = VerifySoftwareTokenOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "VerifySoftwareToken"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "cognito-idp"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Verifies the specified user attributes in the user pool.
     *
     *  If your user pool requires verification before Amazon Cognito updates the attribute value, VerifyUserAttribute updates the affected attribute to its pending value. For more information, see [ UserAttributeUpdateSettingsType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UserAttributeUpdateSettingsType.html).
     */
    override suspend fun verifyUserAttribute(input: VerifyUserAttributeRequest): VerifyUserAttributeResponse {
        val op = SdkHttpOperation.build<VerifyUserAttributeRequest, VerifyUserAttributeResponse> {
            serializer = VerifyUserAttributeOperationSerializer()
            deserializer = VerifyUserAttributeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "VerifyUserAttribute"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSCognitoIdentityProviderService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "cognito-idp")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
