// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.cognitoidentityprovider.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.cognitoidentityprovider.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Using the Amazon Cognito user pools API, you can create a user pool to manage directories and users. You can authenticate a user to obtain tokens related to user identity and access policies.
 *
 * This API reference provides information about user pools in Amazon Cognito user pools.
 *
 * For more information, see the [Amazon Cognito Documentation](https://docs.aws.amazon.com/cognito/latest/developerguide/what-is-amazon-cognito.html).
 */
interface CognitoIdentityProviderClient : SdkClient {

    override val serviceName: String
        get() = "Cognito Identity Provider"
    /**
     * CognitoIdentityProviderClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): CognitoIdentityProviderClient {
            val config = Config.Builder().apply(block).build()
            return DefaultCognitoIdentityProviderClient(config)
        }

        operator fun invoke(config: Config): CognitoIdentityProviderClient = DefaultCognitoIdentityProviderClient(config)

        /**
         * Construct a [CognitoIdentityProviderClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): CognitoIdentityProviderClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultCognitoIdentityProviderClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Adds additional user attributes to the user pool schema.
     */
    suspend fun addCustomAttributes(input: AddCustomAttributesRequest): AddCustomAttributesResponse

    /**
     * Adds additional user attributes to the user pool schema.
     */
    suspend fun addCustomAttributes(block: AddCustomAttributesRequest.Builder.() -> Unit) = addCustomAttributes(AddCustomAttributesRequest.Builder().apply(block).build())

    /**
     * Adds the specified user to the specified group.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminAddUserToGroup(input: AdminAddUserToGroupRequest): AdminAddUserToGroupResponse

    /**
     * Adds the specified user to the specified group.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminAddUserToGroup(block: AdminAddUserToGroupRequest.Builder.() -> Unit) = adminAddUserToGroup(AdminAddUserToGroupRequest.Builder().apply(block).build())

    /**
     * Confirms user registration as an admin without using a confirmation code. Works on any user.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminConfirmSignUp(input: AdminConfirmSignUpRequest): AdminConfirmSignUpResponse

    /**
     * Confirms user registration as an admin without using a confirmation code. Works on any user.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminConfirmSignUp(block: AdminConfirmSignUpRequest.Builder.() -> Unit) = adminConfirmSignUp(AdminConfirmSignUpRequest.Builder().apply(block).build())

    /**
     * Creates a new user in the specified user pool.
     *
     * If `MessageAction` isn't set, the default is to send a welcome message via email or phone (SMS).
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     *
     * This message is based on a template that you configured in your call to create or update a user pool. This template includes your custom sign-up instructions and placeholders for user name and temporary password.
     *
     * Alternatively, you can call `AdminCreateUser` with `SUPPRESS` for the `MessageAction` parameter, and Amazon Cognito won't send any email.
     *
     * In either case, the user will be in the `FORCE_CHANGE_PASSWORD` state until they sign in and change their password.
     *
     * `AdminCreateUser` requires developer credentials.
     */
    suspend fun adminCreateUser(input: AdminCreateUserRequest): AdminCreateUserResponse

    /**
     * Creates a new user in the specified user pool.
     *
     * If `MessageAction` isn't set, the default is to send a welcome message via email or phone (SMS).
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     *
     * This message is based on a template that you configured in your call to create or update a user pool. This template includes your custom sign-up instructions and placeholders for user name and temporary password.
     *
     * Alternatively, you can call `AdminCreateUser` with `SUPPRESS` for the `MessageAction` parameter, and Amazon Cognito won't send any email.
     *
     * In either case, the user will be in the `FORCE_CHANGE_PASSWORD` state until they sign in and change their password.
     *
     * `AdminCreateUser` requires developer credentials.
     */
    suspend fun adminCreateUser(block: AdminCreateUserRequest.Builder.() -> Unit) = adminCreateUser(AdminCreateUserRequest.Builder().apply(block).build())

    /**
     * Deletes a user as an administrator. Works on any user.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminDeleteUser(input: AdminDeleteUserRequest): AdminDeleteUserResponse

    /**
     * Deletes a user as an administrator. Works on any user.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminDeleteUser(block: AdminDeleteUserRequest.Builder.() -> Unit) = adminDeleteUser(AdminDeleteUserRequest.Builder().apply(block).build())

    /**
     * Deletes the user attributes in a user pool as an administrator. Works on any user.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminDeleteUserAttributes(input: AdminDeleteUserAttributesRequest): AdminDeleteUserAttributesResponse

    /**
     * Deletes the user attributes in a user pool as an administrator. Works on any user.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminDeleteUserAttributes(block: AdminDeleteUserAttributesRequest.Builder.() -> Unit) = adminDeleteUserAttributes(AdminDeleteUserAttributesRequest.Builder().apply(block).build())

    /**
     * Prevents the user from signing in with the specified external (SAML or social) identity provider (IdP). If the user that you want to deactivate is a Amazon Cognito user pools native username + password user, they can't use their password to sign in. If the user to deactivate is a linked external IdP user, any link between that user and an existing user is removed. When the external user signs in again, and the user is no longer attached to the previously linked `DestinationUser`, the user must create a new user account. See [AdminLinkProviderForUser](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminLinkProviderForUser.html).
     *
     * This action is enabled only for admin access and requires developer credentials.
     *
     * The `ProviderName` must match the value specified when creating an IdP for the pool.
     *
     * To deactivate a native username + password user, the `ProviderName` value must be `Cognito` and the `ProviderAttributeName` must be `Cognito_Subject`. The `ProviderAttributeValue` must be the name that is used in the user pool for the user.
     *
     * The `ProviderAttributeName` must always be `Cognito_Subject` for social IdPs. The `ProviderAttributeValue` must always be the exact subject that was used when the user was originally linked as a source user.
     *
     * For de-linking a SAML identity, there are two scenarios. If the linked identity has not yet been used to sign in, the `ProviderAttributeName` and `ProviderAttributeValue` must be the same values that were used for the `SourceUser` when the identities were originally linked using ` AdminLinkProviderForUser` call. (If the linking was done with `ProviderAttributeName` set to `Cognito_Subject`, the same applies here). However, if the user has already signed in, the `ProviderAttributeName` must be `Cognito_Subject` and `ProviderAttributeValue` must be the subject of the SAML assertion.
     */
    suspend fun adminDisableProviderForUser(input: AdminDisableProviderForUserRequest): AdminDisableProviderForUserResponse

    /**
     * Prevents the user from signing in with the specified external (SAML or social) identity provider (IdP). If the user that you want to deactivate is a Amazon Cognito user pools native username + password user, they can't use their password to sign in. If the user to deactivate is a linked external IdP user, any link between that user and an existing user is removed. When the external user signs in again, and the user is no longer attached to the previously linked `DestinationUser`, the user must create a new user account. See [AdminLinkProviderForUser](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminLinkProviderForUser.html).
     *
     * This action is enabled only for admin access and requires developer credentials.
     *
     * The `ProviderName` must match the value specified when creating an IdP for the pool.
     *
     * To deactivate a native username + password user, the `ProviderName` value must be `Cognito` and the `ProviderAttributeName` must be `Cognito_Subject`. The `ProviderAttributeValue` must be the name that is used in the user pool for the user.
     *
     * The `ProviderAttributeName` must always be `Cognito_Subject` for social IdPs. The `ProviderAttributeValue` must always be the exact subject that was used when the user was originally linked as a source user.
     *
     * For de-linking a SAML identity, there are two scenarios. If the linked identity has not yet been used to sign in, the `ProviderAttributeName` and `ProviderAttributeValue` must be the same values that were used for the `SourceUser` when the identities were originally linked using ` AdminLinkProviderForUser` call. (If the linking was done with `ProviderAttributeName` set to `Cognito_Subject`, the same applies here). However, if the user has already signed in, the `ProviderAttributeName` must be `Cognito_Subject` and `ProviderAttributeValue` must be the subject of the SAML assertion.
     */
    suspend fun adminDisableProviderForUser(block: AdminDisableProviderForUserRequest.Builder.() -> Unit) = adminDisableProviderForUser(AdminDisableProviderForUserRequest.Builder().apply(block).build())

    /**
     * Disables the specified user.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminDisableUser(input: AdminDisableUserRequest): AdminDisableUserResponse

    /**
     * Disables the specified user.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminDisableUser(block: AdminDisableUserRequest.Builder.() -> Unit) = adminDisableUser(AdminDisableUserRequest.Builder().apply(block).build())

    /**
     * Enables the specified user as an administrator. Works on any user.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminEnableUser(input: AdminEnableUserRequest): AdminEnableUserResponse

    /**
     * Enables the specified user as an administrator. Works on any user.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminEnableUser(block: AdminEnableUserRequest.Builder.() -> Unit) = adminEnableUser(AdminEnableUserRequest.Builder().apply(block).build())

    /**
     * Forgets the device, as an administrator.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminForgetDevice(input: AdminForgetDeviceRequest): AdminForgetDeviceResponse

    /**
     * Forgets the device, as an administrator.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminForgetDevice(block: AdminForgetDeviceRequest.Builder.() -> Unit) = adminForgetDevice(AdminForgetDeviceRequest.Builder().apply(block).build())

    /**
     * Gets the device, as an administrator.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminGetDevice(input: AdminGetDeviceRequest): AdminGetDeviceResponse

    /**
     * Gets the device, as an administrator.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminGetDevice(block: AdminGetDeviceRequest.Builder.() -> Unit) = adminGetDevice(AdminGetDeviceRequest.Builder().apply(block).build())

    /**
     * Gets the specified user by user name in a user pool as an administrator. Works on any user.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminGetUser(input: AdminGetUserRequest): AdminGetUserResponse

    /**
     * Gets the specified user by user name in a user pool as an administrator. Works on any user.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminGetUser(block: AdminGetUserRequest.Builder.() -> Unit) = adminGetUser(AdminGetUserRequest.Builder().apply(block).build())

    /**
     * Initiates the authentication flow, as an administrator.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminInitiateAuth(input: AdminInitiateAuthRequest): AdminInitiateAuthResponse

    /**
     * Initiates the authentication flow, as an administrator.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminInitiateAuth(block: AdminInitiateAuthRequest.Builder.() -> Unit) = adminInitiateAuth(AdminInitiateAuthRequest.Builder().apply(block).build())

    /**
     * Links an existing user account in a user pool (`DestinationUser`) to an identity from an external IdP (`SourceUser`) based on a specified attribute name and value from the external IdP. This allows you to create a link from the existing user account to an external federated user identity that has not yet been used to sign in. You can then use the federated user identity to sign in as the existing user account.
     *
     *  For example, if there is an existing user with a username and password, this API links that user to a federated user identity. When the user signs in with a federated user identity, they sign in as the existing user account.
     *
     * The maximum number of federated identities linked to a user is five.
     *
     * Because this API allows a user with an external federated identity to sign in as an existing user in the user pool, it is critical that it only be used with external IdPs and provider attributes that have been trusted by the application owner.
     *
     * This action is administrative and requires developer credentials.
     */
    suspend fun adminLinkProviderForUser(input: AdminLinkProviderForUserRequest): AdminLinkProviderForUserResponse

    /**
     * Links an existing user account in a user pool (`DestinationUser`) to an identity from an external IdP (`SourceUser`) based on a specified attribute name and value from the external IdP. This allows you to create a link from the existing user account to an external federated user identity that has not yet been used to sign in. You can then use the federated user identity to sign in as the existing user account.
     *
     *  For example, if there is an existing user with a username and password, this API links that user to a federated user identity. When the user signs in with a federated user identity, they sign in as the existing user account.
     *
     * The maximum number of federated identities linked to a user is five.
     *
     * Because this API allows a user with an external federated identity to sign in as an existing user in the user pool, it is critical that it only be used with external IdPs and provider attributes that have been trusted by the application owner.
     *
     * This action is administrative and requires developer credentials.
     */
    suspend fun adminLinkProviderForUser(block: AdminLinkProviderForUserRequest.Builder.() -> Unit) = adminLinkProviderForUser(AdminLinkProviderForUserRequest.Builder().apply(block).build())

    /**
     * Lists devices, as an administrator.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminListDevices(input: AdminListDevicesRequest): AdminListDevicesResponse

    /**
     * Lists devices, as an administrator.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminListDevices(block: AdminListDevicesRequest.Builder.() -> Unit) = adminListDevices(AdminListDevicesRequest.Builder().apply(block).build())

    /**
     * Lists the groups that the user belongs to.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminListGroupsForUser(input: AdminListGroupsForUserRequest): AdminListGroupsForUserResponse

    /**
     * Lists the groups that the user belongs to.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminListGroupsForUser(block: AdminListGroupsForUserRequest.Builder.() -> Unit) = adminListGroupsForUser(AdminListGroupsForUserRequest.Builder().apply(block).build())

    /**
     * A history of user activity and any risks detected as part of Amazon Cognito advanced security.
     */
    suspend fun adminListUserAuthEvents(input: AdminListUserAuthEventsRequest): AdminListUserAuthEventsResponse

    /**
     * A history of user activity and any risks detected as part of Amazon Cognito advanced security.
     */
    suspend fun adminListUserAuthEvents(block: AdminListUserAuthEventsRequest.Builder.() -> Unit) = adminListUserAuthEvents(AdminListUserAuthEventsRequest.Builder().apply(block).build())

    /**
     * Removes the specified user from the specified group.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminRemoveUserFromGroup(input: AdminRemoveUserFromGroupRequest): AdminRemoveUserFromGroupResponse

    /**
     * Removes the specified user from the specified group.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminRemoveUserFromGroup(block: AdminRemoveUserFromGroupRequest.Builder.() -> Unit) = adminRemoveUserFromGroup(AdminRemoveUserFromGroupRequest.Builder().apply(block).build())

    /**
     * Resets the specified user's password in a user pool as an administrator. Works on any user.
     *
     * When a developer calls this API, the current password is invalidated, so it must be changed. If a user tries to sign in after the API is called, the app will get a PasswordResetRequiredException exception back and should direct the user down the flow to reset the password, which is the same as the forgot password flow. In addition, if the user pool has phone verification selected and a verified phone number exists for the user, or if email verification is selected and a verified email exists for the user, calling this API will also result in sending a message to the end user with the code to change their password.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminResetUserPassword(input: AdminResetUserPasswordRequest): AdminResetUserPasswordResponse

    /**
     * Resets the specified user's password in a user pool as an administrator. Works on any user.
     *
     * When a developer calls this API, the current password is invalidated, so it must be changed. If a user tries to sign in after the API is called, the app will get a PasswordResetRequiredException exception back and should direct the user down the flow to reset the password, which is the same as the forgot password flow. In addition, if the user pool has phone verification selected and a verified phone number exists for the user, or if email verification is selected and a verified email exists for the user, calling this API will also result in sending a message to the end user with the code to change their password.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminResetUserPassword(block: AdminResetUserPasswordRequest.Builder.() -> Unit) = adminResetUserPassword(AdminResetUserPasswordRequest.Builder().apply(block).build())

    /**
     * Responds to an authentication challenge, as an administrator.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminRespondToAuthChallenge(input: AdminRespondToAuthChallengeRequest): AdminRespondToAuthChallengeResponse

    /**
     * Responds to an authentication challenge, as an administrator.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminRespondToAuthChallenge(block: AdminRespondToAuthChallengeRequest.Builder.() -> Unit) = adminRespondToAuthChallenge(AdminRespondToAuthChallengeRequest.Builder().apply(block).build())

    /**
     * The user's multi-factor authentication (MFA) preference, including which MFA options are activated, and if any are preferred. Only one factor can be set as preferred. The preferred MFA factor will be used to authenticate a user if multiple factors are activated. If multiple options are activated and no preference is set, a challenge to choose an MFA option will be returned during sign-in.
     */
    suspend fun adminSetUserMfaPreference(input: AdminSetUserMfaPreferenceRequest): AdminSetUserMfaPreferenceResponse

    /**
     * The user's multi-factor authentication (MFA) preference, including which MFA options are activated, and if any are preferred. Only one factor can be set as preferred. The preferred MFA factor will be used to authenticate a user if multiple factors are activated. If multiple options are activated and no preference is set, a challenge to choose an MFA option will be returned during sign-in.
     */
    suspend fun adminSetUserMfaPreference(block: AdminSetUserMfaPreferenceRequest.Builder.() -> Unit) = adminSetUserMfaPreference(AdminSetUserMfaPreferenceRequest.Builder().apply(block).build())

    /**
     * Sets the specified user's password in a user pool as an administrator. Works on any user.
     *
     * The password can be temporary or permanent. If it is temporary, the user status enters the `FORCE_CHANGE_PASSWORD` state. When the user next tries to sign in, the InitiateAuth/AdminInitiateAuth response will contain the `NEW_PASSWORD_REQUIRED` challenge. If the user doesn't sign in before it expires, the user won't be able to sign in, and an administrator must reset their password.
     *
     * Once the user has set a new password, or the password is permanent, the user status is set to `Confirmed`.
     */
    suspend fun adminSetUserPassword(input: AdminSetUserPasswordRequest): AdminSetUserPasswordResponse

    /**
     * Sets the specified user's password in a user pool as an administrator. Works on any user.
     *
     * The password can be temporary or permanent. If it is temporary, the user status enters the `FORCE_CHANGE_PASSWORD` state. When the user next tries to sign in, the InitiateAuth/AdminInitiateAuth response will contain the `NEW_PASSWORD_REQUIRED` challenge. If the user doesn't sign in before it expires, the user won't be able to sign in, and an administrator must reset their password.
     *
     * Once the user has set a new password, or the password is permanent, the user status is set to `Confirmed`.
     */
    suspend fun adminSetUserPassword(block: AdminSetUserPasswordRequest.Builder.() -> Unit) = adminSetUserPassword(AdminSetUserPasswordRequest.Builder().apply(block).build())

    /**
     * *This action is no longer supported.* You can use it to configure only SMS MFA. You can't use it to configure time-based one-time password (TOTP) software token MFA. To configure either type of MFA, use [AdminSetUserMFAPreference](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminSetUserMFAPreference.html) instead.
     */
    suspend fun adminSetUserSettings(input: AdminSetUserSettingsRequest): AdminSetUserSettingsResponse

    /**
     * *This action is no longer supported.* You can use it to configure only SMS MFA. You can't use it to configure time-based one-time password (TOTP) software token MFA. To configure either type of MFA, use [AdminSetUserMFAPreference](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminSetUserMFAPreference.html) instead.
     */
    suspend fun adminSetUserSettings(block: AdminSetUserSettingsRequest.Builder.() -> Unit) = adminSetUserSettings(AdminSetUserSettingsRequest.Builder().apply(block).build())

    /**
     * Provides feedback for an authentication event indicating if it was from a valid user. This feedback is used for improving the risk evaluation decision for the user pool as part of Amazon Cognito advanced security.
     */
    suspend fun adminUpdateAuthEventFeedback(input: AdminUpdateAuthEventFeedbackRequest): AdminUpdateAuthEventFeedbackResponse

    /**
     * Provides feedback for an authentication event indicating if it was from a valid user. This feedback is used for improving the risk evaluation decision for the user pool as part of Amazon Cognito advanced security.
     */
    suspend fun adminUpdateAuthEventFeedback(block: AdminUpdateAuthEventFeedbackRequest.Builder.() -> Unit) = adminUpdateAuthEventFeedback(AdminUpdateAuthEventFeedbackRequest.Builder().apply(block).build())

    /**
     * Updates the device status as an administrator.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminUpdateDeviceStatus(input: AdminUpdateDeviceStatusRequest): AdminUpdateDeviceStatusResponse

    /**
     * Updates the device status as an administrator.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminUpdateDeviceStatus(block: AdminUpdateDeviceStatusRequest.Builder.() -> Unit) = adminUpdateDeviceStatus(AdminUpdateDeviceStatusRequest.Builder().apply(block).build())

    /**
     * Updates the specified user's attributes, including developer attributes, as an administrator. Works on any user.
     *
     * For custom attributes, you must prepend the `custom:` prefix to the attribute name.
     *
     * In addition to updating user attributes, this API can also be used to mark phone and email as verified.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminUpdateUserAttributes(input: AdminUpdateUserAttributesRequest): AdminUpdateUserAttributesResponse

    /**
     * Updates the specified user's attributes, including developer attributes, as an administrator. Works on any user.
     *
     * For custom attributes, you must prepend the `custom:` prefix to the attribute name.
     *
     * In addition to updating user attributes, this API can also be used to mark phone and email as verified.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminUpdateUserAttributes(block: AdminUpdateUserAttributesRequest.Builder.() -> Unit) = adminUpdateUserAttributes(AdminUpdateUserAttributesRequest.Builder().apply(block).build())

    /**
     * Signs out a user from all devices. You must sign `AdminUserGlobalSignOut` requests with Amazon Web Services credentials. It also invalidates all refresh tokens that Amazon Cognito has issued to a user. The user's current access and ID tokens remain valid until they expire. By default, access and ID tokens expire one hour after they're issued. A user can still use a hosted UI cookie to retrieve new tokens for the duration of the cookie validity period of 1 hour.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminUserGlobalSignOut(input: AdminUserGlobalSignOutRequest): AdminUserGlobalSignOutResponse

    /**
     * Signs out a user from all devices. You must sign `AdminUserGlobalSignOut` requests with Amazon Web Services credentials. It also invalidates all refresh tokens that Amazon Cognito has issued to a user. The user's current access and ID tokens remain valid until they expire. By default, access and ID tokens expire one hour after they're issued. A user can still use a hosted UI cookie to retrieve new tokens for the duration of the cookie validity period of 1 hour.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun adminUserGlobalSignOut(block: AdminUserGlobalSignOutRequest.Builder.() -> Unit) = adminUserGlobalSignOut(AdminUserGlobalSignOutRequest.Builder().apply(block).build())

    /**
     * Begins setup of time-based one-time password multi-factor authentication (TOTP MFA) for a user, with a unique private key that Amazon Cognito generates and returns in the API response. You can authorize an `AssociateSoftwareToken` request with either the user's access token, or a session string from a challenge response that you received from Amazon Cognito.
     *
     * Amazon Cognito disassociates an existing software token when you verify the new token in a [ VerifySoftwareToken](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerifySoftwareToken.html) API request. If you don't verify the software token and your user pool doesn't require MFA, the user can then authenticate with user name and password credentials alone. If your user pool requires TOTP MFA, Amazon Cognito generates an `MFA_SETUP` or `SOFTWARE_TOKEN_SETUP` challenge each time your user signs. Complete setup with `AssociateSoftwareToken` and `VerifySoftwareToken`.
     *
     * After you set up software token MFA for your user, Amazon Cognito generates a `SOFTWARE_TOKEN_MFA` challenge when they authenticate. Respond to this challenge with your user's TOTP.
     */
    suspend fun associateSoftwareToken(input: AssociateSoftwareTokenRequest = AssociateSoftwareTokenRequest {}): AssociateSoftwareTokenResponse

    /**
     * Begins setup of time-based one-time password multi-factor authentication (TOTP MFA) for a user, with a unique private key that Amazon Cognito generates and returns in the API response. You can authorize an `AssociateSoftwareToken` request with either the user's access token, or a session string from a challenge response that you received from Amazon Cognito.
     *
     * Amazon Cognito disassociates an existing software token when you verify the new token in a [ VerifySoftwareToken](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerifySoftwareToken.html) API request. If you don't verify the software token and your user pool doesn't require MFA, the user can then authenticate with user name and password credentials alone. If your user pool requires TOTP MFA, Amazon Cognito generates an `MFA_SETUP` or `SOFTWARE_TOKEN_SETUP` challenge each time your user signs. Complete setup with `AssociateSoftwareToken` and `VerifySoftwareToken`.
     *
     * After you set up software token MFA for your user, Amazon Cognito generates a `SOFTWARE_TOKEN_MFA` challenge when they authenticate. Respond to this challenge with your user's TOTP.
     */
    suspend fun associateSoftwareToken(block: AssociateSoftwareTokenRequest.Builder.() -> Unit) = associateSoftwareToken(AssociateSoftwareTokenRequest.Builder().apply(block).build())

    /**
     * Changes the password for a specified user in a user pool.
     */
    suspend fun changePassword(input: ChangePasswordRequest): ChangePasswordResponse

    /**
     * Changes the password for a specified user in a user pool.
     */
    suspend fun changePassword(block: ChangePasswordRequest.Builder.() -> Unit) = changePassword(ChangePasswordRequest.Builder().apply(block).build())

    /**
     * Confirms tracking of the device. This API call is the call that begins device tracking.
     */
    suspend fun confirmDevice(input: ConfirmDeviceRequest): ConfirmDeviceResponse

    /**
     * Confirms tracking of the device. This API call is the call that begins device tracking.
     */
    suspend fun confirmDevice(block: ConfirmDeviceRequest.Builder.() -> Unit) = confirmDevice(ConfirmDeviceRequest.Builder().apply(block).build())

    /**
     * Allows a user to enter a confirmation code to reset a forgotten password.
     */
    suspend fun confirmForgotPassword(input: ConfirmForgotPasswordRequest): ConfirmForgotPasswordResponse

    /**
     * Allows a user to enter a confirmation code to reset a forgotten password.
     */
    suspend fun confirmForgotPassword(block: ConfirmForgotPasswordRequest.Builder.() -> Unit) = confirmForgotPassword(ConfirmForgotPasswordRequest.Builder().apply(block).build())

    /**
     * Confirms registration of a new user.
     */
    suspend fun confirmSignUp(input: ConfirmSignUpRequest): ConfirmSignUpResponse

    /**
     * Confirms registration of a new user.
     */
    suspend fun confirmSignUp(block: ConfirmSignUpRequest.Builder.() -> Unit) = confirmSignUp(ConfirmSignUpRequest.Builder().apply(block).build())

    /**
     * Creates a new group in the specified user pool.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun createGroup(input: CreateGroupRequest): CreateGroupResponse

    /**
     * Creates a new group in the specified user pool.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun createGroup(block: CreateGroupRequest.Builder.() -> Unit) = createGroup(CreateGroupRequest.Builder().apply(block).build())

    /**
     * Creates an IdP for a user pool.
     */
    suspend fun createIdentityProvider(input: CreateIdentityProviderRequest): CreateIdentityProviderResponse

    /**
     * Creates an IdP for a user pool.
     */
    suspend fun createIdentityProvider(block: CreateIdentityProviderRequest.Builder.() -> Unit) = createIdentityProvider(CreateIdentityProviderRequest.Builder().apply(block).build())

    /**
     * Creates a new OAuth2.0 resource server and defines custom scopes within it.
     */
    suspend fun createResourceServer(input: CreateResourceServerRequest): CreateResourceServerResponse

    /**
     * Creates a new OAuth2.0 resource server and defines custom scopes within it.
     */
    suspend fun createResourceServer(block: CreateResourceServerRequest.Builder.() -> Unit) = createResourceServer(CreateResourceServerRequest.Builder().apply(block).build())

    /**
     * Creates the user import job.
     */
    suspend fun createUserImportJob(input: CreateUserImportJobRequest): CreateUserImportJobResponse

    /**
     * Creates the user import job.
     */
    suspend fun createUserImportJob(block: CreateUserImportJobRequest.Builder.() -> Unit) = createUserImportJob(CreateUserImportJobRequest.Builder().apply(block).build())

    /**
     * Creates a new Amazon Cognito user pool and sets the password policy for the pool.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    suspend fun createUserPool(input: CreateUserPoolRequest): CreateUserPoolResponse

    /**
     * Creates a new Amazon Cognito user pool and sets the password policy for the pool.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    suspend fun createUserPool(block: CreateUserPoolRequest.Builder.() -> Unit) = createUserPool(CreateUserPoolRequest.Builder().apply(block).build())

    /**
     * Creates the user pool client.
     *
     * When you create a new user pool client, token revocation is automatically activated. For more information about revoking tokens, see [RevokeToken](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html).
     */
    suspend fun createUserPoolClient(input: CreateUserPoolClientRequest): CreateUserPoolClientResponse

    /**
     * Creates the user pool client.
     *
     * When you create a new user pool client, token revocation is automatically activated. For more information about revoking tokens, see [RevokeToken](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html).
     */
    suspend fun createUserPoolClient(block: CreateUserPoolClientRequest.Builder.() -> Unit) = createUserPoolClient(CreateUserPoolClientRequest.Builder().apply(block).build())

    /**
     * Creates a new domain for a user pool.
     */
    suspend fun createUserPoolDomain(input: CreateUserPoolDomainRequest): CreateUserPoolDomainResponse

    /**
     * Creates a new domain for a user pool.
     */
    suspend fun createUserPoolDomain(block: CreateUserPoolDomainRequest.Builder.() -> Unit) = createUserPoolDomain(CreateUserPoolDomainRequest.Builder().apply(block).build())

    /**
     * Deletes a group.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun deleteGroup(input: DeleteGroupRequest): DeleteGroupResponse

    /**
     * Deletes a group.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun deleteGroup(block: DeleteGroupRequest.Builder.() -> Unit) = deleteGroup(DeleteGroupRequest.Builder().apply(block).build())

    /**
     * Deletes an IdP for a user pool.
     */
    suspend fun deleteIdentityProvider(input: DeleteIdentityProviderRequest): DeleteIdentityProviderResponse

    /**
     * Deletes an IdP for a user pool.
     */
    suspend fun deleteIdentityProvider(block: DeleteIdentityProviderRequest.Builder.() -> Unit) = deleteIdentityProvider(DeleteIdentityProviderRequest.Builder().apply(block).build())

    /**
     * Deletes a resource server.
     */
    suspend fun deleteResourceServer(input: DeleteResourceServerRequest): DeleteResourceServerResponse

    /**
     * Deletes a resource server.
     */
    suspend fun deleteResourceServer(block: DeleteResourceServerRequest.Builder.() -> Unit) = deleteResourceServer(DeleteResourceServerRequest.Builder().apply(block).build())

    /**
     * Allows a user to delete himself or herself.
     */
    suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse

    /**
     * Allows a user to delete himself or herself.
     */
    suspend fun deleteUser(block: DeleteUserRequest.Builder.() -> Unit) = deleteUser(DeleteUserRequest.Builder().apply(block).build())

    /**
     * Deletes the attributes for a user.
     */
    suspend fun deleteUserAttributes(input: DeleteUserAttributesRequest): DeleteUserAttributesResponse

    /**
     * Deletes the attributes for a user.
     */
    suspend fun deleteUserAttributes(block: DeleteUserAttributesRequest.Builder.() -> Unit) = deleteUserAttributes(DeleteUserAttributesRequest.Builder().apply(block).build())

    /**
     * Deletes the specified Amazon Cognito user pool.
     */
    suspend fun deleteUserPool(input: DeleteUserPoolRequest): DeleteUserPoolResponse

    /**
     * Deletes the specified Amazon Cognito user pool.
     */
    suspend fun deleteUserPool(block: DeleteUserPoolRequest.Builder.() -> Unit) = deleteUserPool(DeleteUserPoolRequest.Builder().apply(block).build())

    /**
     * Allows the developer to delete the user pool client.
     */
    suspend fun deleteUserPoolClient(input: DeleteUserPoolClientRequest): DeleteUserPoolClientResponse

    /**
     * Allows the developer to delete the user pool client.
     */
    suspend fun deleteUserPoolClient(block: DeleteUserPoolClientRequest.Builder.() -> Unit) = deleteUserPoolClient(DeleteUserPoolClientRequest.Builder().apply(block).build())

    /**
     * Deletes a domain for a user pool.
     */
    suspend fun deleteUserPoolDomain(input: DeleteUserPoolDomainRequest): DeleteUserPoolDomainResponse

    /**
     * Deletes a domain for a user pool.
     */
    suspend fun deleteUserPoolDomain(block: DeleteUserPoolDomainRequest.Builder.() -> Unit) = deleteUserPoolDomain(DeleteUserPoolDomainRequest.Builder().apply(block).build())

    /**
     * Gets information about a specific IdP.
     */
    suspend fun describeIdentityProvider(input: DescribeIdentityProviderRequest): DescribeIdentityProviderResponse

    /**
     * Gets information about a specific IdP.
     */
    suspend fun describeIdentityProvider(block: DescribeIdentityProviderRequest.Builder.() -> Unit) = describeIdentityProvider(DescribeIdentityProviderRequest.Builder().apply(block).build())

    /**
     * Describes a resource server.
     */
    suspend fun describeResourceServer(input: DescribeResourceServerRequest): DescribeResourceServerResponse

    /**
     * Describes a resource server.
     */
    suspend fun describeResourceServer(block: DescribeResourceServerRequest.Builder.() -> Unit) = describeResourceServer(DescribeResourceServerRequest.Builder().apply(block).build())

    /**
     * Describes the risk configuration.
     */
    suspend fun describeRiskConfiguration(input: DescribeRiskConfigurationRequest): DescribeRiskConfigurationResponse

    /**
     * Describes the risk configuration.
     */
    suspend fun describeRiskConfiguration(block: DescribeRiskConfigurationRequest.Builder.() -> Unit) = describeRiskConfiguration(DescribeRiskConfigurationRequest.Builder().apply(block).build())

    /**
     * Describes the user import job.
     */
    suspend fun describeUserImportJob(input: DescribeUserImportJobRequest): DescribeUserImportJobResponse

    /**
     * Describes the user import job.
     */
    suspend fun describeUserImportJob(block: DescribeUserImportJobRequest.Builder.() -> Unit) = describeUserImportJob(DescribeUserImportJobRequest.Builder().apply(block).build())

    /**
     * Returns the configuration information and metadata of the specified user pool.
     */
    suspend fun describeUserPool(input: DescribeUserPoolRequest): DescribeUserPoolResponse

    /**
     * Returns the configuration information and metadata of the specified user pool.
     */
    suspend fun describeUserPool(block: DescribeUserPoolRequest.Builder.() -> Unit) = describeUserPool(DescribeUserPoolRequest.Builder().apply(block).build())

    /**
     * Client method for returning the configuration information and metadata of the specified user pool app client.
     */
    suspend fun describeUserPoolClient(input: DescribeUserPoolClientRequest): DescribeUserPoolClientResponse

    /**
     * Client method for returning the configuration information and metadata of the specified user pool app client.
     */
    suspend fun describeUserPoolClient(block: DescribeUserPoolClientRequest.Builder.() -> Unit) = describeUserPoolClient(DescribeUserPoolClientRequest.Builder().apply(block).build())

    /**
     * Gets information about a domain.
     */
    suspend fun describeUserPoolDomain(input: DescribeUserPoolDomainRequest): DescribeUserPoolDomainResponse

    /**
     * Gets information about a domain.
     */
    suspend fun describeUserPoolDomain(block: DescribeUserPoolDomainRequest.Builder.() -> Unit) = describeUserPoolDomain(DescribeUserPoolDomainRequest.Builder().apply(block).build())

    /**
     * Forgets the specified device.
     */
    suspend fun forgetDevice(input: ForgetDeviceRequest): ForgetDeviceResponse

    /**
     * Forgets the specified device.
     */
    suspend fun forgetDevice(block: ForgetDeviceRequest.Builder.() -> Unit) = forgetDevice(ForgetDeviceRequest.Builder().apply(block).build())

    /**
     * Calling this API causes a message to be sent to the end user with a confirmation code that is required to change the user's password. For the `Username` parameter, you can use the username or user alias. The method used to send the confirmation code is sent according to the specified AccountRecoverySetting. For more information, see [Recovering User Accounts](https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-recover-a-user-account.html) in the *Amazon Cognito Developer Guide*. If neither a verified phone number nor a verified email exists, an `InvalidParameterException` is thrown. To use the confirmation code for resetting the password, call [ConfirmForgotPassword](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmForgotPassword.html).
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    suspend fun forgotPassword(input: ForgotPasswordRequest): ForgotPasswordResponse

    /**
     * Calling this API causes a message to be sent to the end user with a confirmation code that is required to change the user's password. For the `Username` parameter, you can use the username or user alias. The method used to send the confirmation code is sent according to the specified AccountRecoverySetting. For more information, see [Recovering User Accounts](https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-recover-a-user-account.html) in the *Amazon Cognito Developer Guide*. If neither a verified phone number nor a verified email exists, an `InvalidParameterException` is thrown. To use the confirmation code for resetting the password, call [ConfirmForgotPassword](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmForgotPassword.html).
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    suspend fun forgotPassword(block: ForgotPasswordRequest.Builder.() -> Unit) = forgotPassword(ForgotPasswordRequest.Builder().apply(block).build())

    /**
     * Gets the header information for the comma-separated value (CSV) file to be used as input for the user import job.
     */
    suspend fun getCsvHeader(input: GetCsvHeaderRequest): GetCsvHeaderResponse

    /**
     * Gets the header information for the comma-separated value (CSV) file to be used as input for the user import job.
     */
    suspend fun getCsvHeader(block: GetCsvHeaderRequest.Builder.() -> Unit) = getCsvHeader(GetCsvHeaderRequest.Builder().apply(block).build())

    /**
     * Gets the device.
     */
    suspend fun getDevice(input: GetDeviceRequest): GetDeviceResponse

    /**
     * Gets the device.
     */
    suspend fun getDevice(block: GetDeviceRequest.Builder.() -> Unit) = getDevice(GetDeviceRequest.Builder().apply(block).build())

    /**
     * Gets a group.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun getGroup(input: GetGroupRequest): GetGroupResponse

    /**
     * Gets a group.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun getGroup(block: GetGroupRequest.Builder.() -> Unit) = getGroup(GetGroupRequest.Builder().apply(block).build())

    /**
     * Gets the specified IdP.
     */
    suspend fun getIdentityProviderByIdentifier(input: GetIdentityProviderByIdentifierRequest): GetIdentityProviderByIdentifierResponse

    /**
     * Gets the specified IdP.
     */
    suspend fun getIdentityProviderByIdentifier(block: GetIdentityProviderByIdentifierRequest.Builder.() -> Unit) = getIdentityProviderByIdentifier(GetIdentityProviderByIdentifierRequest.Builder().apply(block).build())

    /**
     * This method takes a user pool ID, and returns the signing certificate.
     */
    suspend fun getSigningCertificate(input: GetSigningCertificateRequest): GetSigningCertificateResponse

    /**
     * This method takes a user pool ID, and returns the signing certificate.
     */
    suspend fun getSigningCertificate(block: GetSigningCertificateRequest.Builder.() -> Unit) = getSigningCertificate(GetSigningCertificateRequest.Builder().apply(block).build())

    /**
     * Gets the user interface (UI) Customization information for a particular app client's app UI, if any such information exists for the client. If nothing is set for the particular client, but there is an existing pool level customization (the app `clientId` is `ALL`), then that information is returned. If nothing is present, then an empty shape is returned.
     */
    suspend fun getUiCustomization(input: GetUiCustomizationRequest): GetUiCustomizationResponse

    /**
     * Gets the user interface (UI) Customization information for a particular app client's app UI, if any such information exists for the client. If nothing is set for the particular client, but there is an existing pool level customization (the app `clientId` is `ALL`), then that information is returned. If nothing is present, then an empty shape is returned.
     */
    suspend fun getUiCustomization(block: GetUiCustomizationRequest.Builder.() -> Unit) = getUiCustomization(GetUiCustomizationRequest.Builder().apply(block).build())

    /**
     * Gets the user attributes and metadata for a user.
     */
    suspend fun getUser(input: GetUserRequest): GetUserResponse

    /**
     * Gets the user attributes and metadata for a user.
     */
    suspend fun getUser(block: GetUserRequest.Builder.() -> Unit) = getUser(GetUserRequest.Builder().apply(block).build())

    /**
     * Generates a user attribute verification code for the specified attribute name. Sends a message to a user with a code that they must return in a VerifyUserAttribute request.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    suspend fun getUserAttributeVerificationCode(input: GetUserAttributeVerificationCodeRequest): GetUserAttributeVerificationCodeResponse

    /**
     * Generates a user attribute verification code for the specified attribute name. Sends a message to a user with a code that they must return in a VerifyUserAttribute request.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    suspend fun getUserAttributeVerificationCode(block: GetUserAttributeVerificationCodeRequest.Builder.() -> Unit) = getUserAttributeVerificationCode(GetUserAttributeVerificationCodeRequest.Builder().apply(block).build())

    /**
     * Gets the user pool multi-factor authentication (MFA) configuration.
     */
    suspend fun getUserPoolMfaConfig(input: GetUserPoolMfaConfigRequest): GetUserPoolMfaConfigResponse

    /**
     * Gets the user pool multi-factor authentication (MFA) configuration.
     */
    suspend fun getUserPoolMfaConfig(block: GetUserPoolMfaConfigRequest.Builder.() -> Unit) = getUserPoolMfaConfig(GetUserPoolMfaConfigRequest.Builder().apply(block).build())

    /**
     * Signs out users from all devices. It also invalidates all refresh tokens that Amazon Cognito has issued to a user. The user's current access and ID tokens remain valid until their expiry. By default, access and ID tokens expire one hour after Amazon Cognito issues them. A user can still use a hosted UI cookie to retrieve new tokens for the duration of the cookie validity period of 1 hour.
     */
    suspend fun globalSignOut(input: GlobalSignOutRequest): GlobalSignOutResponse

    /**
     * Signs out users from all devices. It also invalidates all refresh tokens that Amazon Cognito has issued to a user. The user's current access and ID tokens remain valid until their expiry. By default, access and ID tokens expire one hour after Amazon Cognito issues them. A user can still use a hosted UI cookie to retrieve new tokens for the duration of the cookie validity period of 1 hour.
     */
    suspend fun globalSignOut(block: GlobalSignOutRequest.Builder.() -> Unit) = globalSignOut(GlobalSignOutRequest.Builder().apply(block).build())

    /**
     * Initiates sign-in for a user in the Amazon Cognito user directory. You can't sign in a user with a federated IdP with `InitiateAuth`. For more information, see [ Adding user pool sign-in through a third party](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation.html).
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    suspend fun initiateAuth(input: InitiateAuthRequest): InitiateAuthResponse

    /**
     * Initiates sign-in for a user in the Amazon Cognito user directory. You can't sign in a user with a federated IdP with `InitiateAuth`. For more information, see [ Adding user pool sign-in through a third party](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation.html).
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    suspend fun initiateAuth(block: InitiateAuthRequest.Builder.() -> Unit) = initiateAuth(InitiateAuthRequest.Builder().apply(block).build())

    /**
     * Lists the sign-in devices that Amazon Cognito has registered to the current user.
     */
    suspend fun listDevices(input: ListDevicesRequest): ListDevicesResponse

    /**
     * Lists the sign-in devices that Amazon Cognito has registered to the current user.
     */
    suspend fun listDevices(block: ListDevicesRequest.Builder.() -> Unit) = listDevices(ListDevicesRequest.Builder().apply(block).build())

    /**
     * Lists the groups associated with a user pool.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun listGroups(input: ListGroupsRequest): ListGroupsResponse

    /**
     * Lists the groups associated with a user pool.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun listGroups(block: ListGroupsRequest.Builder.() -> Unit) = listGroups(ListGroupsRequest.Builder().apply(block).build())

    /**
     * Lists information about all IdPs for a user pool.
     */
    suspend fun listIdentityProviders(input: ListIdentityProvidersRequest): ListIdentityProvidersResponse

    /**
     * Lists information about all IdPs for a user pool.
     */
    suspend fun listIdentityProviders(block: ListIdentityProvidersRequest.Builder.() -> Unit) = listIdentityProviders(ListIdentityProvidersRequest.Builder().apply(block).build())

    /**
     * Lists the resource servers for a user pool.
     */
    suspend fun listResourceServers(input: ListResourceServersRequest): ListResourceServersResponse

    /**
     * Lists the resource servers for a user pool.
     */
    suspend fun listResourceServers(block: ListResourceServersRequest.Builder.() -> Unit) = listResourceServers(ListResourceServersRequest.Builder().apply(block).build())

    /**
     * Lists the tags that are assigned to an Amazon Cognito user pool.
     *
     * A tag is a label that you can apply to user pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.
     *
     * You can use this action up to 10 times per second, per account.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the tags that are assigned to an Amazon Cognito user pool.
     *
     * A tag is a label that you can apply to user pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.
     *
     * You can use this action up to 10 times per second, per account.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Lists the user import jobs.
     */
    suspend fun listUserImportJobs(input: ListUserImportJobsRequest): ListUserImportJobsResponse

    /**
     * Lists the user import jobs.
     */
    suspend fun listUserImportJobs(block: ListUserImportJobsRequest.Builder.() -> Unit) = listUserImportJobs(ListUserImportJobsRequest.Builder().apply(block).build())

    /**
     * Lists the clients that have been created for the specified user pool.
     */
    suspend fun listUserPoolClients(input: ListUserPoolClientsRequest): ListUserPoolClientsResponse

    /**
     * Lists the clients that have been created for the specified user pool.
     */
    suspend fun listUserPoolClients(block: ListUserPoolClientsRequest.Builder.() -> Unit) = listUserPoolClients(ListUserPoolClientsRequest.Builder().apply(block).build())

    /**
     * Lists the user pools associated with an Amazon Web Services account.
     */
    suspend fun listUserPools(input: ListUserPoolsRequest): ListUserPoolsResponse

    /**
     * Lists the user pools associated with an Amazon Web Services account.
     */
    suspend fun listUserPools(block: ListUserPoolsRequest.Builder.() -> Unit) = listUserPools(ListUserPoolsRequest.Builder().apply(block).build())

    /**
     * Lists the users in the Amazon Cognito user pool.
     */
    suspend fun listUsers(input: ListUsersRequest): ListUsersResponse

    /**
     * Lists the users in the Amazon Cognito user pool.
     */
    suspend fun listUsers(block: ListUsersRequest.Builder.() -> Unit) = listUsers(ListUsersRequest.Builder().apply(block).build())

    /**
     * Lists the users in the specified group.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun listUsersInGroup(input: ListUsersInGroupRequest): ListUsersInGroupResponse

    /**
     * Lists the users in the specified group.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun listUsersInGroup(block: ListUsersInGroupRequest.Builder.() -> Unit) = listUsersInGroup(ListUsersInGroupRequest.Builder().apply(block).build())

    /**
     * Resends the confirmation (for confirmation of registration) to a specific user in the user pool.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    suspend fun resendConfirmationCode(input: ResendConfirmationCodeRequest): ResendConfirmationCodeResponse

    /**
     * Resends the confirmation (for confirmation of registration) to a specific user in the user pool.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    suspend fun resendConfirmationCode(block: ResendConfirmationCodeRequest.Builder.() -> Unit) = resendConfirmationCode(ResendConfirmationCodeRequest.Builder().apply(block).build())

    /**
     * Responds to the authentication challenge.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    suspend fun respondToAuthChallenge(input: RespondToAuthChallengeRequest): RespondToAuthChallengeResponse

    /**
     * Responds to the authentication challenge.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    suspend fun respondToAuthChallenge(block: RespondToAuthChallengeRequest.Builder.() -> Unit) = respondToAuthChallenge(RespondToAuthChallengeRequest.Builder().apply(block).build())

    /**
     * Revokes all of the access tokens generated by the specified refresh token. After the token is revoked, you can't use the revoked token to access Amazon Cognito authenticated APIs.
     */
    suspend fun revokeToken(input: RevokeTokenRequest): RevokeTokenResponse

    /**
     * Revokes all of the access tokens generated by the specified refresh token. After the token is revoked, you can't use the revoked token to access Amazon Cognito authenticated APIs.
     */
    suspend fun revokeToken(block: RevokeTokenRequest.Builder.() -> Unit) = revokeToken(RevokeTokenRequest.Builder().apply(block).build())

    /**
     * Configures actions on detected risks. To delete the risk configuration for `UserPoolId` or `ClientId`, pass null values for all four configuration types.
     *
     * To activate Amazon Cognito advanced security features, update the user pool to include the `UserPoolAddOns` key`AdvancedSecurityMode`.
     */
    suspend fun setRiskConfiguration(input: SetRiskConfigurationRequest): SetRiskConfigurationResponse

    /**
     * Configures actions on detected risks. To delete the risk configuration for `UserPoolId` or `ClientId`, pass null values for all four configuration types.
     *
     * To activate Amazon Cognito advanced security features, update the user pool to include the `UserPoolAddOns` key`AdvancedSecurityMode`.
     */
    suspend fun setRiskConfiguration(block: SetRiskConfigurationRequest.Builder.() -> Unit) = setRiskConfiguration(SetRiskConfigurationRequest.Builder().apply(block).build())

    /**
     * Sets the user interface (UI) customization information for a user pool's built-in app UI.
     *
     * You can specify app UI customization settings for a single client (with a specific `clientId`) or for all clients (by setting the `clientId` to `ALL`). If you specify `ALL`, the default configuration is used for every client that has no previously set UI customization. If you specify UI customization settings for a particular client, it will no longer return to the `ALL` configuration.
     *
     * To use this API, your user pool must have a domain associated with it. Otherwise, there is no place to host the app's pages, and the service will throw an error.
     */
    suspend fun setUiCustomization(input: SetUiCustomizationRequest): SetUiCustomizationResponse

    /**
     * Sets the user interface (UI) customization information for a user pool's built-in app UI.
     *
     * You can specify app UI customization settings for a single client (with a specific `clientId`) or for all clients (by setting the `clientId` to `ALL`). If you specify `ALL`, the default configuration is used for every client that has no previously set UI customization. If you specify UI customization settings for a particular client, it will no longer return to the `ALL` configuration.
     *
     * To use this API, your user pool must have a domain associated with it. Otherwise, there is no place to host the app's pages, and the service will throw an error.
     */
    suspend fun setUiCustomization(block: SetUiCustomizationRequest.Builder.() -> Unit) = setUiCustomization(SetUiCustomizationRequest.Builder().apply(block).build())

    /**
     * Set the user's multi-factor authentication (MFA) method preference, including which MFA factors are activated and if any are preferred. Only one factor can be set as preferred. The preferred MFA factor will be used to authenticate a user if multiple factors are activated. If multiple options are activated and no preference is set, a challenge to choose an MFA option will be returned during sign-in. If an MFA type is activated for a user, the user will be prompted for MFA during all sign-in attempts unless device tracking is turned on and the device has been trusted. If you want MFA to be applied selectively based on the assessed risk level of sign-in attempts, deactivate MFA for users and turn on Adaptive Authentication for the user pool.
     */
    suspend fun setUserMfaPreference(input: SetUserMfaPreferenceRequest): SetUserMfaPreferenceResponse

    /**
     * Set the user's multi-factor authentication (MFA) method preference, including which MFA factors are activated and if any are preferred. Only one factor can be set as preferred. The preferred MFA factor will be used to authenticate a user if multiple factors are activated. If multiple options are activated and no preference is set, a challenge to choose an MFA option will be returned during sign-in. If an MFA type is activated for a user, the user will be prompted for MFA during all sign-in attempts unless device tracking is turned on and the device has been trusted. If you want MFA to be applied selectively based on the assessed risk level of sign-in attempts, deactivate MFA for users and turn on Adaptive Authentication for the user pool.
     */
    suspend fun setUserMfaPreference(block: SetUserMfaPreferenceRequest.Builder.() -> Unit) = setUserMfaPreference(SetUserMfaPreferenceRequest.Builder().apply(block).build())

    /**
     * Sets the user pool multi-factor authentication (MFA) configuration.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    suspend fun setUserPoolMfaConfig(input: SetUserPoolMfaConfigRequest): SetUserPoolMfaConfigResponse

    /**
     * Sets the user pool multi-factor authentication (MFA) configuration.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    suspend fun setUserPoolMfaConfig(block: SetUserPoolMfaConfigRequest.Builder.() -> Unit) = setUserPoolMfaConfig(SetUserPoolMfaConfigRequest.Builder().apply(block).build())

    /**
     * *This action is no longer supported.* You can use it to configure only SMS MFA. You can't use it to configure time-based one-time password (TOTP) software token MFA. To configure either type of MFA, use [SetUserMFAPreference](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUserMFAPreference.html) instead.
     */
    suspend fun setUserSettings(input: SetUserSettingsRequest): SetUserSettingsResponse

    /**
     * *This action is no longer supported.* You can use it to configure only SMS MFA. You can't use it to configure time-based one-time password (TOTP) software token MFA. To configure either type of MFA, use [SetUserMFAPreference](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUserMFAPreference.html) instead.
     */
    suspend fun setUserSettings(block: SetUserSettingsRequest.Builder.() -> Unit) = setUserSettings(SetUserSettingsRequest.Builder().apply(block).build())

    /**
     * Registers the user in the specified user pool and creates a user name, password, and user attributes.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    suspend fun signUp(input: SignUpRequest): SignUpResponse

    /**
     * Registers the user in the specified user pool and creates a user name, password, and user attributes.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    suspend fun signUp(block: SignUpRequest.Builder.() -> Unit) = signUp(SignUpRequest.Builder().apply(block).build())

    /**
     * Starts the user import.
     */
    suspend fun startUserImportJob(input: StartUserImportJobRequest): StartUserImportJobResponse

    /**
     * Starts the user import.
     */
    suspend fun startUserImportJob(block: StartUserImportJobRequest.Builder.() -> Unit) = startUserImportJob(StartUserImportJobRequest.Builder().apply(block).build())

    /**
     * Stops the user import job.
     */
    suspend fun stopUserImportJob(input: StopUserImportJobRequest): StopUserImportJobResponse

    /**
     * Stops the user import job.
     */
    suspend fun stopUserImportJob(block: StopUserImportJobRequest.Builder.() -> Unit) = stopUserImportJob(StopUserImportJobRequest.Builder().apply(block).build())

    /**
     * Assigns a set of tags to an Amazon Cognito user pool. A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.
     *
     * Each tag consists of a key and value, both of which you define. A key is a general category for more specific values. For example, if you have two versions of a user pool, one for testing and another for production, you might assign an `Environment` tag key to both user pools. The value of this key might be `Test` for one user pool, and `Production` for the other.
     *
     * Tags are useful for cost tracking and access control. You can activate your tags so that they appear on the Billing and Cost Management console, where you can track the costs associated with your user pools. In an Identity and Access Management policy, you can constrain permissions for user pools based on specific tags or tag values.
     *
     * You can use this action up to 5 times per second, per account. A user pool can have as many as 50 tags.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Assigns a set of tags to an Amazon Cognito user pool. A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.
     *
     * Each tag consists of a key and value, both of which you define. A key is a general category for more specific values. For example, if you have two versions of a user pool, one for testing and another for production, you might assign an `Environment` tag key to both user pools. The value of this key might be `Test` for one user pool, and `Production` for the other.
     *
     * Tags are useful for cost tracking and access control. You can activate your tags so that they appear on the Billing and Cost Management console, where you can track the costs associated with your user pools. In an Identity and Access Management policy, you can constrain permissions for user pools based on specific tags or tag values.
     *
     * You can use this action up to 5 times per second, per account. A user pool can have as many as 50 tags.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Removes the specified tags from an Amazon Cognito user pool. You can use this action up to 5 times per second, per account.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes the specified tags from an Amazon Cognito user pool. You can use this action up to 5 times per second, per account.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Provides the feedback for an authentication event, whether it was from a valid user or not. This feedback is used for improving the risk evaluation decision for the user pool as part of Amazon Cognito advanced security.
     */
    suspend fun updateAuthEventFeedback(input: UpdateAuthEventFeedbackRequest): UpdateAuthEventFeedbackResponse

    /**
     * Provides the feedback for an authentication event, whether it was from a valid user or not. This feedback is used for improving the risk evaluation decision for the user pool as part of Amazon Cognito advanced security.
     */
    suspend fun updateAuthEventFeedback(block: UpdateAuthEventFeedbackRequest.Builder.() -> Unit) = updateAuthEventFeedback(UpdateAuthEventFeedbackRequest.Builder().apply(block).build())

    /**
     * Updates the device status.
     */
    suspend fun updateDeviceStatus(input: UpdateDeviceStatusRequest): UpdateDeviceStatusResponse

    /**
     * Updates the device status.
     */
    suspend fun updateDeviceStatus(block: UpdateDeviceStatusRequest.Builder.() -> Unit) = updateDeviceStatus(UpdateDeviceStatusRequest.Builder().apply(block).build())

    /**
     * Updates the specified group with the specified attributes.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun updateGroup(input: UpdateGroupRequest): UpdateGroupResponse

    /**
     * Updates the specified group with the specified attributes.
     *
     * Calling this action requires developer credentials.
     */
    suspend fun updateGroup(block: UpdateGroupRequest.Builder.() -> Unit) = updateGroup(UpdateGroupRequest.Builder().apply(block).build())

    /**
     * Updates IdP information for a user pool.
     */
    suspend fun updateIdentityProvider(input: UpdateIdentityProviderRequest): UpdateIdentityProviderResponse

    /**
     * Updates IdP information for a user pool.
     */
    suspend fun updateIdentityProvider(block: UpdateIdentityProviderRequest.Builder.() -> Unit) = updateIdentityProvider(UpdateIdentityProviderRequest.Builder().apply(block).build())

    /**
     * Updates the name and scopes of resource server. All other fields are read-only.
     *
     * If you don't provide a value for an attribute, it is set to the default value.
     */
    suspend fun updateResourceServer(input: UpdateResourceServerRequest): UpdateResourceServerResponse

    /**
     * Updates the name and scopes of resource server. All other fields are read-only.
     *
     * If you don't provide a value for an attribute, it is set to the default value.
     */
    suspend fun updateResourceServer(block: UpdateResourceServerRequest.Builder.() -> Unit) = updateResourceServer(UpdateResourceServerRequest.Builder().apply(block).build())

    /**
     * Allows a user to update a specific attribute (one at a time).
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    suspend fun updateUserAttributes(input: UpdateUserAttributesRequest): UpdateUserAttributesResponse

    /**
     * Allows a user to update a specific attribute (one at a time).
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    suspend fun updateUserAttributes(block: UpdateUserAttributesRequest.Builder.() -> Unit) = updateUserAttributes(UpdateUserAttributesRequest.Builder().apply(block).build())

    /**
     * Updates the specified user pool with the specified attributes. You can get a list of the current user pool settings using [DescribeUserPool](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html). If you don't provide a value for an attribute, it will be set to the default value.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    suspend fun updateUserPool(input: UpdateUserPoolRequest): UpdateUserPoolResponse

    /**
     * Updates the specified user pool with the specified attributes. You can get a list of the current user pool settings using [DescribeUserPool](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html). If you don't provide a value for an attribute, it will be set to the default value.
     *
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with [Amazon Pinpoint](https://console.aws.amazon.com/pinpoint/home/). Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.
     *
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place your account in the SMS sandbox. In *[sandbox mode](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html)*, you can send messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move out of the sandbox and into production. For more information, see [ SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html) in the *Amazon Cognito Developer Guide*.
     */
    suspend fun updateUserPool(block: UpdateUserPoolRequest.Builder.() -> Unit) = updateUserPool(UpdateUserPoolRequest.Builder().apply(block).build())

    /**
     * Updates the specified user pool app client with the specified attributes. You can get a list of the current user pool app client settings using [DescribeUserPoolClient](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPoolClient.html).
     *
     * If you don't provide a value for an attribute, it will be set to the default value.
     *
     * You can also use this operation to enable token revocation for user pool clients. For more information about revoking tokens, see [RevokeToken](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html).
     */
    suspend fun updateUserPoolClient(input: UpdateUserPoolClientRequest): UpdateUserPoolClientResponse

    /**
     * Updates the specified user pool app client with the specified attributes. You can get a list of the current user pool app client settings using [DescribeUserPoolClient](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPoolClient.html).
     *
     * If you don't provide a value for an attribute, it will be set to the default value.
     *
     * You can also use this operation to enable token revocation for user pool clients. For more information about revoking tokens, see [RevokeToken](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html).
     */
    suspend fun updateUserPoolClient(block: UpdateUserPoolClientRequest.Builder.() -> Unit) = updateUserPoolClient(UpdateUserPoolClientRequest.Builder().apply(block).build())

    /**
     * Updates the Secure Sockets Layer (SSL) certificate for the custom domain for your user pool.
     *
     * You can use this operation to provide the Amazon Resource Name (ARN) of a new certificate to Amazon Cognito. You can't use it to change the domain for a user pool.
     *
     * A custom domain is used to host the Amazon Cognito hosted UI, which provides sign-up and sign-in pages for your application. When you set up a custom domain, you provide a certificate that you manage with Certificate Manager (ACM). When necessary, you can use this operation to change the certificate that you applied to your custom domain.
     *
     * Usually, this is unnecessary following routine certificate renewal with ACM. When you renew your existing certificate in ACM, the ARN for your certificate remains the same, and your custom domain uses the new certificate automatically.
     *
     * However, if you replace your existing certificate with a new one, ACM gives the new certificate a new ARN. To apply the new certificate to your custom domain, you must provide this ARN to Amazon Cognito.
     *
     * When you add your new certificate in ACM, you must choose US East (N. Virginia) as the Amazon Web Services Region.
     *
     * After you submit your request, Amazon Cognito requires up to 1 hour to distribute your new certificate to your custom domain.
     *
     * For more information about adding a custom domain to your user pool, see [Using Your Own Domain for the Hosted UI](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html).
     */
    suspend fun updateUserPoolDomain(input: UpdateUserPoolDomainRequest): UpdateUserPoolDomainResponse

    /**
     * Updates the Secure Sockets Layer (SSL) certificate for the custom domain for your user pool.
     *
     * You can use this operation to provide the Amazon Resource Name (ARN) of a new certificate to Amazon Cognito. You can't use it to change the domain for a user pool.
     *
     * A custom domain is used to host the Amazon Cognito hosted UI, which provides sign-up and sign-in pages for your application. When you set up a custom domain, you provide a certificate that you manage with Certificate Manager (ACM). When necessary, you can use this operation to change the certificate that you applied to your custom domain.
     *
     * Usually, this is unnecessary following routine certificate renewal with ACM. When you renew your existing certificate in ACM, the ARN for your certificate remains the same, and your custom domain uses the new certificate automatically.
     *
     * However, if you replace your existing certificate with a new one, ACM gives the new certificate a new ARN. To apply the new certificate to your custom domain, you must provide this ARN to Amazon Cognito.
     *
     * When you add your new certificate in ACM, you must choose US East (N. Virginia) as the Amazon Web Services Region.
     *
     * After you submit your request, Amazon Cognito requires up to 1 hour to distribute your new certificate to your custom domain.
     *
     * For more information about adding a custom domain to your user pool, see [Using Your Own Domain for the Hosted UI](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html).
     */
    suspend fun updateUserPoolDomain(block: UpdateUserPoolDomainRequest.Builder.() -> Unit) = updateUserPoolDomain(UpdateUserPoolDomainRequest.Builder().apply(block).build())

    /**
     * Use this API to register a user's entered time-based one-time password (TOTP) code and mark the user's software token MFA status as "verified" if successful. The request takes an access token or a session string, but not both.
     */
    suspend fun verifySoftwareToken(input: VerifySoftwareTokenRequest): VerifySoftwareTokenResponse

    /**
     * Use this API to register a user's entered time-based one-time password (TOTP) code and mark the user's software token MFA status as "verified" if successful. The request takes an access token or a session string, but not both.
     */
    suspend fun verifySoftwareToken(block: VerifySoftwareTokenRequest.Builder.() -> Unit) = verifySoftwareToken(VerifySoftwareTokenRequest.Builder().apply(block).build())

    /**
     * Verifies the specified user attributes in the user pool.
     *
     *  If your user pool requires verification before Amazon Cognito updates the attribute value, VerifyUserAttribute updates the affected attribute to its pending value. For more information, see [ UserAttributeUpdateSettingsType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UserAttributeUpdateSettingsType.html).
     */
    suspend fun verifyUserAttribute(input: VerifyUserAttributeRequest): VerifyUserAttributeResponse

    /**
     * Verifies the specified user attributes in the user pool.
     *
     *  If your user pool requires verification before Amazon Cognito updates the attribute value, VerifyUserAttribute updates the affected attribute to its pending value. For more information, see [ UserAttributeUpdateSettingsType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UserAttributeUpdateSettingsType.html).
     */
    suspend fun verifyUserAttribute(block: VerifyUserAttributeRequest.Builder.() -> Unit) = verifyUserAttribute(VerifyUserAttributeRequest.Builder().apply(block).build())
}
