// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.serde

import aws.sdk.kotlin.services.cognitoidentityprovider.model.CognitoIdentityProviderException
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ListUserImportJobsResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.UserImportJobType
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListUserImportJobsOperationDeserializer: HttpDeserializer.NonStreaming<ListUserImportJobsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ListUserImportJobsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListUserImportJobsError(context, call, payload)
        }
        val builder = ListUserImportJobsResponse.Builder()

        if (payload != null) {
            deserializeListUserImportJobsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwListUserImportJobsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CognitoIdentityProviderException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotAuthorizedException" -> NotAuthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CognitoIdentityProviderException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListUserImportJobsOperationBody(builder: ListUserImportJobsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PAGINATIONTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PaginationToken"))
    val USERIMPORTJOBS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("UserImportJobs"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PAGINATIONTOKEN_DESCRIPTOR)
        field(USERIMPORTJOBS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PAGINATIONTOKEN_DESCRIPTOR.index -> builder.paginationToken = deserializeString()
                USERIMPORTJOBS_DESCRIPTOR.index -> builder.userImportJobs =
                    deserializer.deserializeList(USERIMPORTJOBS_DESCRIPTOR) {
                        val col0 = mutableListOf<UserImportJobType>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUserImportJobTypeDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
