// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.serde

import aws.sdk.kotlin.services.cognitoidentityprovider.model.CognitoIdentityProviderException
import aws.sdk.kotlin.services.cognitoidentityprovider.model.GlobalSignOutResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class GlobalSignOutOperationDeserializer: HttpDeserializer.NonStreaming<GlobalSignOutResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GlobalSignOutResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGlobalSignOutError(context, call, payload)
        }
        val builder = GlobalSignOutResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGlobalSignOutError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CognitoIdentityProviderException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PasswordResetRequiredException" -> PasswordResetRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UserNotConfirmedException" -> UserNotConfirmedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotAuthorizedException" -> NotAuthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CognitoIdentityProviderException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
