// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.serde

import aws.sdk.kotlin.services.cognitoidentityprovider.model.CognitoIdentityProviderException
import aws.sdk.kotlin.services.cognitoidentityprovider.model.GetUserPoolMfaConfigResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.SmsMfaConfigType
import aws.sdk.kotlin.services.cognitoidentityprovider.model.SoftwareTokenMfaConfigType
import aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolMfaType
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetUserPoolMfaConfigOperationDeserializer: HttpDeserializer.NonStreaming<GetUserPoolMfaConfigResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetUserPoolMfaConfigResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetUserPoolMfaConfigError(context, call, payload)
        }
        val builder = GetUserPoolMfaConfigResponse.Builder()

        if (payload != null) {
            deserializeGetUserPoolMfaConfigOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetUserPoolMfaConfigError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CognitoIdentityProviderException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotAuthorizedException" -> NotAuthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CognitoIdentityProviderException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetUserPoolMfaConfigOperationBody(builder: GetUserPoolMfaConfigResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val MFACONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("MfaConfiguration"))
    val SMSMFACONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SmsMfaConfiguration"))
    val SOFTWARETOKENMFACONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SoftwareTokenMfaConfiguration"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MFACONFIGURATION_DESCRIPTOR)
        field(SMSMFACONFIGURATION_DESCRIPTOR)
        field(SOFTWARETOKENMFACONFIGURATION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MFACONFIGURATION_DESCRIPTOR.index -> builder.mfaConfiguration = deserializeString().let { UserPoolMfaType.fromValue(it) }
                SMSMFACONFIGURATION_DESCRIPTOR.index -> builder.smsMfaConfiguration = deserializeSmsMfaConfigTypeDocument(deserializer)
                SOFTWARETOKENMFACONFIGURATION_DESCRIPTOR.index -> builder.softwareTokenMfaConfiguration = deserializeSoftwareTokenMfaConfigTypeDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
