// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.serde

import aws.sdk.kotlin.services.cognitoidentityprovider.model.AttributeType
import aws.sdk.kotlin.services.cognitoidentityprovider.model.CognitoIdentityProviderException
import aws.sdk.kotlin.services.cognitoidentityprovider.model.GetUserResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.MfaOptionType
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetUserOperationDeserializer: HttpDeserializer.NonStreaming<GetUserResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetUserResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetUserError(context, call, payload)
        }
        val builder = GetUserResponse.Builder()

        if (payload != null) {
            deserializeGetUserOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetUserError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CognitoIdentityProviderException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PasswordResetRequiredException" -> PasswordResetRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UserNotFoundException" -> UserNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UserNotConfirmedException" -> UserNotConfirmedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotAuthorizedException" -> NotAuthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CognitoIdentityProviderException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetUserOperationBody(builder: GetUserResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val MFAOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("MFAOptions"))
    val PREFERREDMFASETTING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PreferredMfaSetting"))
    val USERATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("UserAttributes"))
    val USERMFASETTINGLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("UserMFASettingList"))
    val USERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Username"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MFAOPTIONS_DESCRIPTOR)
        field(PREFERREDMFASETTING_DESCRIPTOR)
        field(USERATTRIBUTES_DESCRIPTOR)
        field(USERMFASETTINGLIST_DESCRIPTOR)
        field(USERNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MFAOPTIONS_DESCRIPTOR.index -> builder.mfaOptions =
                    deserializer.deserializeList(MFAOPTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<MfaOptionType>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeMfaOptionTypeDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PREFERREDMFASETTING_DESCRIPTOR.index -> builder.preferredMfaSetting = deserializeString()
                USERATTRIBUTES_DESCRIPTOR.index -> builder.userAttributes =
                    deserializer.deserializeList(USERATTRIBUTES_DESCRIPTOR) {
                        val col0 = mutableListOf<AttributeType>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAttributeTypeDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                USERMFASETTINGLIST_DESCRIPTOR.index -> builder.userMfaSettingList =
                    deserializer.deserializeList(USERMFASETTINGLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                USERNAME_DESCRIPTOR.index -> builder.username = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
