// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.serde

import aws.sdk.kotlin.services.cognitoidentityprovider.model.CognitoIdentityProviderException
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ConfirmForgotPasswordResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class ConfirmForgotPasswordOperationDeserializer: HttpDeserializer.NonStreaming<ConfirmForgotPasswordResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ConfirmForgotPasswordResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwConfirmForgotPasswordError(context, call, payload)
        }
        val builder = ConfirmForgotPasswordResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwConfirmForgotPasswordError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CognitoIdentityProviderException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "UnexpectedLambdaException" -> UnexpectedLambdaExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyFailedAttemptsException" -> TooManyFailedAttemptsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UserNotConfirmedException" -> UserNotConfirmedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotAuthorizedException" -> NotAuthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidLambdaResponseException" -> InvalidLambdaResponseExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ExpiredCodeException" -> ExpiredCodeExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UserNotFoundException" -> UserNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UserLambdaValidationException" -> UserLambdaValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidPasswordException" -> InvalidPasswordExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CodeMismatchException" -> CodeMismatchExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CognitoIdentityProviderException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
