// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.serde

import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminUpdateUserAttributesResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.CognitoIdentityProviderException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class AdminUpdateUserAttributesOperationDeserializer: HttpDeserializer.NonStreaming<AdminUpdateUserAttributesResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): AdminUpdateUserAttributesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwAdminUpdateUserAttributesError(context, call, payload)
        }
        val builder = AdminUpdateUserAttributesResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwAdminUpdateUserAttributesError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CognitoIdentityProviderException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "UnexpectedLambdaException" -> UnexpectedLambdaExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotAuthorizedException" -> NotAuthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidEmailRoleAccessPolicyException" -> InvalidEmailRoleAccessPolicyExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidLambdaResponseException" -> InvalidLambdaResponseExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidSmsRoleTrustRelationshipException" -> InvalidSmsRoleTrustRelationshipExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AliasExistsException" -> AliasExistsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidSmsRoleAccessPolicyException" -> InvalidSmsRoleAccessPolicyExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UserNotFoundException" -> UserNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UserLambdaValidationException" -> UserLambdaValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CognitoIdentityProviderException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
