// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.paginators

import aws.sdk.kotlin.services.cognitoidentityprovider.CognitoIdentityProviderClient
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminListGroupsForUserRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminListGroupsForUserResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminListUserAuthEventsRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminListUserAuthEventsResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AuthEventType
import aws.sdk.kotlin.services.cognitoidentityprovider.model.GroupType
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ListGroupsRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ListGroupsResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ListIdentityProvidersRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ListIdentityProvidersResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ListResourceServersRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ListResourceServersResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ListUserPoolClientsRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ListUserPoolClientsResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ListUserPoolsRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ListUserPoolsResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ListUsersInGroupRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ListUsersInGroupResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ListUsersRequest
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ListUsersResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ProviderDescription
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ResourceServerType
import aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolClientDescription
import aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolDescriptionType
import aws.sdk.kotlin.services.cognitoidentityprovider.model.UserType
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [AdminListGroupsForUserResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [AdminListGroupsForUserRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AdminListGroupsForUserResponse]
 */
public fun CognitoIdentityProviderClient.adminListGroupsForUserPaginated(initialRequest: AdminListGroupsForUserRequest): Flow<AdminListGroupsForUserResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@adminListGroupsForUserPaginated.adminListGroupsForUser(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [AdminListGroupsForUserResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AdminListGroupsForUserResponse]
 */
public fun CognitoIdentityProviderClient.adminListGroupsForUserPaginated(block: AdminListGroupsForUserRequest.Builder.() -> Unit): Flow<AdminListGroupsForUserResponse> =
    adminListGroupsForUserPaginated(AdminListGroupsForUserRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [adminListGroupsForUserPaginated]
 * to access the nested member [GroupType]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GroupType]
 */
@JvmName("adminListGroupsForUserResponseGroupType")
public fun Flow<AdminListGroupsForUserResponse>.groups(): Flow<GroupType> =
    transform() { response ->
        response.groups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [AdminListUserAuthEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [AdminListUserAuthEventsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AdminListUserAuthEventsResponse]
 */
public fun CognitoIdentityProviderClient.adminListUserAuthEventsPaginated(initialRequest: AdminListUserAuthEventsRequest): Flow<AdminListUserAuthEventsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@adminListUserAuthEventsPaginated.adminListUserAuthEvents(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [AdminListUserAuthEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AdminListUserAuthEventsResponse]
 */
public fun CognitoIdentityProviderClient.adminListUserAuthEventsPaginated(block: AdminListUserAuthEventsRequest.Builder.() -> Unit): Flow<AdminListUserAuthEventsResponse> =
    adminListUserAuthEventsPaginated(AdminListUserAuthEventsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [adminListUserAuthEventsPaginated]
 * to access the nested member [AuthEventType]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AuthEventType]
 */
@JvmName("adminListUserAuthEventsResponseAuthEventType")
public fun Flow<AdminListUserAuthEventsResponse>.authEvents(): Flow<AuthEventType> =
    transform() { response ->
        response.authEvents?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGroupsResponse]
 */
public fun CognitoIdentityProviderClient.listGroupsPaginated(initialRequest: ListGroupsRequest): Flow<ListGroupsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listGroupsPaginated.listGroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGroupsResponse]
 */
public fun CognitoIdentityProviderClient.listGroupsPaginated(block: ListGroupsRequest.Builder.() -> Unit): Flow<ListGroupsResponse> =
    listGroupsPaginated(ListGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listGroupsPaginated]
 * to access the nested member [GroupType]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GroupType]
 */
@JvmName("listGroupsResponseGroupType")
public fun Flow<ListGroupsResponse>.groups(): Flow<GroupType> =
    transform() { response ->
        response.groups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListIdentityProvidersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListIdentityProvidersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIdentityProvidersResponse]
 */
public fun CognitoIdentityProviderClient.listIdentityProvidersPaginated(initialRequest: ListIdentityProvidersRequest): Flow<ListIdentityProvidersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listIdentityProvidersPaginated.listIdentityProviders(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListIdentityProvidersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIdentityProvidersResponse]
 */
public fun CognitoIdentityProviderClient.listIdentityProvidersPaginated(block: ListIdentityProvidersRequest.Builder.() -> Unit): Flow<ListIdentityProvidersResponse> =
    listIdentityProvidersPaginated(ListIdentityProvidersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listIdentityProvidersPaginated]
 * to access the nested member [ProviderDescription]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ProviderDescription]
 */
@JvmName("listIdentityProvidersResponseProviderDescription")
public fun Flow<ListIdentityProvidersResponse>.providers(): Flow<ProviderDescription> =
    transform() { response ->
        response.providers?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListResourceServersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResourceServersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResourceServersResponse]
 */
public fun CognitoIdentityProviderClient.listResourceServersPaginated(initialRequest: ListResourceServersRequest): Flow<ListResourceServersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listResourceServersPaginated.listResourceServers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListResourceServersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResourceServersResponse]
 */
public fun CognitoIdentityProviderClient.listResourceServersPaginated(block: ListResourceServersRequest.Builder.() -> Unit): Flow<ListResourceServersResponse> =
    listResourceServersPaginated(ListResourceServersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listResourceServersPaginated]
 * to access the nested member [ResourceServerType]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ResourceServerType]
 */
@JvmName("listResourceServersResponseResourceServerType")
public fun Flow<ListResourceServersResponse>.resourceServers(): Flow<ResourceServerType> =
    transform() { response ->
        response.resourceServers?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListUserPoolClientsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListUserPoolClientsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUserPoolClientsResponse]
 */
public fun CognitoIdentityProviderClient.listUserPoolClientsPaginated(initialRequest: ListUserPoolClientsRequest): Flow<ListUserPoolClientsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listUserPoolClientsPaginated.listUserPoolClients(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListUserPoolClientsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUserPoolClientsResponse]
 */
public fun CognitoIdentityProviderClient.listUserPoolClientsPaginated(block: ListUserPoolClientsRequest.Builder.() -> Unit): Flow<ListUserPoolClientsResponse> =
    listUserPoolClientsPaginated(ListUserPoolClientsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listUserPoolClientsPaginated]
 * to access the nested member [UserPoolClientDescription]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [UserPoolClientDescription]
 */
@JvmName("listUserPoolClientsResponseUserPoolClientDescription")
public fun Flow<ListUserPoolClientsResponse>.userPoolClients(): Flow<UserPoolClientDescription> =
    transform() { response ->
        response.userPoolClients?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListUserPoolsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListUserPoolsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUserPoolsResponse]
 */
public fun CognitoIdentityProviderClient.listUserPoolsPaginated(initialRequest: ListUserPoolsRequest): Flow<ListUserPoolsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listUserPoolsPaginated.listUserPools(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListUserPoolsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUserPoolsResponse]
 */
public fun CognitoIdentityProviderClient.listUserPoolsPaginated(block: ListUserPoolsRequest.Builder.() -> Unit): Flow<ListUserPoolsResponse> =
    listUserPoolsPaginated(ListUserPoolsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listUserPoolsPaginated]
 * to access the nested member [UserPoolDescriptionType]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [UserPoolDescriptionType]
 */
@JvmName("listUserPoolsResponseUserPoolDescriptionType")
public fun Flow<ListUserPoolsResponse>.userPools(): Flow<UserPoolDescriptionType> =
    transform() { response ->
        response.userPools?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListUsersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListUsersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUsersResponse]
 */
public fun CognitoIdentityProviderClient.listUsersPaginated(initialRequest: ListUsersRequest): Flow<ListUsersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.paginationToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.paginationToken = cursor
            }
            val result = this@listUsersPaginated.listUsers(req)
            cursor = result.paginationToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListUsersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUsersResponse]
 */
public fun CognitoIdentityProviderClient.listUsersPaginated(block: ListUsersRequest.Builder.() -> Unit): Flow<ListUsersResponse> =
    listUsersPaginated(ListUsersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listUsersPaginated]
 * to access the nested member [UserType]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [UserType]
 */
@JvmName("listUsersResponseUserType")
public fun Flow<ListUsersResponse>.users(): Flow<UserType> =
    transform() { response ->
        response.users?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListUsersInGroupResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListUsersInGroupRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUsersInGroupResponse]
 */
public fun CognitoIdentityProviderClient.listUsersInGroupPaginated(initialRequest: ListUsersInGroupRequest): Flow<ListUsersInGroupResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listUsersInGroupPaginated.listUsersInGroup(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListUsersInGroupResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUsersInGroupResponse]
 */
public fun CognitoIdentityProviderClient.listUsersInGroupPaginated(block: ListUsersInGroupRequest.Builder.() -> Unit): Flow<ListUsersInGroupResponse> =
    listUsersInGroupPaginated(ListUsersInGroupRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listUsersInGroupPaginated]
 * to access the nested member [UserType]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [UserType]
 */
@JvmName("listUsersInGroupResponseUserType")
public fun Flow<ListUsersInGroupResponse>.users(): Flow<UserType> =
    transform() { response ->
        response.users?.forEach {
            emit(it)
        }
    }
