// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The username configuration type.
 */
public class UsernameConfigurationType private constructor(builder: Builder) {
    /**
     * Specifies whether user name case sensitivity will be applied for all users in the user pool through Amazon Cognito APIs. For most use cases, set case sensitivity to `False` (case insensitive) as a best practice. When usernames and email addresses are case insensitive, users can sign in as the same user when they enter a different capitalization of their user name.
     *
     * Valid values include:
     *
     * ## True
     * Enables case sensitivity for all username input. When this option is set to `True`, users must sign in using the exact capitalization of their given username, such as “UserName”. This is the default value.
     *
     * ## False
     * Enables case insensitivity for all username input. For example, when this option is set to `False`, users can sign in using `username`, `USERNAME`, or `UserName`. This option also enables both `preferred_username` and `email` alias to be case insensitive, in addition to the `username` attribute.
     */
    public val caseSensitive: kotlin.Boolean = requireNotNull(builder.caseSensitive) { "A non-null value must be provided for caseSensitive" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.UsernameConfigurationType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UsernameConfigurationType(")
        append("caseSensitive=$caseSensitive")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = caseSensitive.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UsernameConfigurationType

        if (caseSensitive != other.caseSensitive) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.UsernameConfigurationType = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies whether user name case sensitivity will be applied for all users in the user pool through Amazon Cognito APIs. For most use cases, set case sensitivity to `False` (case insensitive) as a best practice. When usernames and email addresses are case insensitive, users can sign in as the same user when they enter a different capitalization of their user name.
         *
         * Valid values include:
         *
         * ## True
         * Enables case sensitivity for all username input. When this option is set to `True`, users must sign in using the exact capitalization of their given username, such as “UserName”. This is the default value.
         *
         * ## False
         * Enables case insensitivity for all username input. For example, when this option is set to `False`, users can sign in using `username`, `USERNAME`, or `UserName`. This option also enables both `preferred_username` and `email` alias to be case insensitive, in addition to the `username` attribute.
         */
        public var caseSensitive: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.UsernameConfigurationType) : this() {
            this.caseSensitive = x.caseSensitive
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.UsernameConfigurationType = UsernameConfigurationType(this)

        internal fun correctErrors(): Builder {
            if (caseSensitive == null) caseSensitive = false
            return this
        }
    }
}
