// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents the request to update user attributes.
 */
public class UpdateUserAttributesRequest private constructor(builder: Builder) {
    /**
     * A valid access token that Amazon Cognito issued to the user whose user attributes you want to update.
     */
    public val accessToken: kotlin.String? = builder.accessToken
    /**
     * A map of custom key-value pairs that you can provide as input for any custom workflows that this action initiates.
     *
     * You create custom workflows by assigning Lambda functions to user pool triggers. When you use the UpdateUserAttributes API action, Amazon Cognito invokes the function that is assigned to the *custom message* trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a `clientMetadata` attribute, which provides the data that you assigned to the ClientMetadata parameter in your UpdateUserAttributes request. In your function code in Lambda, you can process the `clientMetadata` value to enhance your workflow for your specific needs.
     *
     * For more information, see [ Customizing user pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html) in the *Amazon Cognito Developer Guide*.
     *
     * When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:
     * + Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.
     * + Validate the ClientMetadata value.
     * + Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.
     */
    public val clientMetadata: Map<String, String>? = builder.clientMetadata
    /**
     * An array of name-value pairs representing user attributes.
     *
     * For custom attributes, you must prepend the `custom:` prefix to the attribute name.
     *
     * If you have set an attribute to require verification before Amazon Cognito updates its value, this request doesn’t immediately update the value of that attribute. After your user receives and responds to a verification message to verify the new value, Amazon Cognito updates the attribute value. Your user can sign in and receive messages with the original attribute value until they verify the new value.
     */
    public val userAttributes: List<AttributeType>? = builder.userAttributes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.UpdateUserAttributesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateUserAttributesRequest(")
        append("accessToken=*** Sensitive Data Redacted ***,")
        append("clientMetadata=$clientMetadata,")
        append("userAttributes=$userAttributes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessToken?.hashCode() ?: 0
        result = 31 * result + (clientMetadata?.hashCode() ?: 0)
        result = 31 * result + (userAttributes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateUserAttributesRequest

        if (accessToken != other.accessToken) return false
        if (clientMetadata != other.clientMetadata) return false
        if (userAttributes != other.userAttributes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.UpdateUserAttributesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A valid access token that Amazon Cognito issued to the user whose user attributes you want to update.
         */
        public var accessToken: kotlin.String? = null
        /**
         * A map of custom key-value pairs that you can provide as input for any custom workflows that this action initiates.
         *
         * You create custom workflows by assigning Lambda functions to user pool triggers. When you use the UpdateUserAttributes API action, Amazon Cognito invokes the function that is assigned to the *custom message* trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a `clientMetadata` attribute, which provides the data that you assigned to the ClientMetadata parameter in your UpdateUserAttributes request. In your function code in Lambda, you can process the `clientMetadata` value to enhance your workflow for your specific needs.
         *
         * For more information, see [ Customizing user pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html) in the *Amazon Cognito Developer Guide*.
         *
         * When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:
         * + Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.
         * + Validate the ClientMetadata value.
         * + Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.
         */
        public var clientMetadata: Map<String, String>? = null
        /**
         * An array of name-value pairs representing user attributes.
         *
         * For custom attributes, you must prepend the `custom:` prefix to the attribute name.
         *
         * If you have set an attribute to require verification before Amazon Cognito updates its value, this request doesn’t immediately update the value of that attribute. After your user receives and responds to a verification message to verify the new value, Amazon Cognito updates the attribute value. Your user can sign in and receive messages with the original attribute value until they verify the new value.
         */
        public var userAttributes: List<AttributeType>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.UpdateUserAttributesRequest) : this() {
            this.accessToken = x.accessToken
            this.clientMetadata = x.clientMetadata
            this.userAttributes = x.userAttributes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.UpdateUserAttributesRequest = UpdateUserAttributesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
