// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A container for the UI customization information for a user pool's built-in app UI.
 */
public class UiCustomizationType private constructor(builder: Builder) {
    /**
     * The client ID for the client app.
     */
    public val clientId: kotlin.String? = builder.clientId
    /**
     * The date and time when the item was created. Amazon Cognito returns this timestamp in UNIX epoch time format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java `Date` object.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * The CSS values in the UI customization.
     */
    public val css: kotlin.String? = builder.css
    /**
     * The CSS version number.
     */
    public val cssVersion: kotlin.String? = builder.cssVersion
    /**
     * The logo image for the UI customization.
     */
    public val imageUrl: kotlin.String? = builder.imageUrl
    /**
     * The date and time when the item was modified. Amazon Cognito returns this timestamp in UNIX epoch time format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java `Date` object.
     */
    public val lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedDate
    /**
     * The user pool ID for the user pool.
     */
    public val userPoolId: kotlin.String? = builder.userPoolId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.UiCustomizationType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UiCustomizationType(")
        append("clientId=*** Sensitive Data Redacted ***,")
        append("creationDate=$creationDate,")
        append("css=$css,")
        append("cssVersion=$cssVersion,")
        append("imageUrl=$imageUrl,")
        append("lastModifiedDate=$lastModifiedDate,")
        append("userPoolId=$userPoolId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientId?.hashCode() ?: 0
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (css?.hashCode() ?: 0)
        result = 31 * result + (cssVersion?.hashCode() ?: 0)
        result = 31 * result + (imageUrl?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (userPoolId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UiCustomizationType

        if (clientId != other.clientId) return false
        if (creationDate != other.creationDate) return false
        if (css != other.css) return false
        if (cssVersion != other.cssVersion) return false
        if (imageUrl != other.imageUrl) return false
        if (lastModifiedDate != other.lastModifiedDate) return false
        if (userPoolId != other.userPoolId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.UiCustomizationType = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The client ID for the client app.
         */
        public var clientId: kotlin.String? = null
        /**
         * The date and time when the item was created. Amazon Cognito returns this timestamp in UNIX epoch time format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java `Date` object.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The CSS values in the UI customization.
         */
        public var css: kotlin.String? = null
        /**
         * The CSS version number.
         */
        public var cssVersion: kotlin.String? = null
        /**
         * The logo image for the UI customization.
         */
        public var imageUrl: kotlin.String? = null
        /**
         * The date and time when the item was modified. Amazon Cognito returns this timestamp in UNIX epoch time format. Your SDK might render the output in a human-readable format like ISO 8601 or a Java `Date` object.
         */
        public var lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The user pool ID for the user pool.
         */
        public var userPoolId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.UiCustomizationType) : this() {
            this.clientId = x.clientId
            this.creationDate = x.creationDate
            this.css = x.css
            this.cssVersion = x.cssVersion
            this.imageUrl = x.imageUrl
            this.lastModifiedDate = x.lastModifiedDate
            this.userPoolId = x.userPoolId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.UiCustomizationType = UiCustomizationType(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
