// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The password policy type.
 */
public class PasswordPolicyType private constructor(builder: Builder) {
    /**
     * The minimum length of the password in the policy that you have set. This value can't be less than 6.
     */
    public val minimumLength: kotlin.Int? = builder.minimumLength
    /**
     * In the password policy that you have set, refers to whether you have required users to use at least one lowercase letter in their password.
     */
    public val requireLowercase: kotlin.Boolean = builder.requireLowercase
    /**
     * In the password policy that you have set, refers to whether you have required users to use at least one number in their password.
     */
    public val requireNumbers: kotlin.Boolean = builder.requireNumbers
    /**
     * In the password policy that you have set, refers to whether you have required users to use at least one symbol in their password.
     */
    public val requireSymbols: kotlin.Boolean = builder.requireSymbols
    /**
     * In the password policy that you have set, refers to whether you have required users to use at least one uppercase letter in their password.
     */
    public val requireUppercase: kotlin.Boolean = builder.requireUppercase
    /**
     * The number of days a temporary password is valid in the password policy. If the user doesn't sign in during this time, an administrator must reset their password. Defaults to `7`. If you submit a value of `0`, Amazon Cognito treats it as a null value and sets `TemporaryPasswordValidityDays` to its default value.
     *
     * When you set `TemporaryPasswordValidityDays` for a user pool, you can no longer set a value for the legacy `UnusedAccountValidityDays` parameter in that user pool.
     */
    public val temporaryPasswordValidityDays: kotlin.Int = builder.temporaryPasswordValidityDays

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.PasswordPolicyType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PasswordPolicyType(")
        append("minimumLength=$minimumLength,")
        append("requireLowercase=$requireLowercase,")
        append("requireNumbers=$requireNumbers,")
        append("requireSymbols=$requireSymbols,")
        append("requireUppercase=$requireUppercase,")
        append("temporaryPasswordValidityDays=$temporaryPasswordValidityDays")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = minimumLength ?: 0
        result = 31 * result + (requireLowercase.hashCode())
        result = 31 * result + (requireNumbers.hashCode())
        result = 31 * result + (requireSymbols.hashCode())
        result = 31 * result + (requireUppercase.hashCode())
        result = 31 * result + (temporaryPasswordValidityDays)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PasswordPolicyType

        if (minimumLength != other.minimumLength) return false
        if (requireLowercase != other.requireLowercase) return false
        if (requireNumbers != other.requireNumbers) return false
        if (requireSymbols != other.requireSymbols) return false
        if (requireUppercase != other.requireUppercase) return false
        if (temporaryPasswordValidityDays != other.temporaryPasswordValidityDays) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.PasswordPolicyType = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The minimum length of the password in the policy that you have set. This value can't be less than 6.
         */
        public var minimumLength: kotlin.Int? = null
        /**
         * In the password policy that you have set, refers to whether you have required users to use at least one lowercase letter in their password.
         */
        public var requireLowercase: kotlin.Boolean = false
        /**
         * In the password policy that you have set, refers to whether you have required users to use at least one number in their password.
         */
        public var requireNumbers: kotlin.Boolean = false
        /**
         * In the password policy that you have set, refers to whether you have required users to use at least one symbol in their password.
         */
        public var requireSymbols: kotlin.Boolean = false
        /**
         * In the password policy that you have set, refers to whether you have required users to use at least one uppercase letter in their password.
         */
        public var requireUppercase: kotlin.Boolean = false
        /**
         * The number of days a temporary password is valid in the password policy. If the user doesn't sign in during this time, an administrator must reset their password. Defaults to `7`. If you submit a value of `0`, Amazon Cognito treats it as a null value and sets `TemporaryPasswordValidityDays` to its default value.
         *
         * When you set `TemporaryPasswordValidityDays` for a user pool, you can no longer set a value for the legacy `UnusedAccountValidityDays` parameter in that user pool.
         */
        public var temporaryPasswordValidityDays: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.PasswordPolicyType) : this() {
            this.minimumLength = x.minimumLength
            this.requireLowercase = x.requireLowercase
            this.requireNumbers = x.requireNumbers
            this.requireSymbols = x.requireSymbols
            this.requireUppercase = x.requireUppercase
            this.temporaryPasswordValidityDays = x.temporaryPasswordValidityDays
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.PasswordPolicyType = PasswordPolicyType(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
