// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The response from the request to list users.
 */
public class ListUsersResponse private constructor(builder: Builder) {
    /**
     * The identifier that Amazon Cognito returned with the previous request to this operation. When you include a pagination token in your request, Amazon Cognito returns the next set of items in the list. By use of this token, you can paginate through the full list of items.
     */
    public val paginationToken: kotlin.String? = builder.paginationToken
    /**
     * A list of the user pool users, and their attributes, that match your query.
     *
     * Amazon Cognito creates a profile in your user pool for each native user in your user pool, and each unique user ID from your third-party identity providers (IdPs). When you link users with the [AdminLinkProviderForUser](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminLinkProviderForUser.html) API operation, the output of `ListUsers` displays both the IdP user and the native user that you linked. You can identify IdP users in the `Users` object of this API response by the IdP prefix that Amazon Cognito appends to `Username`.
     */
    public val users: List<UserType>? = builder.users

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.ListUsersResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListUsersResponse(")
        append("paginationToken=$paginationToken,")
        append("users=$users")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = paginationToken?.hashCode() ?: 0
        result = 31 * result + (users?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListUsersResponse

        if (paginationToken != other.paginationToken) return false
        if (users != other.users) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.ListUsersResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier that Amazon Cognito returned with the previous request to this operation. When you include a pagination token in your request, Amazon Cognito returns the next set of items in the list. By use of this token, you can paginate through the full list of items.
         */
        public var paginationToken: kotlin.String? = null
        /**
         * A list of the user pool users, and their attributes, that match your query.
         *
         * Amazon Cognito creates a profile in your user pool for each native user in your user pool, and each unique user ID from your third-party identity providers (IdPs). When you link users with the [AdminLinkProviderForUser](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminLinkProviderForUser.html) API operation, the output of `ListUsers` displays both the IdP user and the native user that you linked. You can identify IdP users in the `Users` object of this API response by the IdP prefix that Amazon Cognito appends to `Username`.
         */
        public var users: List<UserType>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.ListUsersResponse) : this() {
            this.paginationToken = x.paginationToken
            this.users = x.users
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.ListUsersResponse = ListUsersResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
