// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents the request to list the user import jobs.
 */
public class ListUserImportJobsRequest private constructor(builder: Builder) {
    /**
     * The maximum number of import jobs you want the request to return.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * This API operation returns a limited number of results. The pagination token is an identifier that you can present in an additional API request with the same parameters. When you include the pagination token, Amazon Cognito returns the next set of items after the current list. Subsequent requests return a new pagination token. By use of this token, you can paginate through the full list of items.
     */
    public val paginationToken: kotlin.String? = builder.paginationToken
    /**
     * The user pool ID for the user pool that the users are being imported into.
     */
    public val userPoolId: kotlin.String? = builder.userPoolId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.ListUserImportJobsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListUserImportJobsRequest(")
        append("maxResults=$maxResults,")
        append("paginationToken=$paginationToken,")
        append("userPoolId=$userPoolId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (paginationToken?.hashCode() ?: 0)
        result = 31 * result + (userPoolId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListUserImportJobsRequest

        if (maxResults != other.maxResults) return false
        if (paginationToken != other.paginationToken) return false
        if (userPoolId != other.userPoolId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.ListUserImportJobsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The maximum number of import jobs you want the request to return.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * This API operation returns a limited number of results. The pagination token is an identifier that you can present in an additional API request with the same parameters. When you include the pagination token, Amazon Cognito returns the next set of items after the current list. Subsequent requests return a new pagination token. By use of this token, you can paginate through the full list of items.
         */
        public var paginationToken: kotlin.String? = null
        /**
         * The user pool ID for the user pool that the users are being imported into.
         */
        public var userPoolId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.ListUserImportJobsRequest) : this() {
            this.maxResults = x.maxResults
            this.paginationToken = x.paginationToken
            this.userPoolId = x.userPoolId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.ListUserImportJobsRequest = ListUserImportJobsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
