// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents the request to list the devices.
 */
public class ListDevicesRequest private constructor(builder: Builder) {
    /**
     * A valid access token that Amazon Cognito issued to the user whose list of devices you want to view.
     */
    public val accessToken: kotlin.String? = builder.accessToken
    /**
     * The limit of the device request.
     */
    public val limit: kotlin.Int? = builder.limit
    /**
     * This API operation returns a limited number of results. The pagination token is an identifier that you can present in an additional API request with the same parameters. When you include the pagination token, Amazon Cognito returns the next set of items after the current list. Subsequent requests return a new pagination token. By use of this token, you can paginate through the full list of items.
     */
    public val paginationToken: kotlin.String? = builder.paginationToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.ListDevicesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListDevicesRequest(")
        append("accessToken=*** Sensitive Data Redacted ***,")
        append("limit=$limit,")
        append("paginationToken=$paginationToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessToken?.hashCode() ?: 0
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (paginationToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListDevicesRequest

        if (accessToken != other.accessToken) return false
        if (limit != other.limit) return false
        if (paginationToken != other.paginationToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.ListDevicesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A valid access token that Amazon Cognito issued to the user whose list of devices you want to view.
         */
        public var accessToken: kotlin.String? = null
        /**
         * The limit of the device request.
         */
        public var limit: kotlin.Int? = null
        /**
         * This API operation returns a limited number of results. The pagination token is an identifier that you can present in an additional API request with the same parameters. When you include the pagination token, Amazon Cognito returns the next set of items after the current list. Subsequent requests return a new pagination token. By use of this token, you can paginate through the full list of items.
         */
        public var paginationToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.ListDevicesRequest) : this() {
            this.accessToken = x.accessToken
            this.limit = x.limit
            this.paginationToken = x.paginationToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.ListDevicesRequest = ListDevicesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
