// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents the request to delete user attributes.
 */
public class DeleteUserAttributesRequest private constructor(builder: Builder) {
    /**
     * A valid access token that Amazon Cognito issued to the user whose attributes you want to delete.
     */
    public val accessToken: kotlin.String? = builder.accessToken
    /**
     * An array of strings representing the user attribute names you want to delete.
     *
     * For custom attributes, you must prependattach the `custom:` prefix to the front of the attribute name.
     */
    public val userAttributeNames: List<String>? = builder.userAttributeNames

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.DeleteUserAttributesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteUserAttributesRequest(")
        append("accessToken=*** Sensitive Data Redacted ***,")
        append("userAttributeNames=$userAttributeNames")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessToken?.hashCode() ?: 0
        result = 31 * result + (userAttributeNames?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteUserAttributesRequest

        if (accessToken != other.accessToken) return false
        if (userAttributeNames != other.userAttributeNames) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.DeleteUserAttributesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A valid access token that Amazon Cognito issued to the user whose attributes you want to delete.
         */
        public var accessToken: kotlin.String? = null
        /**
         * An array of strings representing the user attribute names you want to delete.
         *
         * For custom attributes, you must prependattach the `custom:` prefix to the front of the attribute name.
         */
        public var userAttributeNames: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.DeleteUserAttributesRequest) : this() {
            this.accessToken = x.accessToken
            this.userAttributeNames = x.userAttributeNames
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.DeleteUserAttributesRequest = DeleteUserAttributesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
