// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateUserPoolDomainRequest private constructor(builder: Builder) {
    /**
     * The configuration for a custom domain that hosts the sign-up and sign-in webpages for your application.
     *
     * Provide this parameter only if you want to use a custom domain for your user pool. Otherwise, you can exclude this parameter and use the Amazon Cognito hosted domain instead.
     *
     * For more information about the hosted domain and custom domains, see [Configuring a User Pool Domain](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-assign-domain.html).
     */
    public val customDomainConfig: aws.sdk.kotlin.services.cognitoidentityprovider.model.CustomDomainConfigType? = builder.customDomainConfig
    /**
     * The domain string. For custom domains, this is the fully-qualified domain name, such as `auth.example.com`. For Amazon Cognito prefix domains, this is the prefix alone, such as `auth`.
     */
    public val domain: kotlin.String? = builder.domain
    /**
     * The user pool ID.
     */
    public val userPoolId: kotlin.String? = builder.userPoolId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateUserPoolDomainRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateUserPoolDomainRequest(")
        append("customDomainConfig=$customDomainConfig,")
        append("domain=$domain,")
        append("userPoolId=$userPoolId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = customDomainConfig?.hashCode() ?: 0
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (userPoolId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateUserPoolDomainRequest

        if (customDomainConfig != other.customDomainConfig) return false
        if (domain != other.domain) return false
        if (userPoolId != other.userPoolId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateUserPoolDomainRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The configuration for a custom domain that hosts the sign-up and sign-in webpages for your application.
         *
         * Provide this parameter only if you want to use a custom domain for your user pool. Otherwise, you can exclude this parameter and use the Amazon Cognito hosted domain instead.
         *
         * For more information about the hosted domain and custom domains, see [Configuring a User Pool Domain](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-assign-domain.html).
         */
        public var customDomainConfig: aws.sdk.kotlin.services.cognitoidentityprovider.model.CustomDomainConfigType? = null
        /**
         * The domain string. For custom domains, this is the fully-qualified domain name, such as `auth.example.com`. For Amazon Cognito prefix domains, this is the prefix alone, such as `auth`.
         */
        public var domain: kotlin.String? = null
        /**
         * The user pool ID.
         */
        public var userPoolId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateUserPoolDomainRequest) : this() {
            this.customDomainConfig = x.customDomainConfig
            this.domain = x.domain
            this.userPoolId = x.userPoolId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateUserPoolDomainRequest = CreateUserPoolDomainRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.CustomDomainConfigType] inside the given [block]
         */
        public fun customDomainConfig(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.CustomDomainConfigType.Builder.() -> kotlin.Unit) {
            this.customDomainConfig = aws.sdk.kotlin.services.cognitoidentityprovider.model.CustomDomainConfigType.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
