// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contextual user data type used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.
 */
public class ContextDataType private constructor(builder: Builder) {
    /**
     * Encoded device-fingerprint details that your app collected with the Amazon Cognito context data collection library. For more information, see [Adding user device and session data to API requests](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-adaptive-authentication.html#user-pool-settings-adaptive-authentication-device-fingerprint).
     */
    public val encodedData: kotlin.String? = builder.encodedData
    /**
     * HttpHeaders received on your server in same order.
     */
    public val httpHeaders: List<HttpHeader> = requireNotNull(builder.httpHeaders) { "A non-null value must be provided for httpHeaders" }
    /**
     * The source IP address of your user's device.
     */
    public val ipAddress: kotlin.String = requireNotNull(builder.ipAddress) { "A non-null value must be provided for ipAddress" }
    /**
     * Your server endpoint where this API is invoked.
     */
    public val serverName: kotlin.String = requireNotNull(builder.serverName) { "A non-null value must be provided for serverName" }
    /**
     * Your server path where this API is invoked.
     */
    public val serverPath: kotlin.String = requireNotNull(builder.serverPath) { "A non-null value must be provided for serverPath" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.ContextDataType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContextDataType(")
        append("encodedData=$encodedData,")
        append("httpHeaders=$httpHeaders,")
        append("ipAddress=$ipAddress,")
        append("serverName=$serverName,")
        append("serverPath=$serverPath")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = encodedData?.hashCode() ?: 0
        result = 31 * result + (httpHeaders.hashCode())
        result = 31 * result + (ipAddress.hashCode())
        result = 31 * result + (serverName.hashCode())
        result = 31 * result + (serverPath.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContextDataType

        if (encodedData != other.encodedData) return false
        if (httpHeaders != other.httpHeaders) return false
        if (ipAddress != other.ipAddress) return false
        if (serverName != other.serverName) return false
        if (serverPath != other.serverPath) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.ContextDataType = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Encoded device-fingerprint details that your app collected with the Amazon Cognito context data collection library. For more information, see [Adding user device and session data to API requests](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-adaptive-authentication.html#user-pool-settings-adaptive-authentication-device-fingerprint).
         */
        public var encodedData: kotlin.String? = null
        /**
         * HttpHeaders received on your server in same order.
         */
        public var httpHeaders: List<HttpHeader>? = null
        /**
         * The source IP address of your user's device.
         */
        public var ipAddress: kotlin.String? = null
        /**
         * Your server endpoint where this API is invoked.
         */
        public var serverName: kotlin.String? = null
        /**
         * Your server path where this API is invoked.
         */
        public var serverPath: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.ContextDataType) : this() {
            this.encodedData = x.encodedData
            this.httpHeaders = x.httpHeaders
            this.ipAddress = x.ipAddress
            this.serverName = x.serverName
            this.serverPath = x.serverPath
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.ContextDataType = ContextDataType(this)

        internal fun correctErrors(): Builder {
            if (httpHeaders == null) httpHeaders = emptyList()
            if (ipAddress == null) ipAddress = ""
            if (serverName == null) serverName = ""
            if (serverPath == null) serverPath = ""
            return this
        }
    }
}
