// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents the request to confirm registration of a user.
 */
public class ConfirmSignUpRequest private constructor(builder: Builder) {
    /**
     * The Amazon Pinpoint analytics metadata for collecting metrics for `ConfirmSignUp` calls.
     */
    public val analyticsMetadata: aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsMetadataType? = builder.analyticsMetadata
    /**
     * The ID of the app client associated with the user pool.
     */
    public val clientId: kotlin.String? = builder.clientId
    /**
     * A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.
     *
     * You create custom workflows by assigning Lambda functions to user pool triggers. When you use the ConfirmSignUp API action, Amazon Cognito invokes the function that is assigned to the *post confirmation* trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a `clientMetadata` attribute, which provides the data that you assigned to the ClientMetadata parameter in your ConfirmSignUp request. In your function code in Lambda, you can process the `clientMetadata` value to enhance your workflow for your specific needs.
     *
     * For more information, see [ Customizing user pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html) in the *Amazon Cognito Developer Guide*.
     *
     * When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:
     * + Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.
     * + Validate the ClientMetadata value.
     * + Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.
     */
    public val clientMetadata: Map<String, String>? = builder.clientMetadata
    /**
     * The confirmation code sent by a user's request to confirm registration.
     */
    public val confirmationCode: kotlin.String? = builder.confirmationCode
    /**
     * Boolean to be specified to force user confirmation irrespective of existing alias. By default set to `False`. If this parameter is set to `True` and the phone number/email used for sign up confirmation already exists as an alias with a different user, the API call will migrate the alias from the previous user to the newly created user being confirmed. If set to `False`, the API will throw an **AliasExistsException** error.
     */
    public val forceAliasCreation: kotlin.Boolean? = builder.forceAliasCreation
    /**
     * A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.
     */
    public val secretHash: kotlin.String? = builder.secretHash
    /**
     * Contextual data about your user session, such as the device fingerprint, IP address, or location. Amazon Cognito advanced security evaluates the risk of an authentication event based on the context that your app generates and passes to Amazon Cognito when it makes API requests.
     */
    public val userContextData: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserContextDataType? = builder.userContextData
    /**
     * The username of the user that you want to query or modify. The value of this parameter is typically your user's username, but it can be any of their alias attributes. If `username` isn't an alias attribute in your user pool, this value must be the `sub` of a local user or the username of a user from a third-party IdP.
     */
    public val username: kotlin.String? = builder.username

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.ConfirmSignUpRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConfirmSignUpRequest(")
        append("analyticsMetadata=$analyticsMetadata,")
        append("clientId=*** Sensitive Data Redacted ***,")
        append("clientMetadata=$clientMetadata,")
        append("confirmationCode=$confirmationCode,")
        append("forceAliasCreation=$forceAliasCreation,")
        append("secretHash=*** Sensitive Data Redacted ***,")
        append("userContextData=*** Sensitive Data Redacted ***,")
        append("username=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = analyticsMetadata?.hashCode() ?: 0
        result = 31 * result + (clientId?.hashCode() ?: 0)
        result = 31 * result + (clientMetadata?.hashCode() ?: 0)
        result = 31 * result + (confirmationCode?.hashCode() ?: 0)
        result = 31 * result + (forceAliasCreation?.hashCode() ?: 0)
        result = 31 * result + (secretHash?.hashCode() ?: 0)
        result = 31 * result + (userContextData?.hashCode() ?: 0)
        result = 31 * result + (username?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConfirmSignUpRequest

        if (analyticsMetadata != other.analyticsMetadata) return false
        if (clientId != other.clientId) return false
        if (clientMetadata != other.clientMetadata) return false
        if (confirmationCode != other.confirmationCode) return false
        if (forceAliasCreation != other.forceAliasCreation) return false
        if (secretHash != other.secretHash) return false
        if (userContextData != other.userContextData) return false
        if (username != other.username) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.ConfirmSignUpRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Pinpoint analytics metadata for collecting metrics for `ConfirmSignUp` calls.
         */
        public var analyticsMetadata: aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsMetadataType? = null
        /**
         * The ID of the app client associated with the user pool.
         */
        public var clientId: kotlin.String? = null
        /**
         * A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.
         *
         * You create custom workflows by assigning Lambda functions to user pool triggers. When you use the ConfirmSignUp API action, Amazon Cognito invokes the function that is assigned to the *post confirmation* trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a `clientMetadata` attribute, which provides the data that you assigned to the ClientMetadata parameter in your ConfirmSignUp request. In your function code in Lambda, you can process the `clientMetadata` value to enhance your workflow for your specific needs.
         *
         * For more information, see [ Customizing user pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html) in the *Amazon Cognito Developer Guide*.
         *
         * When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:
         * + Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.
         * + Validate the ClientMetadata value.
         * + Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.
         */
        public var clientMetadata: Map<String, String>? = null
        /**
         * The confirmation code sent by a user's request to confirm registration.
         */
        public var confirmationCode: kotlin.String? = null
        /**
         * Boolean to be specified to force user confirmation irrespective of existing alias. By default set to `False`. If this parameter is set to `True` and the phone number/email used for sign up confirmation already exists as an alias with a different user, the API call will migrate the alias from the previous user to the newly created user being confirmed. If set to `False`, the API will throw an **AliasExistsException** error.
         */
        public var forceAliasCreation: kotlin.Boolean? = null
        /**
         * A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message.
         */
        public var secretHash: kotlin.String? = null
        /**
         * Contextual data about your user session, such as the device fingerprint, IP address, or location. Amazon Cognito advanced security evaluates the risk of an authentication event based on the context that your app generates and passes to Amazon Cognito when it makes API requests.
         */
        public var userContextData: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserContextDataType? = null
        /**
         * The username of the user that you want to query or modify. The value of this parameter is typically your user's username, but it can be any of their alias attributes. If `username` isn't an alias attribute in your user pool, this value must be the `sub` of a local user or the username of a user from a third-party IdP.
         */
        public var username: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.ConfirmSignUpRequest) : this() {
            this.analyticsMetadata = x.analyticsMetadata
            this.clientId = x.clientId
            this.clientMetadata = x.clientMetadata
            this.confirmationCode = x.confirmationCode
            this.forceAliasCreation = x.forceAliasCreation
            this.secretHash = x.secretHash
            this.userContextData = x.userContextData
            this.username = x.username
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.ConfirmSignUpRequest = ConfirmSignUpRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsMetadataType] inside the given [block]
         */
        public fun analyticsMetadata(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsMetadataType.Builder.() -> kotlin.Unit) {
            this.analyticsMetadata = aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsMetadataType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.UserContextDataType] inside the given [block]
         */
        public fun userContextData(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserContextDataType.Builder.() -> kotlin.Unit) {
            this.userContextData = aws.sdk.kotlin.services.cognitoidentityprovider.model.UserContextDataType.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
