// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The Amazon Pinpoint analytics configuration necessary to collect metrics for a user pool.
 *
 * In Regions where Amazon Pinpoint isn't available, user pools only support sending events to Amazon Pinpoint projects in us-east-1. In Regions where Amazon Pinpoint is available, user pools support sending events to Amazon Pinpoint projects within that same Region.
 */
public class AnalyticsConfigurationType private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of an Amazon Pinpoint project. You can use the Amazon Pinpoint project to integrate with the chosen user pool Client. Amazon Cognito publishes events to the Amazon Pinpoint project that the app ARN declares.
     */
    public val applicationArn: kotlin.String? = builder.applicationArn
    /**
     * The application ID for an Amazon Pinpoint application.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * The external ID.
     */
    public val externalId: kotlin.String? = builder.externalId
    /**
     * The ARN of an Identity and Access Management role that authorizes Amazon Cognito to publish events to Amazon Pinpoint analytics.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * If `UserDataShared` is `true`, Amazon Cognito includes user data in the events that it publishes to Amazon Pinpoint analytics.
     */
    public val userDataShared: kotlin.Boolean = builder.userDataShared

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsConfigurationType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AnalyticsConfigurationType(")
        append("applicationArn=$applicationArn,")
        append("applicationId=$applicationId,")
        append("externalId=$externalId,")
        append("roleArn=$roleArn,")
        append("userDataShared=$userDataShared")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationArn?.hashCode() ?: 0
        result = 31 * result + (applicationId?.hashCode() ?: 0)
        result = 31 * result + (externalId?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (userDataShared.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AnalyticsConfigurationType

        if (applicationArn != other.applicationArn) return false
        if (applicationId != other.applicationId) return false
        if (externalId != other.externalId) return false
        if (roleArn != other.roleArn) return false
        if (userDataShared != other.userDataShared) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsConfigurationType = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of an Amazon Pinpoint project. You can use the Amazon Pinpoint project to integrate with the chosen user pool Client. Amazon Cognito publishes events to the Amazon Pinpoint project that the app ARN declares.
         */
        public var applicationArn: kotlin.String? = null
        /**
         * The application ID for an Amazon Pinpoint application.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The external ID.
         */
        public var externalId: kotlin.String? = null
        /**
         * The ARN of an Identity and Access Management role that authorizes Amazon Cognito to publish events to Amazon Pinpoint analytics.
         */
        public var roleArn: kotlin.String? = null
        /**
         * If `UserDataShared` is `true`, Amazon Cognito includes user data in the events that it publishes to Amazon Pinpoint analytics.
         */
        public var userDataShared: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsConfigurationType) : this() {
            this.applicationArn = x.applicationArn
            this.applicationId = x.applicationId
            this.externalId = x.externalId
            this.roleArn = x.roleArn
            this.userDataShared = x.userDataShared
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsConfigurationType = AnalyticsConfigurationType(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
