// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents the request to list devices, as an administrator.
 */
public class AdminListDevicesRequest private constructor(builder: Builder) {
    /**
     * The limit of the devices request.
     */
    public val limit: kotlin.Int? = builder.limit
    /**
     * This API operation returns a limited number of results. The pagination token is an identifier that you can present in an additional API request with the same parameters. When you include the pagination token, Amazon Cognito returns the next set of items after the current list. Subsequent requests return a new pagination token. By use of this token, you can paginate through the full list of items.
     */
    public val paginationToken: kotlin.String? = builder.paginationToken
    /**
     * The user pool ID.
     */
    public val userPoolId: kotlin.String? = builder.userPoolId
    /**
     * The username of the user that you want to query or modify. The value of this parameter is typically your user's username, but it can be any of their alias attributes. If `username` isn't an alias attribute in your user pool, this value must be the `sub` of a local user or the username of a user from a third-party IdP.
     */
    public val username: kotlin.String? = builder.username

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminListDevicesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AdminListDevicesRequest(")
        append("limit=$limit,")
        append("paginationToken=$paginationToken,")
        append("userPoolId=$userPoolId,")
        append("username=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = limit ?: 0
        result = 31 * result + (paginationToken?.hashCode() ?: 0)
        result = 31 * result + (userPoolId?.hashCode() ?: 0)
        result = 31 * result + (username?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AdminListDevicesRequest

        if (limit != other.limit) return false
        if (paginationToken != other.paginationToken) return false
        if (userPoolId != other.userPoolId) return false
        if (username != other.username) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminListDevicesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The limit of the devices request.
         */
        public var limit: kotlin.Int? = null
        /**
         * This API operation returns a limited number of results. The pagination token is an identifier that you can present in an additional API request with the same parameters. When you include the pagination token, Amazon Cognito returns the next set of items after the current list. Subsequent requests return a new pagination token. By use of this token, you can paginate through the full list of items.
         */
        public var paginationToken: kotlin.String? = null
        /**
         * The user pool ID.
         */
        public var userPoolId: kotlin.String? = null
        /**
         * The username of the user that you want to query or modify. The value of this parameter is typically your user's username, but it can be any of their alias attributes. If `username` isn't an alias attribute in your user pool, this value must be the `sub` of a local user or the username of a user from a third-party IdP.
         */
        public var username: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminListDevicesRequest) : this() {
            this.limit = x.limit
            this.paginationToken = x.paginationToken
            this.userPoolId = x.userPoolId
            this.username = x.username
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminListDevicesRequest = AdminListDevicesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
