// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model

import aws.smithy.kotlin.runtime.SdkDsl

public class AdminLinkProviderForUserRequest private constructor(builder: Builder) {
    /**
     * The existing user in the user pool that you want to assign to the external IdP user account. This user can be a local (Username + Password) Amazon Cognito user pools user or a federated user (for example, a SAML or Facebook user). If the user doesn't exist, Amazon Cognito generates an exception. Amazon Cognito returns this user when the new user (with the linked IdP attribute) signs in.
     *
     * For a native username + password user, the `ProviderAttributeValue` for the `DestinationUser` should be the username in the user pool. For a federated user, it should be the provider-specific `user_id`.
     *
     * The `ProviderAttributeName` of the `DestinationUser` is ignored.
     *
     * The `ProviderName` should be set to `Cognito` for users in Cognito user pools.
     *
     * All attributes in the DestinationUser profile must be mutable. If you have assigned the user any immutable custom attributes, the operation won't succeed.
     */
    public val destinationUser: aws.sdk.kotlin.services.cognitoidentityprovider.model.ProviderUserIdentifierType? = builder.destinationUser
    /**
     * An external IdP account for a user who doesn't exist yet in the user pool. This user must be a federated user (for example, a SAML or Facebook user), not another native user.
     *
     * If the `SourceUser` is using a federated social IdP, such as Facebook, Google, or Login with Amazon, you must set the `ProviderAttributeName` to `Cognito_Subject`. For social IdPs, the `ProviderName` will be `Facebook`, `Google`, or `LoginWithAmazon`, and Amazon Cognito will automatically parse the Facebook, Google, and Login with Amazon tokens for `id`, `sub`, and `user_id`, respectively. The `ProviderAttributeValue` for the user must be the same value as the `id`, `sub`, or `user_id` value found in the social IdP token.
     *
     * For OIDC, the `ProviderAttributeName` can be any value that matches a claim in the ID token, or that your app retrieves from the `userInfo` endpoint. You must map the claim to a user pool attribute in your IdP configuration, and set the user pool attribute name as the value of `ProviderAttributeName` in your `AdminLinkProviderForUser` request.
     *
     * For SAML, the `ProviderAttributeName` can be any value that matches a claim in the SAML assertion. To link SAML users based on the subject of the SAML assertion, map the subject to a claim through the SAML IdP and set that claim name as the value of `ProviderAttributeName` in your `AdminLinkProviderForUser` request.
     *
     * For both OIDC and SAML users, when you set `ProviderAttributeName` to `Cognito_Subject`, Amazon Cognito will automatically parse the default unique identifier found in the subject from the IdP token.
     */
    public val sourceUser: aws.sdk.kotlin.services.cognitoidentityprovider.model.ProviderUserIdentifierType? = builder.sourceUser
    /**
     * The user pool ID for the user pool.
     */
    public val userPoolId: kotlin.String? = builder.userPoolId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminLinkProviderForUserRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AdminLinkProviderForUserRequest(")
        append("destinationUser=$destinationUser,")
        append("sourceUser=$sourceUser,")
        append("userPoolId=$userPoolId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationUser?.hashCode() ?: 0
        result = 31 * result + (sourceUser?.hashCode() ?: 0)
        result = 31 * result + (userPoolId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AdminLinkProviderForUserRequest

        if (destinationUser != other.destinationUser) return false
        if (sourceUser != other.sourceUser) return false
        if (userPoolId != other.userPoolId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminLinkProviderForUserRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The existing user in the user pool that you want to assign to the external IdP user account. This user can be a local (Username + Password) Amazon Cognito user pools user or a federated user (for example, a SAML or Facebook user). If the user doesn't exist, Amazon Cognito generates an exception. Amazon Cognito returns this user when the new user (with the linked IdP attribute) signs in.
         *
         * For a native username + password user, the `ProviderAttributeValue` for the `DestinationUser` should be the username in the user pool. For a federated user, it should be the provider-specific `user_id`.
         *
         * The `ProviderAttributeName` of the `DestinationUser` is ignored.
         *
         * The `ProviderName` should be set to `Cognito` for users in Cognito user pools.
         *
         * All attributes in the DestinationUser profile must be mutable. If you have assigned the user any immutable custom attributes, the operation won't succeed.
         */
        public var destinationUser: aws.sdk.kotlin.services.cognitoidentityprovider.model.ProviderUserIdentifierType? = null
        /**
         * An external IdP account for a user who doesn't exist yet in the user pool. This user must be a federated user (for example, a SAML or Facebook user), not another native user.
         *
         * If the `SourceUser` is using a federated social IdP, such as Facebook, Google, or Login with Amazon, you must set the `ProviderAttributeName` to `Cognito_Subject`. For social IdPs, the `ProviderName` will be `Facebook`, `Google`, or `LoginWithAmazon`, and Amazon Cognito will automatically parse the Facebook, Google, and Login with Amazon tokens for `id`, `sub`, and `user_id`, respectively. The `ProviderAttributeValue` for the user must be the same value as the `id`, `sub`, or `user_id` value found in the social IdP token.
         *
         * For OIDC, the `ProviderAttributeName` can be any value that matches a claim in the ID token, or that your app retrieves from the `userInfo` endpoint. You must map the claim to a user pool attribute in your IdP configuration, and set the user pool attribute name as the value of `ProviderAttributeName` in your `AdminLinkProviderForUser` request.
         *
         * For SAML, the `ProviderAttributeName` can be any value that matches a claim in the SAML assertion. To link SAML users based on the subject of the SAML assertion, map the subject to a claim through the SAML IdP and set that claim name as the value of `ProviderAttributeName` in your `AdminLinkProviderForUser` request.
         *
         * For both OIDC and SAML users, when you set `ProviderAttributeName` to `Cognito_Subject`, Amazon Cognito will automatically parse the default unique identifier found in the subject from the IdP token.
         */
        public var sourceUser: aws.sdk.kotlin.services.cognitoidentityprovider.model.ProviderUserIdentifierType? = null
        /**
         * The user pool ID for the user pool.
         */
        public var userPoolId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminLinkProviderForUserRequest) : this() {
            this.destinationUser = x.destinationUser
            this.sourceUser = x.sourceUser
            this.userPoolId = x.userPoolId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminLinkProviderForUserRequest = AdminLinkProviderForUserRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.ProviderUserIdentifierType] inside the given [block]
         */
        public fun destinationUser(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.ProviderUserIdentifierType.Builder.() -> kotlin.Unit) {
            this.destinationUser = aws.sdk.kotlin.services.cognitoidentityprovider.model.ProviderUserIdentifierType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.ProviderUserIdentifierType] inside the given [block]
         */
        public fun sourceUser(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.ProviderUserIdentifierType.Builder.() -> kotlin.Unit) {
            this.sourceUser = aws.sdk.kotlin.services.cognitoidentityprovider.model.ProviderUserIdentifierType.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
